<?php

class Lunchlogs extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();

        $this->load->model("student_m");
        $this->load->model("lunch_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('lunch', $language);
    }
    
    public function index(){

        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );
        $filter = array(
            'date>='         =>  date('Y-m-d 00:00:00'),
            'date<='         =>  date('Y-m-d 23:59:59')
        );
        
        if($_GET){
            $filter = array(
                'date>='         =>  $this->input->get('start_date').' '.'00:00:00',
                'date<='         =>  $this->input->get('end_date').' '. '23:59:59'
            );
        }
        $this->data['get_all_holidays'] = $this->getHolidaysSession();
        $this->data['lunchLogs'] = $this->lunch_m->getData($filter);
        $this->data['lunchLogss'] = $this->lunch_m->getData();
        
        if($_GET){
            $this->data['lunchLogss'] = $this->lunch_m->getData($filter);
        }
        
        $breakTotal = 0;
        $lunchTotal = 0;
        
        foreach ($this->data['lunchLogss']["lunchlogs"] as $lunchlog) {
            if ($lunchlog->type === 'break') {
                $breakTotal += (int) $lunchlog->amount;
            } elseif ($lunchlog->type === 'lunch') {
                $lunchTotal += (int) $lunchlog->amount;
            }
        }
        
        $datas = array(
            array(
                "name" => "Break",
                "y" => $breakTotal,
                "color" => '#09A3A3'
            ),
            array(
                "name" => "Lunch",
                "y" => $lunchTotal,
                "color" => '#FF8A65'
            )
        );
        
        $this->data['lunchLogsPie'] = $datas;
        
        $breakData = [];
        $lunchData = [];
        $today = strtotime("today");
        
        for ($i = 0; $i < 7; $i++) {
            $date = strtotime("-$i days", $today);
            $day = date('Y-m-d', $date);
            $breakData[$day] = 0;
            $lunchData[$day] = 0;
        }
        
        foreach ($this->data['lunchLogss']["lunchlogs"] as $lunchlog) {
            $dateTimestamp = strtotime($lunchlog->date);
            
            if ($dateTimestamp >= $today - 6 * 24 * 60 * 60 && $dateTimestamp <= $today + 24 * 60 * 60) {
                $day = date('Y-m-d', $dateTimestamp);
        
                if ($lunchlog->type === 'break') {
                    $breakData[$day] += (int) $lunchlog->amount;
                } elseif ($lunchlog->type === 'lunch') {
                    $lunchData[$day] += (int) $lunchlog->amount;
                }
            }
        }
        ksort($breakData);
        ksort($lunchData);

        
        $this->data['breakData'] = $breakData;
        $this->data['lunchData'] = $lunchData;

        $this->data["subview"] = "lunch/log";
        $this->load->view('_layout_main', $this->data);
    }
}