<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reset extends CI_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	function __construct() {
		parent::__construct();
		$this->load->helper("form");
		$this->load->library("email");
		$this->load->library("form_validation");
		$this->load->helper("url");
		$this->load->model("site_m");
        $this->load->library('sms/skooly_init');

		$array['siteinfos'] = $this->site_m->get_site(1);
		$this->load->library('inilabs', $array);


		$this->load->library('session');
		if($this->session->userdata('loginuserID')) {
			redirect(base_url('dashboard/index'));
		}
	}

	protected function rules() {
		$rules = array(
				 array(
					'field' => 'newpassword',
					'label' => "New Password",
					'rules' => "trim|required|xss_clean|min_length[4]|max_length[40]|matches[repassword]"
				),
				array(
					'field' => 'repassword',
					'label' => "Re-Password",
					'rules' => "trim|required|xss_clean|min_length[4]|max_length[40]"
				)
			);
		return $rules;
	}

	protected function rules_username() {
        $rules = [
            array(
                'field' => 'username',
                'label' => "Username",
                'rules' => "trim|required|xss_clean|max_length[40]|alpha_numeric"
            )
        ];
    
        return $rules;
    }

	

	public function index() {
		
		$this->load->database();
		$this->load->model("reset_m");
		$this->load->library('session');
		$array = array();
		$reset_key = "";
		$tmp_url = "";
		$i = 0;
		$this->data['form_validation'] = "No";
		$this->data['siteinfos'] = $this->reset_m->get_site();
		
		if($_POST) {
			$rules = $this->rules_username();
			$this->form_validation->set_rules($rules);
			if ($this->form_validation->run() == FALSE) {
				$this->data['form_validation'] = validation_errors();
				$this->data["subview"] = 'reset/index';
				$this->load->view('_layout_reset', $this->data);
			} else {
				$username = $this->input->post('username');
					$tables = array('student' => 'student', 'parents' => 'parents', 'teacher' => 'teacher', 'user' => 'user', 'systemadmin' => 'systemadmin');
					$userFound = false;

					foreach ($tables as $table) {
						$dbuser = $this->reset_m->get_table_users_username($table, $username);
						if (customCompute($dbuser)) {
							$userFound = true;
							$verificationCode = random_int(100000, 999999);
							$reset_key = $this->reset_m->hash($verificationCode . date('y-m-d h i s') . $dbuser->usertypeID . $dbuser->username . $dbuser->name);

							$dbreset = $this->reset_m->get_reset();
							if (customCompute($dbreset)) {
								if ($this->db->truncate('reset')) {
									$this->reset_m->insert_reset(array('keyID' => $reset_key, 'email' => $username, 'code' => $verificationCode));
								} else {
									$this->session->set_flashdata('reset_error', 'Reset access off!');
									break;
								}
							} else {
								$this->reset_m->insert_reset(array('keyID' => $reset_key, 'email' => $username, 'code' => $verificationCode));
							}

							$message = "Your verification code is: $verificationCode";
							$sendMessage = Skooly::send($dbuser->phone, $message);
							if ($sendMessage) {
								$this->session->set_flashdata('reset_send', 'Verification code sent!');
								
								redirect(base_url("reset/verify"));
								return;
							} else {
								$this->session->set_flashdata('reset_error', 'SMS not sent!');
							}
							break;
						}
					}

					if (!$userFound) {
						$this->session->set_flashdata('reset_error', 'User not found!');
					}

					redirect(base_url("reset/index"));

			}
		} else {
			$this->data["subview"] = 'reset/index';
			$this->load->view('_layout_reset', $this->data);
		}
	}

	public function verify() {
		$this->load->database();
		$this->load->model("reset_m");
		$this->load->library('session');
	
		$this->data['form_validation'] = "No";
		$this->data['siteinfos'] = $this->reset_m->get_site();
	
		if ($_POST) {
			$submittedCode = $this->input->post('verification_code');
			
			if (!empty($submittedCode)) {
				$resetRecord = $this->reset_m->get_reset_by_code($submittedCode);
	
				if ($resetRecord) {
					$this->session->set_flashdata('reset_success', 'Verification successful! Proceed to reset your password.');
					redirect(base_url("reset/password/".$resetRecord->keyID."?type=phone"));
				} else {
					$this->data['form_validation'] = "Invalid verification code. Please try again.";
				}
			} else {
				$this->data['form_validation'] = "Verification code cannot be empty.";
			}
		}
	
		$this->data["subview"] = 'reset/verify';
		$this->load->view('_layout_reset', $this->data);
	}
	

	public function password() {
		$this->load->model("reset_m");
		$this->load->library('session');
		$array = array();
		$i = 0;
		$key = $this->uri->segment(3);
		$this->data['siteinfos'] = $this->reset_m->get_site();
		
		if(!empty($key)) {
			$dbreset = $this->reset_m->get_reset(1);
			if(customCompute($dbreset)) {
				if($key == $dbreset->keyID) {
				    
					$this->data['form_validation'] = "No";
					if($_POST) {
						$rules = $this->rules();
						$this->form_validation->set_rules($rules);
						if ($this->form_validation->run() == FALSE) {
							$this->data['form_validation'] = validation_errors();
							$this->data["subview"] = "reset/add";
							$this->load->view('_layout_reset', $this->data);
						} else {
						    $password = $this->input->post('newpassword');
								$username = $dbreset->email;

								$tables = array('student' => 'student', 'parents' => 'parents', 'teacher' => 'teacher', 'user' => 'user', 'systemadmin' => 'systemadmin');
								foreach ($tables as $table) {
									$dbuser = $this->reset_m->get_table_users_username($table, $username);
									if(customCompute($dbuser)) {
										$data = array('password' => $this->reset_m->hash($password));
										$this->db->update($table, $data, "username = '".$username."'");
										$this->session->set_flashdata('reset_success', 'Password Reset Success!');
										$this->db->truncate('reset');
										$array['permition'][$i] = 'yes';
									} else {
										$array['permition'][$i] = 'no';
									}
									$i++;
								}
	
								if(in_array('yes', $array['permition'])) {
									redirect(base_url("signin/index"));
								}
							
						}
					} else {
						$this->data["subview"] = "reset/add";
						$this->load->view('_layout_reset', $this->data);
					}
				} else {
					echo "<p> Session Out </p>";
				}
			} else {
				echo "<p> Session Out </p>";
			}
		} else {
			echo "<p> Session Out </p>";
		}
	}

}



/* End of file class.php */
/* Location: .//D/xampp/htdocs/school/mvc/controllers/class.php */
