<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Wallet extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	function __construct() {
        parent::__construct();
        $this->load->model('student_m');
        $this->load->model('wallet_m');
        $this->load->model('wallettransactions_m');
        $this->load->model('studentrelation_m');
        $this->load->model("setting_m");
        $this->load->model("grade_m");
        $language = $this->session->userdata('lang');
		$this->lang->load('wallet', $language);

    }

    public function index() { 
        
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );

        $filter = array(
            // 'wallet_transactions.create_date>=' => date('Y-m-d 00:00:00'),
            // 'wallet_transactions.create_date<=' => date('Y-m-d 23:59:59'),
        );
        
        if ($_GET) {
            if($this->input->get('start_date') || $this->input->get('end_date')){
                $filter['wallet_transactions.create_date>='] = $this->input->get('start_date') . ' ' . '00:00:00';
                $filter['wallet_transactions.create_date<='] = $this->input->get('end_date') . ' ' . '23:59:59';
            }

            if ($this->input->get('paymentMethod')) {
                $filter['wallet_transactions.payment_type'] = $this->input->get('paymentMethod');
            }
        
            if ($this->input->get('transactionType')) {
                $filter['wallet_transactions.trx_type'] = $this->input->get('transactionType');
            }
        }        

        $this->data["logs"] = $this->wallettransactions_m->getData($filter);
        $this->data['chartData'] = $this->pieChart();
        $this->data['columnData'] = $this->columnChart();
        $this->data['get_all_holidays'] = $this->getHolidaysSession();
		$this->data["subview"] = "wallet/log";
		$this->load->view('_layout_main', $this->data);
	}

    public function columnChart(){
        $columnData = [];
        $today = strtotime("today");
        
        for ($i = 0; $i < 7; $i++) {
            $date = strtotime("-$i days", $today);
            $day = date('Y-m-d', $date);
            $columnData[$day] = 0;
        }
        
        foreach ($this->data['logs'] as $log) {
            $dateTimestamp = strtotime($log->create_date);
            
            if ($dateTimestamp >= $today - 6 * 24 * 60 * 60 && $dateTimestamp <= $today + 24 * 60 * 60) {
                $day = date('Y-m-d', $dateTimestamp);
        
                $columnData[$day] += (int) $log->amount;
            }
        }

        ksort($columnData);
        return $columnData;
    }    

    public function pieChart(){
        $paymentMethodTypes = [];
        foreach ($this->data["logs"] as $log) {
            $paymentType = $log->payment_type;
            if (!isset($paymentMethodTypes[$paymentType])) {
                $paymentMethodTypes[$paymentType] = 0;
            }
            $paymentMethodTypes[$paymentType]++;
        }

        $pieChartData = [];
        foreach ($paymentMethodTypes as $paymentType => $count) {
            $pieChartData[] = [
                'paymentType' => $paymentType,
                'count' => $count
            ];
        }

        return $pieChartData;

    }

    public function view(){

        $this->data['headerassets'] = array(
            'css' => array(
                'assets/custom-scrollbar/jquery.mCustomScrollbar.css'
            ),
            'js' => array(
                'assets/custom-scrollbar/jquery.mCustomScrollbar.concat.min.js'
            )
        ); 
        $schoolyearID = $this->session->userdata('defaultschoolyearID');
        $id = htmlentities(escapeString($this->uri->segment(3)));

        $this->data["logs"] = $this->wallettransactions_m->getTrx($id);
        $this->data["wallet"] = $this->wallet_m->getBalance(array('studentID' => $id));
        $this->data["last_transaction"] = $this->wallettransactions_m->getLastTrx($id);
        $this->data['total_invoices'] = $this->wallettransactions_m->totalInvoices($id);
        $this->data['sales_balance'] = getStudentProductSaleBalance(array('schoolyearID'=>$schoolyearID, 'studentID'=> $id));
        $this->data['student'] = $this->studentrelation_m->get_single_student(array('srstudentID' => $id, 'srschoolyearID' => $schoolyearID));
        $this->data["subview"] = "wallet/index";
        $this->load->view('_layout_main', $this->data);
    }

    public function deposit() {

        try{
            if(allowTransaction()){
                $schoolyearID = $this->session->userdata('defaultschoolyearID');
                $amount = $this->input->post('amount');
                $studentID = $this->input->post('studentID');
        
                $existingWalletQuery = $this->db->get_where('wallets', array('studentID' => $studentID));
                
                if (!$existingWalletQuery->num_rows() > 0) {
                    $newWalletData = array(
                        'studentID' => $studentID,
                        'balance' => 0,
                        'create_date' => date("Y-m-d H:i:s")
                    );
                    $this->db->insert('wallets', $newWalletData);
                }
                $walletData = $this->wallet_m->getWallet(array('studentID' => $studentID));
                $walletID = $walletData->id;
                
                $data = array(
                    'balance' => round(floatval($walletData->balance) + floatval($amount)),
                    'modify_date' => date("Y-m-d H:i:s")
                );
        
                $this->wallet_m->update_wallet($data, $walletID);
                $totalAmount = round(floatval($walletData->balance) + floatval($amount));
                $username = $this->session->userdata('username');
                $transactionData = array(
                    'studentID' => (int) $studentID,
                    'amount' => $amount,
                    'post_balance' => $totalAmount,
                    'trx_type' => 'credit',
                    'walletID' => (int) $walletID,
                    'referenceNO' => getTrx(),
                    'payment_type' => $this->input->post('paymentMethod'),
                    'details' => "Wallet Recharge by $username",
                    'create_date' => date("Y-m-d H:i:s")
        
                );
                if ($this->db->insert('wallet_transactions', $transactionData)) {
                    $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID), TRUE);
    
                    if(update_fee_balance([$studentID],$schoolyearID)){
                        SmsService::walletDeposit($studentInfo, 3, $this->data, $amount);     
            
                        processStudentPayment($studentID, $totalAmount, $this->input->post('paymentMethod'));
                        
                    }
        
                }
                
                $this->session->set_flashdata('success', $this->lang->line('deposit_success'));
                redirect(base_url("wallet/view/".$studentID));
            }else{
                $this->session->set_flashdata('error', 'Your SMS balance is low. Kindly recharge.');
                redirect($_SERVER['HTTP_REFERER']);
            }
           
        }catch(Exception $e){
            error_log($e->getMessage());
            $this->session->set_flashdata('error', $e->getMessage());
            redirect($_SERVER['HTTP_REFERER']);
        }       
        
    }

    public function withdraw() {
        if(allowTransaction()){
            $amount = $this->input->post('amount');
            $studentID = $this->input->post('studentID');
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
    
            $existingWalletQuery = $this->db->get_where('wallets', array('studentID' => $studentID));
            
            if (!$existingWalletQuery->num_rows() > 0) {
                $newWalletData = array(
                    'studentID' => $studentID,
                    'balance' => 0,
                    'create_date' => date("Y-m-d H:i:s")
                );
                $this->db->insert('wallets', $newWalletData);
            }
    
            $walletData = $this->wallet_m->getWallet(array('studentID' => $studentID));
            $walletID = $walletData->id;
            
            $data = array(
                'balance' => round(floatval($walletData->balance) - floatval($amount)),
                'modify_date' => date("Y-m-d H:i:s")
            );
    
            $this->wallet_m->update_wallet($data, $walletID);
        
            $username = $this->session->userdata('username');
    
            $transactionData = array(
                'studentID' => (int) $studentID,
                'amount' => $amount,
                'post_balance' => round(floatval($walletData->balance) - floatval($amount)),
                'trx_type' => 'debit',
                'walletID' => (int) $walletID,
                'referenceNO' => getTrx(),
                'details' => "Wallet Withdrawal by $username",
                'create_date' => date("Y-m-d H:i:s")
    
            );
            $this->db->insert('wallet_transactions', $transactionData);
            $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID), TRUE);
    
            update_fee_balance([$studentID],$schoolyearID);
            SmsService::walletWithdraw($studentInfo, 3, $this->data, $amount);      
            $this->session->set_flashdata('success', $this->lang->line('deposit_success'));
            redirect(base_url("wallet/view/".$studentID));          
        }else{
            $this->session->set_flashdata('error', 'Your SMS balance is low. Kindly recharge.');
            redirect($_SERVER['HTTP_REFERER']);    
        }
             
    }

    public function createWallets() {
        
        $students = $this->db->get('student')->result_array();       
        
        foreach ($students as $student) {
            
            $existingWallet = $this->wallet_m->getWallet(array('studentID' => $student['studentID']));
            
            if (empty($existingWallet)) {
              
                $newWalletData = array(
                    'studentID' => $student['studentID'],
                    'balance' => 0,
                    'create_date' => date("Y-m-d H:i:s")
                );
                $this->db->insert('wallets', $newWalletData);
            } else {
                continue;
            }
            
        }
        echo 'done';
        
    }
}