<?php

    if (!function_exists('dd')) {
        function dd($data) {
            echo "<pre style='background-color: #343a40; color: #ffc107; padding: 10px;'>";
            var_dump($data);
            echo "</pre>";
            die;
        }
    }
    
    function getCardData($key = null){
        $CI =& get_instance();
        $CI->load->model('reports_m');
        $data = $CI->reports_m->cards();
        
        return $data[$key]?? 0;
    }
    
    function createLibraryMember($studentID){
        $CI =& get_instance();
        $CI->load->model('lmember_m');
        $CI->load->model('student_m');
        $CI->load->model('studentrelation_m');
        
        $lmember = $CI->lmember_m->get_lmember();
		$lastid = $CI->lmember_m->get_lmember_lastID();
		$schoolyearID = get_setting('school_year');
		$student = $CI->studentrelation_m->get_single_student(array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID));
		if(customCompute($student)) {
    		if(customCompute($lmember)) {
    			$lID = $lastid->lID+1;
    		} else {
    			$data = date('Y');
    			$lID = $data.'01';
    		}
            
            $array = array(
    		    "lID" => $lID,
    			"studentID" => $student->studentID,
    			"name" => $student->name,
    			"email" => $student->email,
    			"phone" => $student->phone,
    			"lbalance" => '0.00',
    			"ljoindate" => date("Y-m-d")
    		);
    		$CI->lmember_m->insert_lmember($array);
    		$CI->student_m->update_student(array("library" => 1), $studentID);
		}
    }
    
    function getTodaysAttendance(){
        $CI =& get_instance();
        $CI->load->model('sattendance_m');
        $attendances = $CI->sattendance_m->get_order_by_attendance([
                    'schoolyearID' => get_setting('school_year'),
                    'monthyear'    => date('m-Y')
                ]);

                $classWiseAttendance = [];
                foreach ( $attendances as $attendance ) {
                    for ( $i = 1; $i <= 31; $i++ ) {
                        if ( $i > date('d') ) {
                            break;
                        }
                        $date = 'a' . $i;

                        if ( !isset($classWiseAttendance[ $attendance->classesID ][ $i ]['P']) ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['P'] = 0;
                        }

                        if ( !isset($classWiseAttendance[ $attendance->classesID ][ $i ]['A']) ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['A'] = 0;
                        }

                        if ( $attendance->$date == 'P' || $attendance->$date == 'L' || $attendance->$date == 'LE' ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['P']++;
                        } else {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['A']++;
                        }
                    }
                }

                $todaysAttendance = [];
                foreach ( $classWiseAttendance as $key => $value ) {
                    $todaysAttendance[ $key ] = $value[ (int) date('d') ];
                }
                
                $totalPresentStudents = 0;

                foreach ($todaysAttendance as $attendance) {
                    if (isset($attendance['P'])) {
                        $totalPresentStudents += $attendance['P'];
                    }
                }
                
                return $totalPresentStudents;
    }
    
    

    if (!function_exists('getSmsData')) {
        function getSmsData()
        {
            $CI = &get_instance();
            $CI->load->model('smssettings_m');
            $CI->load->model('setting_m');
    
            // Fetch the SMS balance from the celcoms settings.
            $get_celcoms = $CI->smssettings_m->get_order_by_celcom();
            $celcomBalanceKey = array_search("celcom_balance", array_column($get_celcoms, "field_names"));
            $celcomBalance = $get_celcoms[$celcomBalanceKey]->field_values;
    
            // Fetch the system SMS threshold.
            $setting = $CI->setting_m->get_setting();
            $smsThreshold = $setting->sms_threshold;
    
            return [
                'smsBalance' => (int) $celcomBalance,
                'smsThreshold' => (int) $smsThreshold
            ];
        }
    }
    
    function getTopMessage($key) {
        $CI =& get_instance();
        $CI->db->select('value');
        $CI->db->from('ini_config');
        $CI->db->where('config_key', $key);
        $query = $CI->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->value;
        }
        return null;
    }

    function allowTransaction(){
        $CI =& get_instance();
        $CI->load->model('smssettings_m');
        $get_celcoms = $CI->smssettings_m->get_order_by_celcom();
        $celcomBalanceKey = array_search("celcom_balance", array_column($get_celcoms, "field_names"));
        $celcomBalance = $get_celcoms[$celcomBalanceKey]->field_values; 

        return ($celcomBalance > get_setting('sms_threshold'))? true: false;
    }

    function processStudentPayment($studentID, $amount, $method, $charge = false)
    {
        $CI =& get_instance();
        $CI->load->model('globalpayment_m');
        $CI->load->model('payment_m');
        $CI->load->model('invoice_m');
        $CI->load->model('wallet_m');
        $CI->load->model('maininvoice_m');
        $CI->load->model('studentrelation_m');
        $CI->load->model('weaverandfine_m'); // Load the weaver and fine model
    
        $student = $CI->studentrelation_m->general_get_single_student(array('srstudentID' => $studentID), TRUE);
        
        // Get invoices ordered by invoiceID ASC (oldest first)
        $invoices = $CI->invoice_m->get_order_by_invoice(array(
            'studentID' => $studentID, 
            'deleted_at' => 1
        ), 'invoiceID ASC');
    
        if (!$student || !customCompute($invoices)) {
            return ['status' => false, 'message' => 'Invalid student or no invoices found.'];
        }
    
        // Filter only invoices with autopay enabled
        $autopayInvoices = array_filter($invoices, function($invoice) {
            return $invoice->autopay == 1;
        });
    
        if (empty($autopayInvoices)) {
            return ['status' => false, 'message' => 'No invoices are enabled for autopay.'];
        }
    
        $globalPaymentData = [
            'classesID' => $student->classesID,
            'sectionID' => $student->sectionID,
            'studentID' => $studentID,
            'clearancetype' => 'partial',
            'invoicename' => $student->registerNO . '-' . $student->name,
            'paymentyear' => date('Y'),
            'schoolyearID' => $student->schoolyearID,
        ];
        $CI->globalpayment_m->insert_globalpayment($globalPaymentData);
        $globalLastID = $CI->db->insert_id();
    
        $totalPaid = 0;
        $totalBalance = 0;
        $mainInvoicesID = [];
        
        // Process invoices in ascending order by invoiceID
        foreach ($autopayInvoices as $invoice) {
            $mainInvoicesID[] = $invoice->maininvoiceID;
    
            // Use the existing helper function to get the correct balance
            $invoiceBalance = getInvoiceBalance($invoice->invoiceID, $invoice->amount);
            
            $totalBalance += $invoiceBalance;
            
            // Only process if there is a remaining balance
            if ($invoiceBalance > 0 && $amount > 0) {
                
                $walletData = $CI->wallet_m->getWallet(['studentID' => $studentID]);
                $currentWalletBalance = $walletData->balance ?? 0;
                
                // The payment amount is the lesser of the available deposit or the invoice balance
                $paymentAmount = min($amount, $invoiceBalance);
                $amount -= $paymentAmount;
    
                $paymentData = [
                    'invoiceID' => $invoice->invoiceID,
                    'schoolyearID' => $student->schoolyearID,
                    'studentID' => $studentID,
                    'paymentamount' => $paymentAmount,
                    'paymenttype' => ucfirst($method),
                    'paymentdate' => date('Y-m-d'),
                    'userID' => 1,
                    'usertypeID' => 1,
                    'transactionID' => strtoupper($method) . random19(),
                    'globalpaymentID' => $globalLastID,
                ];
                $CI->payment_m->insert_payment($paymentData);
                $totalPaid += $paymentAmount;
    
                $newInvoiceBalance = $invoiceBalance - $paymentAmount;
                $paidstatus = ($newInvoiceBalance > 0) ? 1 : 2;
    
                $CI->invoice_m->update_invoice(['paidstatus' => $paidstatus], $invoice->invoiceID);
    
                $transactionData = [
                    'studentID' => $studentID,
                    'amount' => $paymentAmount,
                    'post_balance' => $currentWalletBalance - $paymentAmount,
                    'trx_type' => 'debit',
                    'trx_action' => 'Payment',
                    'trx_action_type' => 'Auto', // Changed from 'Manual' to 'Auto' for autopay
                    'walletID' => $walletData->id ?? null,
                    'payment_type' => ucfirst($method),
                    'schoolyearID' => $student->schoolyearID,
                    'referenceNO' => getTrx(),
                    'details' => "Auto payment of KES $paymentAmount for {$invoice->feetype}.",
                    'create_date' => date("Y-m-d H:i:s"),
                ];
                
                if ($CI->db->insert('wallet_transactions', $transactionData)) {
                    $data = array(
                        'balance' => round($currentWalletBalance - $paymentAmount),
                        'modify_date' => date("Y-m-d H:i:s")
                    );
                    
                    $CI->wallet_m->update_wallet($data, $walletData->id);
                    
                    update_fee_balance([$studentID], $student->schoolyearID);
                    $student = $CI->studentrelation_m->general_get_single_student(array('srstudentID' => $studentID), TRUE);
                    
                    SmsService::autopaySMS($student, 3, $paymentAmount, $invoice->feetype);
                }
            }
        }
        
        updateMainInvoiceStatus($mainInvoicesID, $globalLastID);
        
        return ['status' => true, 'message' => 'Payment processed successfully.'];
    }
    
    /**
     * Updates the status of main invoices based on the status of their related invoices.
     * @param array $mainInvoicesID An array of main invoice IDs to update.
     * @param int $globalLastID The ID of the global payment entry.
     */
    function updateMainInvoiceStatus($mainInvoicesID, $globalLastID)
    {
        $CI =& get_instance();
        $CI->load->model('globalpayment_m');
        $CI->load->model('maininvoice_m');
        $CI->load->model('invoice_m'); // Ensure invoice model is loaded here
        $CI->load->model('weaverandfine_m'); // Ensure weaver and fine model is loaded here
    
        $mainInvoicesID = array_unique($mainInvoicesID);
    
        foreach ($mainInvoicesID as $maininvoiceID) {
            $relatedInvoices = $CI->invoice_m->get_invoices_by_maininvoiceID($maininvoiceID);
            $mainInvoiceBalance = 0;
    
            foreach ($relatedInvoices as $relatedInvoice) {
                // Use the existing helper function to get the correct balance
                $invoiceBalance = getInvoiceBalance($relatedInvoice->invoiceID, $relatedInvoice->amount);
                $mainInvoiceBalance += $invoiceBalance;
            }
    
            $paidstatus = ($mainInvoiceBalance > 0) ? 1 : 2;
    
            $CI->maininvoice_m->update_maininvoice(['maininvoicestatus' => $paidstatus], $maininvoiceID);
    
            $CI->globalpayment_m->update_globalpayment(
                ['clearancetype' => ($paidstatus === 2) ? 'paid' : 'partial'], 
                $globalLastID
            );
        }
    }
    
    /**
     * Calculates the outstanding balance for a given invoice, considering payments and waived amounts.
     * This logic is based on the 'paymentdue' function from the Invoice controller.
     *
     * @param int $invoiceID The ID of the invoice.
     * @param float $invoiceAmount The total amount of the invoice.
     * @return float The outstanding balance.
     */
    function getInvoiceBalance($invoiceID, $invoiceAmount)
    {
        $CI =& get_instance();
        $CI->load->model('payment_m');
        $CI->load->model('weaverandfine_m');
    
        // Get total paid amount for this invoice
        $paymentitems = $CI->payment_m->get_order_by_payment(array('invoiceID' => $invoiceID));
        $totalPaid = 0;
        if (customCompute($paymentitems)) {
            foreach ($paymentitems as $paymentitem) {
                $totalPaid += $paymentitem->paymentamount;
            }
        }
    
        // Get total waived amount for this invoice
        $weaverandfineitems = $CI->weaverandfine_m->get_order_by_weaverandfine(array('invoiceID' => $invoiceID));
        $totalWaived = 0;
        if (customCompute($weaverandfineitems)) {
            foreach ($weaverandfineitems as $weaverandfineitem) {
                $totalWaived += $weaverandfineitem->weaver;
            }
        }
    
        // Calculate the actual outstanding balance
        $outstandingBalance = $invoiceAmount - $totalPaid - $totalWaived;
    
        return $outstandingBalance;
    }
    
    function formatPhone($mobile)
    {
        if (is_array($mobile)) {
            $mobile = reset($mobile);
        }

        if (substr($mobile, 0, 1) == "+") {
            $mobile = str_replace("+", "", $mobile);
        }
        if (substr($mobile, 0, 1) == "0") {
            $mobile = preg_replace("/^0/", "254", $mobile);
        }
        if (substr($mobile, 0, 1) == "7" && strlen($mobile) == 9) {
            $mobile = "254{$mobile}";
        }

        return $mobile;
    }

    function update_fee_balance($students, $schoolyearID)
    {   
        try{
            $ci     = &get_instance();

            $ci->load->model('student_m');
            $ci->load->model("payment_m");
            $ci->load->model("wallet_m");
    
            foreach ($students as $studentID) {
                $fee_balance = $ci->payment_m->balance($studentID);
                $salesBalance = getStudentProductSaleBalance(array('schoolyearID'=>$schoolyearID, 'studentID'=> $studentID));
                $wallet_balance = $ci->wallet_m->getBalance(array('studentID' => $studentID));
                
                $ci->student_m->update_student(array('fee_balance' => ($fee_balance+$salesBalance), 'wallet_balance'=> $wallet_balance), $studentID);
            }
            
            return true;
            
        }catch(\Exception $e){
            return false;
        }
        
    }

    function getStudentProductSaleBalance($data) {
        $ci     = &get_instance();

        $ci->load->model('productsale_m');
        $ci->load->model("productsalepaid_m");

        $productsales = $ci->productsale_m->get_all_productsale_for_report([
            'productsalecustomertypeID' => 3,
            'productsalecustomerID' => $data['studentID'],
        ]);
    
        $productsalepaids = $ci->productsalepaid_m->get_order_by_productsalepaid([
            'schoolyearID' => $data['schoolyearID'],
        ]);
    
        $productsalepaidsArray = [];
        foreach ($productsalepaids as $productsalepaid) {
            if (!isset($productsalepaidsArray[$productsalepaid->productsaleID])) {
                $productsalepaidsArray[$productsalepaid->productsaleID] = 0;
            }
            $productsalepaidsArray[$productsalepaid->productsaleID] += $productsalepaid->productsalepaidamount;
        }
    
        $balance = 0;
        foreach ($productsales as $product) {
            $totalPrice = $product->productsaleunitprice * $product->productsalequantity;
            $paidAmount = isset($productsalepaidsArray[$product->productsaleID]) ? $productsalepaidsArray[$product->productsaleID] : 0;
            $balance += ($totalPrice - $paidAmount);
        }
    
        return $balance;
    }
    
    function bytesToSize($path, $filesize = '')
    {
        if (!is_numeric($filesize)) {
            $bytes = sprintf('%u', filesize($path));
        } else {
            $bytes = $filesize;
        }
        if ($bytes > 0) {
            $unit = intval(log($bytes, 1024));
            $units = [
                'B',
                'KB',
                'MB',
                'GB',
            ];
            if (array_key_exists($unit, $units) === true) {
                return sprintf('%d %s', $bytes / pow(1024, $unit), $units[$unit]);
            }
        }
        return $bytes;
    }

    function get_class_name($classes, $classesID) {
        foreach ($classes as $class) {
            if ($class->classesID == $classesID) {
                return $class->classes;
            }
        }
        return null;
    }

    function get_setting($val){
        $ci     = &get_instance();
        $ci->load->model("setting_m");

        $setting = $ci->setting_m->get_setting_where($val);

        return $setting? $setting->value: '';
    }

    function get_notification_setting($val){
        $ci     = &get_instance();
        $ci->load->model("notification_setting_m");

        $setting = $ci->notification_setting_m->get_notification_setting_where($val);

        return $setting? $setting->value: '';
    }

    function escapeString($val)
    {
        $ci     = &get_instance();
        $driver = $ci->db->dbdriver;

        // Handle null or non-string values explicitly
        if ($val === null) {
            return ''; // Or `null`, depending on your application's requirements
        }

        if ($driver == 'mysql') {
            $val = mysql_real_escape_string($val);
        } elseif ($driver == 'mysqli') {
            $db  = $ci->db->conn_id;
            $val = mysqli_real_escape_string($db, $val ?? '');
        }

        return $val;
    }


    function btn_extra( $uri, $name, $permission )
    {
        if ( permissionChecker($permission) ) {
            return anchor($uri, "<i class='fa fa-plus'></i>",
                "class='btn btn-primary btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }

        return '';
    }

    function btn_add( $uri, $name )
    {
        if ( visibleButton($uri) ) {
            return anchor($uri, "<i class='fa fa-plus'></i>",
                "class='btn btn-primary btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }

        return '';
    }

    function btn_add_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-plus'></i>",
            "class='btn btn-primary btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_view( $uri, $name )
    {
        if ( visibleButton($uri) ) {
            return anchor($uri, "<i class='fa fa-check-square-o'></i>",
                "class='btn btn-success btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }

        return '';
    }

    function btn_view_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-check-square-o'></i>",
            "class='btn btn-success btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_edit( $uri, $name )
    {
        if ( visibleButton($uri) ) {
            return anchor($uri, "<i class='fa fa-edit'></i>",
                "class='btn btn-warning btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }
        return '';
    }

    function btn_edit_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-edit'></i>",
            "class='btn btn-warning btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_status( $uri, $name )
    {
        if ( visibleButton($uri) ) {
            return anchor($uri, "<i class='fa fa-check'></i>",
                "class='btn btn-info btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }
        return '';
    }

    function btn_status_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-check'></i>",
            "class='btn btn-info btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_not_status( $uri, $name )
    {
        if ( visibleButton($uri) ) {
            return anchor($uri, "<i class='fa fa-close'></i>",
                "class='btn btn-warning btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }
        return '';
    }

    function btn_not_status_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-close'></i>",
            "class='btn btn-warning btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_delete($uri, $title, $extra_attributes = []) {
    // Define the default attributes for a delete button
        $attributes = [
            'class' => 'btn btn-danger btn-xs mrg confirm-action sms-check-button',
            'data-title' => 'Delete Confirmation?',
            'data-text' => 'This action cannot be undone. Are you sure you want to proceed?',
            'data-icon' => 'warning',
            'data-confirm-button-text' => 'Yes, delete it!'
        ];
        
        // Merge any extra attributes passed in from the view
        $final_attributes = array_merge($attributes, $extra_attributes);
        
        $attribute_string = '';
        foreach ($final_attributes as $key => $value) {
            $attribute_string .= ' ' . htmlspecialchars($key) . '="' . htmlspecialchars($value) . '"';
        }
    
        return '<a href="' . base_url($uri) . '"' . $attribute_string . '>'
            . '<i data-toggle="tooltip" data-placement="top" data-original-title="' . htmlspecialchars($title) . '" class="fa fa-trash-o"></i>'
            . '</a>';
    }
    
    

    function btn_delete_show( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-trash-o'></i>",
            [
                'onclick'             => "return confirm('you are about to delete a record. This cannot be undone. are you sure?')",
                'class'               => 'btn btn-danger btn-smaller mrg',
                'data-placement'      => 'top',
                'data-toggle'         => 'tooltip',
                'data-original-title' => $name
            ]
        );
    }

    function btn_cancel( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-close'></i>",
            [
                'onclick'             => "return confirm('you are about to cancel the record. This cannot be undone. are you sure?')",
                'class'               => 'btn btn-danger btn-smaller mrg',
                'data-placement'      => 'top',
                'data-toggle'         => 'tooltip',
                'data-original-title' => $name
            ]
        );
    }


    function delete_file( $uri, $id )
    {
        return anchor($uri, "<i class='fa fa-times '></i>",
            [
                'onclick' => "return confirm('you are about to delete a record. This cannot be undone. are you sure?')",
                'id'      => $id,
                'class'   => "close pull-right"
            ]
        );
    }

    function share_file( $uri, $id )
    {
        return anchor($uri, "<i class='fa fa-globe'></i>",
            [
                'onclick' => "return confirm('you are about to delete a record. This cannot be undone. are you sure?')",
                'id'      => $id,
                'class'   => "pull-right"
            ]
        );
    }


    function btn_dash_view( $uri, $name, $class = "btn-success" )
    {
        return anchor($uri, "<span class='fa fa-check-square-o'></span>",
            "class='btn " . $class . " btn-smaller mrg' style='background-color:#00bcd4;color:#fff;' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }


    function btn_invoice( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-credit-card'></i>",
            "class='btn btn-success btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }
    
    function btn_waiver( $uri, $name )
        {
            return anchor($uri, "<i class='fa fa-gift'></i>",
                "class='btn btn-warning btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
        }

    function btn_return( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-mail-forward'></i>",
            [
                "onclick"             => "return confirm('you are return the book . This cannot be undone. are you sure?')",
                "class"               => 'btn btn-danger btn-smaller mrg',
                'data-placement'      => 'top',
                'data-toggle'         => 'tooltip',
                'data-original-title' => $name

            ]
        );
    }

    function btn_attendance( $id, $method, $class, $name )
    {
        return "<input type='checkbox' class='" . $class . "' $method id='" . $id . "' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "' >  ";
    }

    function btn_attendance_radio( $id, $method, $class, $name, $title, $value )
    {
        return "<input type='radio' class='" . $class . "' $method id='" . $id . "' value='" . $value . "' name='" . $name . "'>  " . "<label style='vertical-align:  middle;display: inline;' for='" . $id . "'>" . $title . "</label> ";
    }

    function btn_promotion( $id, $class, $name )
    {
        return "<input type='checkbox' class='" . $class . "' id='" . $id . "' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "' >  ";
    }
 
    if ( !function_exists('dump') ) {
        function dump( $var, $label = 'Dump', $echo = true )
        {
            ob_start();
            var_dump($var);
            $output = ob_get_clean();

            $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
            $output = '<pre style="background: #FFFEEF; color: #000; border: 1px dotted #000; padding: 10px; margin: 10px 0; text-align: left;">' . $label . ' => ' . $output . '</pre>';

            if ( $echo == true ) {
                echo $output;
            } else {
                return $output;
            }
        }
    }


    if ( !function_exists('dump_exit') ) {
        function dump_exit( $var, $label = 'Dump', $echo = true )
        {
            dump($var, $label, $echo);
            exit;
        }
    }

    if ( !function_exists('dd') ) {
        function dd( $var = "", $label = 'Dump', $echo = true )
        {
            dump($var, $label, $echo);
            exit;
        }
    }

    // infinite coding starts here..
    function btn_add_pdf( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-file'></i> " . $name,
            "class='btn-cs btn-sm-cs' style='text-decoration: none;' role='button' target='_blank'");
    }

    function btn_sm_edit( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-edit'></i> " . $name,
            "class='btn-cs btn-sm-cs' style='text-decoration: none;' role='button'");
    }

    function btn_sm_delete( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-trash-o'></i> " . $name,
            [
                'onclick'             => "return confirm('you are about to delete a record. This cannot be undone. are you sure?')",
                'class'               => 'btn btn-maroon btn-sm mrg bg-maroon-light',
                'data-placement'      => 'top',
                'data-toggle'         => 'tooltip',
                'data-original-title' => $name
            ]
        );
    }

    function btn_sm_add( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-plus'></i> " . $name,
            "class='btn-cs btn-sm-cs' style='text-decoration: none;' role='button'");
    }

    function btn_sm_accept_and_denied_leave( $uri, $name, $icon )
    {
        return anchor($uri, "<i class='fa fa-" . $icon . "'></i> " . $name,
            "class='btn-cs btn-sm-cs' style='text-decoration: none;' role='button'");
    }

    function btn_sm_global( $uri, $name, $icon, $color = null )
    {
        if ( !$color ) {
            $color = "btn-primary";
        }
        return anchor($uri, "<i class='" . $icon . "'></i>",
            "class='btn " . $color . " btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_md_global( $uri, $name, $icon, $class = null )
    {
        if ( !$class ) {
            $class = "btn-primary";
        }
        return anchor($uri, $icon,
            "class='" . $class . "' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_payment( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-credit-card'></i> " . $name,
            "class='btn-cs btn-sm-cs'style='text-decoration: none;' role='button'");
    }



   if (!function_exists('render_action_dropdown')) {
    function render_action_dropdown($actions, $dropdown_id = null, $label = 'Action') {
        if (empty($actions)) return '';
        if (!$dropdown_id) $dropdown_id = 'dropdownMenuButton' . rand(1000,9999);

        // Map action labels to SVG icon IDs
        $iconMap = [
            'view'            => 'icon-view',
            'edit'            => 'icon-edit',
            'delete'          => 'icon-delete',
            'cancel'          => 'icon-delete',
            'payments'        => 'icon-wallet',
            'view payments'   => 'icon-transaction-history',
            'add'             => 'icon-add',
            'search'          => 'icon-search',
            'send'            => 'icon-send',
            'wallet'          => 'icon-wallet',
            'pdf'             => 'icon-pdf',
            'csv'             => 'icon-csv',
            'excel'           => 'icon-excel',
        ];

        ob_start(); ?>
        <div class="dropdown action-dropdown" style="position:relative;display:inline-block;">
            <button class="custom-dropdown-btn btn btn-light btn-sm dropdown-toggle"
                    type="button"
                    id="<?= htmlspecialchars($dropdown_id) ?>"
                    data-toggle="dropdown"
                    aria-haspopup="true"
                    aria-expanded="false">
                <svg class="icon"><use xlink:href="#icon-dots"></use></svg>
            </button>
            <div class="custom-dropdown-menu dropdown-menu" aria-labelledby="<?= htmlspecialchars($dropdown_id) ?>">
                <?php foreach($actions as $action):
                    // Normalize label for icon mapping
                    $labelKey = strtolower(html_entity_decode(strip_tags($action['label'])));
                    $iconId = $iconMap[$labelKey] ?? 'icon-view';

                    // Merge classes: always include these, plus any extra from the action
                    $extraClass = isset($action['class']) ? trim($action['class']) : '';
                    $allClasses = 'custom-dropdown-item dropdown-item' . ($extraClass ? ' ' . $extraClass : '');

                    // Remove any class="..." from attrs to avoid duplicate attributes
                    $attrs = isset($action['attrs']) ? $action['attrs'] : '';
                    $attrs = preg_replace('/\s*class="[^"]*"/i', '', $attrs);
                ?>
                    <a href="<?= htmlspecialchars($action['url']) ?>"
                       class="<?= htmlspecialchars($allClasses) ?>"
                       <?= $attrs ?>>
                        <svg class="icon"><use xlink:href="#<?= htmlspecialchars($iconId) ?>"></use></svg>
                        <?= htmlspecialchars($action['label']) ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}
    // infinite coding end here..


    function permissionChecker( $data )
    {
        $CI                = &get_instance();
        $sessionPermission = $CI->session->userdata('master_permission_set');
        if ( isset($sessionPermission[ $data ]) && $sessionPermission[ $data ] == 'yes' ) {
            return true;
        }
        return false;
    }

    function visibleButton( $uri )
    {
        $explodeUri = explode('/', $uri);
        $permission = $explodeUri[0] . '_' . $explodeUri[1];
        if ( permissionChecker($permission) ) {
            return true;
        }
        return false;
    }

    function actionChecker( $arrays )
    {
        if ( $arrays ) {
            foreach ( $arrays as $key => $array ) {
                if ( permissionChecker($array) ) {
                    return true;
                }
            }
        }
    }

    function pluck( $array, $value, $key = null )
    {
        $returnArray = [];
        if ( customCompute($array) ) {
            foreach ( $array as $item ) {
                if ( $key != null ) {
                    $returnArray[ $item->$key ] = strtolower($value) == 'obj' ? $item : $item->$value;
                } else {
                    if ( $value == 'obj' ) {
                        $returnArray[] = $item;
                    } else {
                        $returnArray[] = $item->$value;
                    }
                }
            }
        }
        return $returnArray;
    }

    function pluck_bind( $array, $value, $concatFirst, $concatLast, $key = null )
    {
        $returnArray = [];
        if ( customCompute($array) ) {
            foreach ( $array as $item ) {
                if ( $key != null ) {
                    $returnArray[ $item->$key ] = $concatFirst . $item->$value . $concatLast;
                } else {
                    if ( $value != null ) {
                        $returnArray[] = $concatFirst . $item->$value . $concatLast;
                    } else {
                        $returnArray[] = $concatFirst . $item . $concatLast;
                    }
                }
            }
        }

        return $returnArray;
    }

    function pluck_multi_array( $arrays, $val, $key = null )
    {
        $retArray = [];
        if ( customCompute($arrays) ) {
            $i = 0;
            foreach ( $arrays as $array ) {
                if ( !empty($key) ) {
                    if ( strtolower($val) == 'obj' ) {
                        $retArray[ $array->$key ][] = $array;
                    } else {
                        $retArray[ $array->$key ][] = $array->$val;
                    }
                } else {
                    if ( strtolower($val) == 'obj' ) {
                        $retArray[ $i ][] = $array;
                    } else {
                        $retArray[ $i ][] = $array->$val;
                    }
                    $i++;
                }
            }
        }
        return $retArray;
    }

    function pluck_multi_array_key( $arrays, $val, $fstKey = null, $sndKey = null )
    {
        $retArray = [];
        if ( customCompute($arrays) ) {
            $i = 0;
            foreach ( $arrays as $array ) {
                if ( !empty($fstKey) ) {
                    if ( strtolower($val) == 'obj' ) {
                        if ( !empty($sndKey) ) {
                            $retArray[ $array->$fstKey ][ $array->$sndKey ] = $array;
                        } else {
                            $retArray[ $array->$fstKey ][] = $array;
                        }
                    } else {
                        if ( !empty($sndKey) ) {
                            $retArray[ $array->$fstKey ][ $array->$sndKey ] = $array->$val;
                        } else {
                            $retArray[ $array->$fstKey ][] = $array->$val;
                        }

                    }
                } else {
                    if ( strtolower($val) == 'obj' ) {
                        if ( !empty($sndKey) ) {
                            $retArray[ $i ][ $array->$sndKey ] = $array;
                        } else {
                            $retArray[ $i ][] = $array;
                        }
                    } else {
                        if ( !empty($sndKey) ) {
                            $retArray[ $i ][ $array->$sndKey ] = $array->$val;
                        } else {
                            $retArray[ $i ][] = $array->$val;
                        }
                    }
                    $i++;
                }
            }
        }
        return $retArray;
    }

    function funtopbarschoolyear($siteinfos, $topbarschoolyears)
    {
        $CI = &get_instance();
        $currentYearLabel = htmlspecialchars($siteinfos->school_year_label ?? $siteinfos->school_year ?? date('Y'));
        $currentYearID = $siteinfos->school_year ?? null;
        $yearsCount = is_array($topbarschoolyears) ? count($topbarschoolyears) : 0;
    
        echo '<div class="aiz-topbar-item mr-3 position-relative">';
        echo '  <div class="align-items-center d-flex dropdown schoolyear-dropdown">';
        // Calendar button with circular year badge (like notification bell)
        echo '    <a href="javascript:void(0);" class="dropdown-toggle no-arrow year-btn btn btn-topbar btn-icon btn-circle p-0 d-flex align-items-center justify-content-center"';
        echo '       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"';
        echo '       style="width: 36px; height: 36px; position: relative;">';
        // Calendar SVG (Bootstrap Icon)
        echo '      <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-calendar3" viewBox="0 0 16 16">';
        echo '        <path d="M14 3h-1V1.5a.5.5 0 0 0-1 0V3H4V1.5a.5.5 0 0 0-1 0V3H2a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zM1 5a1 1 0 0 1 1-1h1v1.5a.5.5 0 0 0 1 0V4h8v1.5a.5.5 0 0 0 1 0V4h1a1 1 0 0 1 1 1v1H1V5zm0 2h14v5a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V7z"/>';
        echo '      </svg>';
        // Year badge shows count of school years
        echo '      <span class="badge badge-primary topbar-badge year-badge" style="position: absolute; top: 0; right: 0;">' . $yearsCount . '</span>';
        echo '    </a>';
        // Dropdown menu (left-aligned, not right)
        echo '    <div class="dropdown-menu modern-user-dropdown dropdown-menu-animated dropdown-menu-xl py-0 schoolyear-dropdown-menu" style="min-width: 200px;">';
        echo '      <div style="font-weight: 600; font-size: 14px; margin-bottom: 8px; padding: 8px 12px 0 12px;">Academic Years</div>';
        echo '      <ul class="list-unstyled mb-0" style="margin: 0; padding: 0;">';
    
        foreach ($topbarschoolyears as $topbarschoolyear) {
            $isCurrent = ($currentYearID == $topbarschoolyear->schoolyearID);
            $isDefault = ($CI->session->userdata('defaultschoolyearID') == $topbarschoolyear->schoolyearID);
    
            // Compose classes for styling
            $classes = 'dropdown-item';
            if ($isCurrent) $classes .= ' current-year';
    
            echo '<li style="padding: 0;">';
            echo '  <a href="' . base_url("schoolyear/toggleschoolyear/$topbarschoolyear->schoolyearID") . '"'
                . ' class="' . $classes . '"'
                . ' style="display: flex; justify-content: space-between; align-items: center; padding: 10px 12px;'
                . ' border-radius: 6px; margin-bottom: 2px; font-size: 14px; text-decoration: none;'
                . ($isCurrent ? 'background-color: #e7f3ff; color: #007bff; font-weight: bold;' : 'color: #555; background-color: transparent; font-weight: 400;') . '">';
            echo    htmlspecialchars($topbarschoolyear->schoolyear);
            if ($isCurrent) {
                // Checkmark SVG badge for current year
                echo '<span class="ml-2" style="display: flex; align-items: center;">';
                echo '  <svg width="18" height="18" viewBox="0 0 16 16" fill="#28a745" xmlns="http://www.w3.org/2000/svg" style="margin-right:2px;">';
                echo '    <circle cx="8" cy="8" r="7" fill="#e6f9ed" stroke="#28a745" stroke-width="2"/>';
                echo '    <path d="M5.5 8.5l2 2 3-3" stroke="#28a745" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/>';
                echo '  </svg>';
                echo '  <span style="font-size: 12px; color: #28a745; font-weight: 500;">Current</span>';
                echo '</span>';
            } elseif ($isDefault) {
                echo '<i class="glyphicon glyphicon-ok" style="color: #28a745; margin-left: 8px;"></i>';
            }
            echo '  </a>';
            echo '</li>';
        }
    
        echo '      </ul>';
        echo '    </div>';
        echo '  </div>';
        echo '</div>';
    }
    
    function getNameByUsertypeIDAndUserID( $usertypeID, $userID )
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('systemadmin_m');
        $CI->load->model('teacher_m');
        $CI->load->model('student_m');
        $CI->load->model('parents_m');
        $CI->load->model('user_m');

        $findUserName = '';
        if ( $usertypeID == 1 ) {
            $user        = $CI->db->get_where('systemadmin',
                [ "usertypeID" => $usertypeID, 'systemadminID' => $userID ]);
            $alluserdata = $user->row();
            if ( customCompute($alluserdata) ) {
                $findUserName = $alluserdata->name;
            }
            return $findUserName;
        } elseif ( $usertypeID == 2 ) {
            $user        = $CI->db->get_where('teacher', [ "usertypeID" => $usertypeID, 'teacherID' => $userID ]);
            $alluserdata = $user->row();
            if ( customCompute($alluserdata) ) {
                $findUserName = $alluserdata->name;
            }
            return $findUserName;
        } elseif ( $usertypeID == 3 ) {
            $user        = $CI->db->get_where('student', [ "usertypeID" => $usertypeID, 'studentID' => $userID ]);
            $alluserdata = $user->row();
            if ( customCompute($alluserdata) ) {
                $findUserName = $alluserdata->name;
            }
            return $findUserName;
        } elseif ( $usertypeID == 4 ) {
            $user        = $CI->db->get_where('parents', [ "usertypeID" => $usertypeID, 'parentsID' => $userID ]);
            $alluserdata = $user->row();
            if ( customCompute($alluserdata) ) {
                $findUserName = $alluserdata->name;
            }
            return $findUserName;
        } else {
            $user        = $CI->db->get_where('user', [ "usertypeID" => $usertypeID, 'userID' => $userID ]);
            $alluserdata = $user->row();
            if ( customCompute($alluserdata) ) {
                $findUserName = $alluserdata->name;
            }
            return $findUserName;
        }
        return $findUserName;
    }
    
    
    
    function getObjectByUserTypeIDAndUserID( $usertypeID, $userID, $schoolyearID = null )
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('systemadmin_m');
        $CI->load->model('teacher_m');
        $CI->load->model('student_m');
        $CI->load->model('studentrelation_m');
        $CI->load->model('classes_m');
        $CI->load->model('section_m');
        $CI->load->model('parents_m');
        $CI->load->model('user_m');
        $CI->load->model('usertype_m');
        $user     = [];
        $usertype = $CI->db->get_where('usertype', [ "usertypeID" => $usertypeID ]);
        if ( $usertypeID == 1 ) {
            $user = $CI->systemadmin_m->get_single_systemadmin([
                "usertypeID"    => $usertypeID,
                'systemadminID' => $userID
            ]);
        } elseif ( $usertypeID == 2 ) {
            $user = $CI->teacher_m->general_get_single_teacher([ "usertypeID" => $usertypeID, 'teacherID' => $userID ]);
        } elseif ( $usertypeID == 3 ) {
            if ( $schoolyearID ) {
                $user = $CI->studentrelation_m->get_studentrelation_join_student([
                    'srstudentID'    => $userID,
                    'srschoolyearID' => $schoolyearID
                ], true);
                if ( customCompute($user) ) {
                    $class = $CI->classes_m->general_get_single_classes([ "classesID" => $user->srclassesID ]);
                    if ( customCompute($class) ) {
                        $user->classes = $class->classes;
                    }

                    $section = $CI->section_m->general_get_single_section([ "sectionID" => $user->srsectionID ]);
                    if ( customCompute($section) ) {
                        $user->section = $section->section;
                    }
                }
            } else {
                $user = $CI->student_m->general_get_single_student([
                    "usertypeID" => $usertypeID,
                    'studentID'  => $userID
                ]);
                if ( customCompute($user) ) {
                    $class = $CI->classes_m->get_single_classes([ "classesID" => $user->classesID ]);
                    if ( customCompute($class) ) {
                        $user->classes = $class->classes;
                    }

                    $section = $CI->section_m->get_single_section([ "sectionID" => $user->sectionID ]);
                    if ( customCompute($section) ) {
                        $user->section = $section->section;
                    }
                }
            }
        } elseif ( $usertypeID == 4 ) {
            $user = $CI->parents_m->get_single_parents([ "usertypeID" => $usertypeID, 'parentsID' => $userID ]);
        } else {
            $user = $CI->user_m->get_single_user([ "usertypeID" => $usertypeID, 'userID' => $userID ]);
        }

        if ( customCompute($usertype) && customCompute($user) ) {
            $user->usertype = $usertype->row()->usertype;
        }
        return $user;
    }
    function getStudentObjectWithStudentRelation( $arrays, $studentJoin = false, $studentExtendJoin = false )
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('student_m');
        $CI->load->model('studentrelation_m');
        $returnArray = [];

        if ( !is_array($arrays) ) {
            if ( is_int($arrays) ) {
                $intSchoolYearID          = $arrays;
                $arrays                   = [];
                $arrays['srschoolyearID'] = $intSchoolYearID;
            } elseif ( !empty($arrays) && is_numeric($arrays) ) {
                $intSchoolYearID          = $arrays;
                $arrays                   = [];
                $arrays['srschoolyearID'] = $intSchoolYearID;
            } else {
                throw new Exception("School YearID is required");
            }
        } else {
            if ( !isset($arrays['srschoolyearID']) && !isset($arrays['schoolyearID']) ) {
                throw new Exception("School YearID is required");
            } elseif ( isset($arrays['schoolyearID']) ) {
                $arrays['srschoolyearID'] = $arrays['schoolyearID'];
                unset($arrays['schoolyearID']);
            }
        }

        $student = [];
        if ( $studentJoin && $studentExtendJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays, $studentExtendJoin);
        } elseif ( $studentJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays);
        } elseif ( $studentExtendJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays, $studentExtendJoin);
        } elseif ( customCompute($arrays) ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays);
        } else {
            $student = $CI->studentrelation_m->get_studentrelation();
        }

        if ( customCompute($student) ) {
            foreach($student as $key){
                $returnArray[$key->srstudentID] = $key; // pluck($student, 'obj', 'srstudentID');
            }
        }

        return $returnArray;
    }
    function getAllUserObjectWithStudentRelation( $arrays, $studentJoin = false, $studentExtendJoin = false )
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('systemadmin_m');
        $CI->load->model('teacher_m');
        $CI->load->model('student_m');
        $CI->load->model('parents_m');
        $CI->load->model('user_m');
        $CI->load->model('studentrelation_m');
        $returnArray = [];

        if ( !is_array($arrays) ) {
            if ( is_int($arrays) ) {
                $intSchoolYearID          = $arrays;
                $arrays                   = [];
                $arrays['srschoolyearID'] = $intSchoolYearID;
            } elseif ( !empty($arrays) && is_numeric($arrays) ) {
                $intSchoolYearID          = $arrays;
                $arrays                   = [];
                $arrays['srschoolyearID'] = $intSchoolYearID;
            } else {
                throw new Exception("School YearID is required");
            }
        } else {
            if ( !isset($arrays['srschoolyearID']) && !isset($arrays['schoolyearID']) ) {
                throw new Exception("School YearID is required");
            } elseif ( isset($arrays['schoolyearID']) ) {
                $arrays['srschoolyearID'] = $arrays['schoolyearID'];
                unset($arrays['schoolyearID']);
            }
        }

        $systemadmin = $CI->systemadmin_m->get_systemadmin();
        if ( customCompute($systemadmin) ) {
            $returnArray[1] = pluck($systemadmin, 'obj', 'systemadminID');
        }

        $teacher = $CI->teacher_m->get_teacher();
        if ( customCompute($teacher) ) {
            $returnArray[2] = pluck($teacher, 'obj', 'teacherID');
        }

        $student = [];
        if ( $studentJoin && $studentExtendJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays, $studentExtendJoin);
        } elseif ( $studentJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays);
        } elseif ( $studentExtendJoin ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays, $studentExtendJoin);
        } elseif ( customCompute($arrays) ) {
            $student = $CI->studentrelation_m->general_get_order_by_student($arrays);
        } else {
            $student = $CI->studentrelation_m->get_studentrelation();
        }

        if ( customCompute($student) ) {
            $returnArray[3] = pluck($student, 'obj', 'srstudentID');
        }

        $parent = $CI->parents_m->get_parents();
        if ( customCompute($parent) ) {
            $returnArray[4] = pluck($parent, 'obj', 'parentsID');
        }

        $users = $CI->user_m->get_user();
        if ( customCompute($users) ) {
            foreach ( $users as $user ) {
                $returnArray[ $user->usertypeID ][ $user->userID ] = $user;
            }
        }

        return $returnArray;
    }


    function getAllUserObjectWithoutStudent()
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('systemadmin_m');
        $CI->load->model('teacher_m');
        $CI->load->model('user_m');

        $returnArray = [];

        $systemadmin = $CI->systemadmin_m->get_systemadmin();
        if ( customCompute($systemadmin) ) {
            $returnArray[1] = pluck($systemadmin, 'obj', 'systemadminID');
        }

        $teacher = $CI->teacher_m->general_get_teacher();
        if ( customCompute($teacher) ) {
            $returnArray[2] = pluck($teacher, 'obj', 'teacherID');
        }

        $users = $CI->user_m->get_user();
        if ( customCompute($users) ) {
            foreach ( $users as $user ) {
                $returnArray[ $user->usertypeID ][ $user->userID ] = $user;
            }
        }

        return $returnArray;
    }

    function getAllSelectUser( $schoolYearID = null )
    { /* DD OK */
        $CI = &get_instance();
        $CI->load->model('systemadmin_m');
        $CI->load->model('teacher_m');
        $CI->load->model('parents_m');
        $CI->load->model('user_m');
        $CI->load->model('student_m');
        $returnArray = [];

        $systemadmin = $CI->systemadmin_m->get_select_systemadmin();
        if ( customCompute($systemadmin) ) {
            $returnArray[1] = pluck($systemadmin, 'obj', 'systemadminID');
        }

        $teacher = $CI->teacher_m->get_select_teacher();
        if ( customCompute($teacher) ) {
            $returnArray[2] = pluck($teacher, 'obj', 'teacherID');
        }

        if ( $schoolYearID == null ) {
            $student = $CI->student_m->get_select_student();
        } else {
            $student = $CI->student_m->get_select_student(null, [ 'schoolyearID' => $schoolYearID ]);
        }

        if ( customCompute($student) ) {
            $returnArray[3] = pluck($student, 'obj', 'studentID');
        }

        $parent = $CI->parents_m->get_select_parents();
        if ( customCompute($parent) ) {
            $returnArray[4] = pluck($parent, 'obj', 'parentsID');
        }

        $users = $CI->user_m->get_select_user();
        if ( customCompute($users) ) {
            foreach ( $users as $user ) {
                $returnArray[ $user->usertypeID ][ $user->userID ] = $user;
            }
        }

        return $returnArray;
    }

    function userInfo( $userTypeID, $userID, $field = 'name, photo')
    {
        $CI = &get_instance();
        if ( $userTypeID == 1 ) {
            $table = "systemadmin";
        } elseif ( $userTypeID == 2 ) {
            $table = "teacher";
        } elseif ( $userTypeID == 3 ) {
            $table = 'student';
        } elseif ( $userTypeID == 4 ) {
            $table = 'parents';
        } else {
            $table = 'user';
        }
        $CI->db->select($field);
        $CI->db->from($table);
        $CI->db->where([ $table . 'ID' => $userID ]);
        $query = $CI->db->get();
        return $query->row();
    }

    function btn_download( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-download'></i>",
            "class='btn btn-success btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }

    function btn_download_file( $uri, $name, $lang )
    {
        return anchor($uri, $name,
            "class='btn btn-success btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $lang . "'");
    }

    function btn_download_link( $uri, $name )
    {
        return anchor($uri, $name, "style='text-decoration:underline;color:#00c0ef'");
    }

    function btn_upload( $uri, $name )
    {
        return anchor($uri, "<i class='fa fa-upload'></i>",
            "class='btn bg-maroon-light btn-smaller mrg' data-placement='top' data-toggle='tooltip' data-original-title='" . $name . "'");
    }
    function get_url($uri = '')
	{
		$site_url = is_array($uri)
			? site_url($uri)
			: (preg_match('#^(\w+:)?//#i', $uri) ? $uri : site_url($uri));

		return $site_url;
	}

    function display_menu($nodes, &$menu)
    {
        $subUrl = ['/add', '/edit', '/view', '/index'];
    
        $CI = &get_instance();
    
        foreach ($nodes as $key => $node) {
    
            $leftIcon = '<i class="fa fa-angle-left pull-right aiz-side-nav-arrow"></i>';
    
            $f = 0;
            if (isset($node['child'])) {
                $f = 1;
            }
    
            if (permissionChecker($node['link']) || ($node['link'] == '#' && $f)) {
                if ($f && customCompute($node['child']) == 1) {
                    $f = 0;
                    $node = current($node['child']);
                }
                $treeView = $f ? 'aiz-side-nav-item-has-submenu' : '';
                $active = '';
    
                $current_url = current_url();
    
                foreach ($subUrl as $value) {
                    $newUrl = substr($current_url, 0, strpos($current_url, $value));
                    if ($newUrl != "") {
                        $current_url = $newUrl;
                    }
                }
    
                if (get_url($node['link']) == $current_url) {
                    $active = '';
                }
                $url = ($node['link'] == '#')? '#' : get_url($node['link']);
    
                $menu .= '<li class="aiz-side-nav-item">';
    
                $menu .= '<a href="' . $url . '" class="aiz-side-nav-link">';
                // $menu .= '<div class="aiz-side-nav-icon">';
                $menu .= '<i class="fa ' . ( $node['icon'] != null ? $node['icon'] : 'fa-home' ) . '" style="font-size:20px; color:#707070; margin-right:12px;margin-left:0px;"></i>';
                // $menu .= '</div>';
                $menu .= '<span class="aiz-side-nav-text">' . ($CI->lang->line('menu_' . $node['menuName']) != null ? $CI->lang->line('menu_' . $node['menuName']) : $node['menuName']) . '</span>';
                // $menu .= $f ? '<span class="aiz-side-nav-arrow"></span>' : '';
                $menu .= $f ? $leftIcon : '';
                $menu .= '</a>';
    
                if ($f) {
                    $menu .= '<ul class="aiz-side-nav-list level-2">';
                    display_menu($node['child'], $menu);
                    $menu .= "</ul>";
                }
                $menu .= "</li>";
            }
        }
    }

    function display_menus($nodes, &$menu)
    {
        $subUrl = ['/add', '/edit', '/view', '/index'];
        $CI = &get_instance();
        $lastSection = null; // Store the last section
    
        foreach ($nodes as $key => $node) {
    
            $leftIcon = '<i class="fa fa-angle-left pull-right aiz-side-nav-arrow"></i>';
    
            $f = isset($node['child']) ? 1 : 0;
    
            if (permissionChecker($node['link']) || ($node['link'] == '#' && $f)) {
                if ($f && customCompute($node['child']) == 1) {
                    $f = 0;
                    $node = current($node['child']);
                }
                
                $treeView = $f ? 'aiz-side-nav-item-has-submenu' : '';
                $active = '';
    
                $current_url = current_url();
                foreach ($subUrl as $value) {
                    $newUrl = substr($current_url, 0, strpos($current_url, $value));
                    if ($newUrl != "") {
                        $current_url = $newUrl;
                    }
                }
    
                if (get_url($node['link']) == $current_url) {
                    $active = '';
                }
                $url = ($node['link'] == '#') ? '#' : get_url($node['link']);
    
                // Check if the section has changed
                if ($lastSection !== $node['section']) {
                    $menu .= '<li class="aiz-side-nav-section">';
                    $menu .= '<span class="aiz-side-nav-section-title">' . strtoupper($node['section']?? '') . '</span>';
                    $menu .= '</li>';
                    $lastSection = $node['section']; // Update the last section
                }
    
                $menu .= '<li class="aiz-side-nav-item">';
                $menu .= '<a href="' . $url . '" class="aiz-side-nav-link">';
                $menu .= '<i class="fa ' . ($node['icon'] != null ? $node['icon'] : 'fa-home') . '" style="font-size:20px; color:#707070; margin-right:12px;margin-left:0px;"></i>';
                $menu .= '<span class="aiz-side-nav-text">' . ($CI->lang->line('menu_' . $node['menuName']) != null ? $CI->lang->line('menu_' . $node['menuName']) : $node['menuName']) . '</span>';
                $menu .= $f ? $leftIcon : '';
                $menu .= '</a>';
    
                if ($f) {
                    $menu .= '<ul class="aiz-side-nav-list level-2">';
                    display_menu($node['child'], $menu);
                    $menu .= "</ul>";
                }
                $menu .= "</li>";
            }
        }
    }

    function display_menuu( $nodes, &$menu )
    {

        $subUrl = [ '/add', '/edit', '/view', '/index' ];

        $CI = &get_instance();

        foreach ( $nodes as $key => $node ) {

            $leftIcon = '<i class="fa fa-angle-left pull-right"></i>';

            $f = 0;
            if ( isset($node['child']) ) {
                $f = 1;
            }

            if ( permissionChecker($node['link']) || ( $node['link'] == '#' && $f ) ) {
                if ( $f && customCompute($node['child']) == 1 ) {
                    $f    = 0;
                    $node = current($node['child']);
                }
                $treeView = 'nav-item ';
                $active   = 'false';

                $current_url = current_url();

                foreach ( $subUrl as $value ) {
                    $newUrl = substr($current_url, 0, strpos($current_url, $value));
                    if ( $newUrl != "" ) {
                        $current_url = $newUrl;
                    }
                }  

                if ( base_url($node['link']) == $current_url ) {
                    $active = ''; //active
                }

                $menu .= '<li class="' . $treeView . '">';
                $menu .= '<a class="nav-link menu-link" href="' . ( $f ? '#'. $node['menuName'] : base_url($node['link']) ) . '"';
                if ( $f ) {
                    $menu .= ' data-bs-toggle="collapse" role="button" aria-expanded="'.$active.'" aria-controls="' . $node['menuName'] . '"';
                }
                $menu .='>';
                $menu .= '<i class="' . ( $node['icon'] != null ? $node['icon'] : 'mdi mdi-speedometer' ) . '"></i> <span data-key="t-' . strtolower($node['menuName']) . '">' . ( $CI->lang->line('menu_' . $node['menuName']) != null ? $CI->lang->line('menu_' . $node['menuName']) : $node['menuName'] ) . '</span>';
                $menu .= '</a>';
                if ( $f ) {
                    $menu .= '<div class="collapse menu-dropdown" id="' . $node['menuName'] . '">';
                    $menu .= '<ul class="nav nav-sm flex-column">';
                    display_menu($node['child'], $menu);
                    $menu .= "</ul>";
                    $menu .= '</div>';
                }
                $menu .= "</li>";
            }

        }
    }

    function namesorting( $string, $len = 14 )
    {
        $return = $string;
        if ( isset($string) && $len ) {
            if ( strlen($string) > $len ) {
                $return = substr($string, 0, $len - 2) . '..';
            } else {
                $return = $string;
            }
        }

        return $return;
    }

    function frontendColorStyle( $string )
    {
        $setStr  = '';
        $bgColor = [ '#86bc42', '#222222', '#D9504E', '#1A4027', '#6F008D', '#E09622' ];
        if ( !empty($string) ) {
            $exps = explode(' ', $string);
            foreach ( $exps as $expKey => $exp ) {
                $setStr .= "<span style='color:" . $bgColor[ $expKey ] . "'> " . $exp . "</span>";
            }
        }
        return $setStr;
    }


    function formatSizeUnits( $bytes )
    {
        if ( $bytes >= 1073741824 ) {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        } elseif ( $bytes >= 1048576 ) {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        } elseif ( $bytes >= 1024 ) {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        } elseif ( $bytes > 1 ) {
            $bytes = $bytes . ' bytes';
        } elseif ( $bytes == 1 ) {
            $bytes = $bytes . ' byte';
        } else {
            $bytes = '0 bytes';
        }

        return $bytes;
    }

    function spClean( $string )
    {
        $string = strtolower($string);
        $string = str_replace(' ', '', $string); // Replaces all spaces with hyphens.
        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }

    function pageStatus( $data, $flag = true )
    {
        if ( $flag ) {
            $array = [
                'published' => 1,
                'draft'     => 2,
                'trash'     => 3,
                'review'    => 4,
            ];

            if ( isset($array[ $data ]) ) {
                return $array[ $data ];
            } else {
                return 1;
            }
        }

        if ( $flag == false ) {
            $array = [
                1 => 'published',
                2 => 'draft',
                3 => 'trash',
                4 => 'review'
            ];

            if ( isset($array[ $data ]) ) {
                return $array[ $data ];
            } else {
                return 'publish';
            }
        }
    }

    function pageVisibility( $visibility, $flag = true, $send = 1 )
    {
        $CI       = &get_instance();
        $language = $CI->session->userdata('lang');
        $CI->lang->load('pages', $language);

        if ( $flag ) {
            $status = false;
            if ( $visibility == 1 && $send == 1 ) {
                $status = true;
            } elseif ( $visibility == 2 && $send == 2 ) {
                $status = true;
            } elseif ( $visibility == 3 && $send == 3 ) {
                $status = true;
            }
            return $status;
        }

        if ( $flag == false ) {
            if ( $visibility == 1 ) {
                echo $CI->lang->line('pages_public');
            } elseif ( $visibility == 2 ) {
                echo $CI->lang->line('pages_password_protected');
            } elseif ( $visibility == 3 ) {
                echo $CI->lang->line('pages_private');
            }
        }
    }


    function validateDate( $date, $format = 'Y-m-d H:i:s' )
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    function sentenceMap( $string, $numberOFWord, $startTag, $closeTag )
    {
        $exp        = explode(' ', $string);
        $len        = 0;
        $expEnd     = end($exp);
        $f          = true;
        $stringWarp = '';
        foreach ( $exp as $key => $sn ) {
            $len += strlen($sn);
            $len++;

            if ( $len >= $numberOFWord ) {
                if ( $f ) {
                    $stringWarp .= $startTag;
                    $f          = false;
                }
            }

            $stringWarp .= $sn . ' ';

            if ( $sn == $expEnd ) {
                if ( $f == false ) {
                    $stringWarp .= $closeTag;
                }
                return $stringWarp;
            }
        }
    }

    function xssRemove( $data )
    {
        $string = preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", $data);
        return $string;
    }

    function addOrdinalNumberSuffix( $num )
    {
        if ( !in_array(( $num % 100 ), [ 11, 12, 13 ]) ) {
            switch ( $num % 10 ) {
                case 1:
                    return $num . 'st';
                case 2:
                    return $num . 'nd';
                case 3:
                    return $num . 'rd';
            }
        }
        return $num . 'th';
    }


    function btn_printReport( $permission, $name, $DivID = 'printablediv' )
    {
        if ( permissionChecker($permission) ) {
            return '<button class="btn btn-default" onclick="javascript:printDiv' . "('" . $DivID . "')" . '"><span class="fa fa-print"></span> ' . $name . '</button>';
        }
        return '';
    }

    function btn_sentToMailReport( $permission, $name )
    {
        if ( permissionChecker($permission) ) {
            return '<button class="btn btn-default" data-toggle="modal" data-target="#mail"><span class="fa fa-envelope-o"></span> ' . $name . '</button>';
        }
        return '';
    }

    function btn_pdfPreviewReport( $permission, $uri, $name )
    {
        if ( permissionChecker($permission) ) {
            return anchor($uri, "<i class='fa fa-file'></i> " . $name,
                'class="btn btn-default pdfurl" target="_blank"');
        }
        return '';
    }

    function btn_xmlReport( $permission, $uri, $name )
    {
        if ( permissionChecker($permission) ) {
            return anchor($uri, "<i class='fa fa-file'></i> " . $name,
                'class="btn btn-default xmlurl" target="_blank"');
        }
        return '';
    }


    function btn_flat_printReport( $permission, $name, $DivID = 'printablediv' )
    {
        if ( permissionChecker($permission) ) {
            return '<button style="margin: 0 3px;" class="btn btn-default" onclick="javascript:printDiv' . "('" . $DivID . "')" . '"><span class="fa fa-print"></span> ' . $name . '</button>';
        }
        return '';
    }

    function btn_flat_xmlReport( $permission, $name )
    {
        if ( permissionChecker($permission) ) {
            return '<button style="margin: 0 3px;" class="btn btn-default"><span class="fa fa-file-excel-o"></span> ' . $name . '</button>';
        }
        return '';
    }

    function btn_flat_sentToMailReport( $permission, $name )
    {
        if ( permissionChecker($permission) ) {
            return '<button style="margin: 0 3px;" class="btn btn-default"><span class="fa fa-envelope-o"></span> ' . $name . '</button>';
        }
        return '';
    }

    function btn_flat_pdfPreviewReport( $permission, $uri, $name )
    {
        if ( permissionChecker($permission) ) {
            return anchor($uri, "<i class='fa fa-file'></i> " . $name,
                ' style="margin: 0 3px;" class="btn btn-default" target="_blank"');
        }
        return '';
    }


    function callDesignCss()
    {
        $file  = file_get_contents('http://localhost/school4/assets/bootstrap/bootstrap.min.css');
        $file2 = file_get_contents('http://localhost/school4/assets/inilabs/themes/default/style.css');
        $file3 = file_get_contents('http://localhost/school4/assets/inilabs/themes/default/inilabs.css');
        $file4 = file_get_contents('http://localhost/school4/assets/inilabs/combined.css');
        echo '<style type="text/css">' . $file . $file2 . $file3 . $file4 . '</style>';
    }

    function get_month_and_year_using_two_date( $startdate, $enddate )
    {
        $start = new DateTime($startdate);
        $start->modify('first day of this month');
        $end = new DateTime($enddate);
        $end->modify('first day of next month');
        $interval = DateInterval::createFromDateString('1 month');
        $period   = new DatePeriod($start, $interval, $end);

        $monthAndYear = [];
        if ( customCompute($period) ) {
            foreach ( $period as $dt ) {
                $monthAndYear[ $dt->format("Y") ][] = $dt->format("m");
            }
        }
        return $monthAndYear;
    }


    function generate_qrcode( $text = "Hi", $filename = "default", $folder = "idQRcode" )
    {
        $CI = &get_instance();
        $CI->load->library('qrcodegenerator');
        $CI->qrcodegenerator->generate_qrcode($text, $filename, $folder);
    }

    function lzero( $num )
    {
        $numPadded = sprintf("%02d", $num);
        return $numPadded;
    }

    function reportheader( $setting, $schoolyear, $pdf = false )
    {
        $data = '';
        $CI   = &get_instance();
        if ( customCompute($setting) && customCompute($schoolyear) ) {
            $data .= '<div class="reportPage-header">';
            if ( $pdf ) {
                $data .= '<span class="header"><img class="logo" src="' . base_url('uploads/images/' . $setting->photo) . '"></span>';
            } else {
                $data .= '<span class="header" id="headerImage"><p class="bannerLogo"><img src="' . base_url('uploads/images/' . $setting->photo) . '"></p></span>';
            }
            $data .= '<p class="title">' . $setting->sname . '</p>';
            $data .= '<p class="title-desc">' . $setting->address . '</p>';
            $data .= '<p class="title-desc">' . $CI->lang->line('topbar_academic_year') . ' : ' . $schoolyear->schoolyear . '</p>';
            $data .= '</div>';
        }
        return $data;
    }

    function reportfooter( $setting, $schoolyear, $pdf = false )
    {
        $data = '';
        $CI   = &get_instance();
        if ( customCompute($setting) && customCompute($schoolyear) ) {
            $data .= '<div class="footer">';
            $data .= '<img class="flogo" style="width:30px" src="' . base_url("uploads/images/$setting->photo") . '">';
            $data .= '<p class="copyright">' . $setting->footer . ' | ' . $CI->lang->line('topbar_hotline') . ' : ' . $setting->phone . '</p>';
            $data .= '</div>';
        }
        return $data;
    }


    function featureheader( $siteinfos )
    {
        $CI = &get_instance(); ?>
        <div class="headerArea">
            <div class="siteLogo">
                <img class="siteLogoimg" src="<?= base_url('uploads/images/' . $siteinfos->photo) ?>" alt="">
            </div>
            <div class="siteTitle">
                <h2><?= $siteinfos->sname ?></h2>
                <address>
                    <?= $siteinfos->address ?><br/>
                    <b><?= $CI->lang->line('topbar_email') ?>:</b> <?= $siteinfos->email ?><br/>
                    <b><?= $CI->lang->line('topbar_phone') ?>:</b> <?= $siteinfos->phone ?>
                </address>
            </div>
        </div>
        <?php
    }

    function featurefooter( $siteinfos )
    {
        $CI = &get_instance(); ?>
        <div class="footerArea">
            <img class="flogo" src="<?= base_url('uploads/images/' . $siteinfos->photo) ?>" alt="">
            <p class="copyright"><?= $siteinfos->footer ?> | <?= $CI->lang->line('topbar_hotline') ?>
                <b> : </b><?= $siteinfos->phone ?></p>
        </div>
        <?php
    }

    function lang( $line, $for = '', $attributes = [] )
    {
        $line = get_instance()->lang->line($line);

        if ( $for !== '' ) {
            $line = '<label for="' . $for . '"' . _stringify_attributes($attributes) . '>' . $line . '</label>';
        }

        return $line;
    }

    if ( !function_exists('redirect_back') ) {
        function redirect_back()
        {
            if ( isset($_SERVER['HTTP_REFERER']) ) {
                header('Location: ' . $_SERVER['HTTP_REFERER']);
            } else {
                header('Location: http://' . $_SERVER['SERVER_NAME']);
            }
            exit;
        }
    }

    function imageLinkWithDefatulImage( $photoName, $defaultPhotoName = 'default.png', $srcpath = null )
    {
        if ( $srcpath == null ) {
            if ( $photoName != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoName) ) {
                    $src = base_url('uploads/images/' . $photoName);
                } else {
                    $src = base_url('uploads/images/' . $defaultPhotoName);
                }
            } else {
                $src = base_url('uploads/images/' . $defaultPhotoName);
            }
        } else {
            if ( $photoName != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoName) ) {
                    $src = base_url($srcpath . '/' . $photoName);
                } else {
                    $src = base_url('uploads/images/' . $defaultPhotoName);
                }
            } else {
                $src = base_url('uploads/images/' . $defaultPhotoName);
            }
        }
        return $src;
    }

    function imagelink( $photoname, $srcpath = null )
    {
        $src = '';
        if ( $srcpath == null ) {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoname) ) {
                    $src = base_url('uploads/images/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        } else {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoname) ) {
                    $src = base_url($srcpath . '/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        }
        return $src;
    }

    function pdfimagelink( $photoname, $srcpath = null )
    {
        if ( $srcpath == null ) {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoname) ) {
                    $src = base_url('uploads/images/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        } else {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoname) ) {
                    $src = base_url($srcpath . '/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        }
        return $src;
    }

    function profileimage( $photoname, $srcpath = null )
    {
        if ( $srcpath == null ) {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoname) ) {
                    $src = base_url('uploads/images/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        } else {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoname) ) {
                    $src = base_url($srcpath . '/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        }

        $array = [
            "src"    => $src,
            'width'  => '35px',
            'height' => '35px',
            'class'  => 'img-rounded'
        ];
        return img($array);
    }

    function profileviewimage( $photoname, $srcpath = null )
    {
        if ( $srcpath == null ) {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoname) ) {
                    $src = base_url('uploads/images/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        } else {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoname) ) {
                    $src = base_url($srcpath . '/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        }

        $array = [
            "src"   => $src,
            'class' => 'profile-user-img img-responsive img-circle'
        ];
        return img($array);
    }

    function profileproimage( $photoname, $srcpath = null )
    {
        if ( $srcpath == null ) {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . 'uploads/images/' . $photoname) ) {
                    $src = base_url('uploads/images/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        } else {
            if ( $photoname != null ) {
                if ( file_exists(FCPATH . $srcpath . '/' . $photoname) ) {
                    $src = base_url($srcpath . '/' . $photoname);
                } else {
                    $src = base_url('uploads/images/default.png');
                }
            } else {
                $src = base_url('uploads/images/default.png');
            }
        }

        $string = '<a width="35px" height="35px" class="card-image img-rounded" href="#" style="background-image: url(' . base_url("uploads/images/default.png") . ');" data-image-full="' . $src . '"><img class="img-rounded" width="35px" height="35px" src="' . $src . '" alt="Psychopomp" /></a>';
        return $string;

        // $array = array(
        //     "src" => $src,
        //     'width' => '35px',
        //     'height' => '35px',
        //     'class' => 'img-rounded'
        // );
        // return img($array);
    }

    function profiledeleted( $id, $lang )
    {
        if ( !$id ) {
            return '<span class="text-red">(' . $lang . ')';
        }
    }


    function get_day_using_two_date( $fromDate, $toDate )
    {
        $oneDay = 60 * 60 * 24;

        $day = [];
        for ( $i = $fromDate; $i <= $toDate; $i = $i + $oneDay ) {
            $day[] = date('d-m-Y', $i);
        }
        return $day;
    }

    function random19()
    {
        $number = "";
        for ( $i = 0; $i < 19; $i++ ) {
            $min    = ( $i == 0 ) ? 1 : 0;
            $number .= mt_rand($min, 9);
        }
        return $number;
    }

    function timelefter( $dafstdate )
    {
        $pdate       = date("Y-m-d H:i:s");
        $first_date  = new DateTime($dafstdate);
        $second_date = new DateTime($pdate);
        $difference  = $first_date->diff($second_date);
        if ( $difference->y >= 1 ) {
            $format = 'Y-m-d H:i:s';
            $date   = DateTime::createFromFormat($format, $dafstdate);
            return $date->format('M d Y');
        } elseif ( $difference->m == 1 && $difference->m != 0 ) {
            return $difference->m . " month ago";
        } elseif ( $difference->m <= 12 && $difference->m != 0 ) {
            return $difference->m . " months ago";
        } elseif ( $difference->d == 1 && $difference->d != 0 ) {
            return "Yesterday";
        } elseif ( $difference->d <= 31 && $difference->d != 0 ) {
            return $difference->d . " days ago";
        } else {
            if ( $difference->h == 1 && $difference->h != 0 ) {
                return $difference->h . " hr ago";
            } else {
                if ( $difference->h <= 24 && $difference->h != 0 ) {
                    return $difference->h . " hrs ago";
                } elseif ( $difference->i <= 60 && $difference->i != 0 ) {
                    return $difference->i . " mins ago";
                } elseif ( $difference->s <= 10 ) {
                    return "Just Now";
                } elseif ( $difference->s <= 60 && $difference->s != 0 ) {
                    return $difference->s . " sec ago";
                }
            }
        }
    }

    function markCalculation( $getmark, $subjectFinalmark, $percentageMark = 100 )
    {
        $retMark = ( ( $getmark * $percentageMark ) / $subjectFinalmark );
        return floor($retMark);
    }

    function markCalculationView( $getmark, $subjectFinalmark, $percentageMark = 100 )
    {
        if ( $getmark == 0 || $getmark == '' ) {
            return 0;
        } else {
            $retMark = ( ( $getmark * 100 ) / $subjectFinalmark );
            if ( $retMark == 0 ) {
                return 0;
            } else {
                if($percentageMark != 0) {
                    $retMark = ( ( $retMark * 100 ) / $percentageMark );
                }
                return floor($retMark);
            }
        }
    }

    function convertMarkpercentage( $getMark, $subjectFinalMark, $percentage = 100 )
    {
        $retMarkpercentage = ( ( $getMark * $subjectFinalMark ) / $percentage );
        return floor($retMarkpercentage);
    }

    function inputCall( $name = null )
    {
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata, true);
        if ( $request == null ) {
            if ( isset($_POST[ $name ]) ) {
                return $_POST[ $name ];
            } else {
                return $_POST;
            }
            return;
        } else {
            if ( isset($request[ $name ]) ) {
                return $request[ $name ];
            } else {
                return $request;
            }
            return;
        }
    }

    function ini_round( $number, $digit = 2 )
    {
        $number = round($number, $digit, PHP_ROUND_HALF_EVEN);
        return sprintf("%." . $digit . "f", $number);
    }

    function iniArrayToString($arrays) {
        $retString = "";
        if(customCompute($arrays)) {
            foreach ($arrays as $value) {
                $retString .= $value.".<br/>";
            }
        }
        return $retString;
    }


    function mergeArray($array1, $array2, $key) {
        $retArray = [];
        $flag     = false;
        if(customCompute($array1)) {
            $flag = true;
            foreach ($array1 as $array) {
                $retArray[$array->$key] = $array->$key;
            }
        }

        if(customCompute($array2)) {
            $flag = true;
            foreach ($array2 as $array) {
                $retArray[$array->$key] = $array->$key;
            }
        }
        if($flag) {
            ksort($retArray);
        }
        return $retArray;
    }
  
  /*
  //OLD HELPER B4_AI//
    
    function sendSms($phone, $sms, $name){
        $ci     = &get_instance();
        $ci->load->model("mailandsms_m");
        $ci->load->library('sms/skooly_init');
        
        Skooly::send($phone, $sms, '');

        $stdat = array(
            'usertypeID' => '0',
            'users' => $name,
            'type' => ucfirst('automated'),
            'message' => $sms,
            'year' => date('Y'),
            'senderusertypeID' => 1,
            'senderID' => 1
        );
        $ci->mailandsms_m->insert_mailandsms($stdat);

    } */
    
    function sendSms($phone, $sms, $name, $usertypeID = 0, $userID = null, $module = 'generic', $action = 'manual_send') {
        // Construct user object for logging and compatibility
        $user = (object)[
            'phone'      => $phone,
            'name'       => $name,
            'usertypeID' => $usertypeID,
            'userID'     => $userID
            // Add studentID/systemadminID if needed in the future
        ];
    
        // Use SmsService to send and log generic SMS
        return SmsService::sendGenericSms($user, $sms, $module, $action);
    }
    function getTrx($length = 12)
    {
        $characters = 'ABCDEFGHJKMNOPQRSTUVWXYZ123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    if (!function_exists('getSchoolYear')) {

        function getSchoolYear() {            
            $CI =& get_instance();
            $CI->load->database();

            $schoolyearID = $CI->session->userdata('defaultschoolyearID');
    
            $query = $CI->db->get_where('schoolyear', array('schoolyearID' => $schoolyearID), 1);
    
            if ($query->num_rows() > 0) {
                $row = $query->row();
                return $row->schoolyear;
            }
    
            return false;
        }
    
    }

    
if ( ! function_exists('force_download'))
{
	/**
	 * Force Download
	 *
	 * Generates headers that force a download to happen
	 *
	 * @param	string	filename
	 * @param	mixed	the data to be downloaded
	 * @param	bool	whether to try and send the actual file MIME type
	 * @return	void
	 */
	function force_download($filename = '', $data = '', $set_mime = FALSE)
	{
		if ($filename === '' OR $data === '')
		{
			return;
		}
		elseif ($data === NULL)
		{
			if ( ! @is_file($filename) OR ($filesize = @filesize($filename)) === FALSE)
			{
				return;
			}

			$filepath = $filename;
			$filename = explode('/', str_replace(DIRECTORY_SEPARATOR, '/', $filename));
			$filename = end($filename);
		}
		else
		{
			$filesize = strlen($data);
		}

		// Set the default MIME type to send
		$mime = 'application/octet-stream';

		$x = explode('.', $filename);
		$extension = end($x);

		if ($set_mime === TRUE)
		{
			if (count($x) === 1 OR $extension === '')
			{
				/* If we're going to detect the MIME type,
				 * we'll need a file extension.
				 */
				return;
			}

			// Load the mime types
			$mimes =& get_mimes();

			// Only change the default MIME if we can find one
			if (isset($mimes[$extension]))
			{
				$mime = is_array($mimes[$extension]) ? $mimes[$extension][0] : $mimes[$extension];
			}
		}

		/* It was reported that browsers on Android 2.1 (and possibly older as well)
		 * need to have the filename extension upper-cased in order to be able to
		 * download it.
		 *
		 * Reference: http://digiblog.de/2011/04/19/android-and-the-download-file-headers/
		 */
		if (count($x) !== 1 && isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android\s(1|2\.[01])/', $_SERVER['HTTP_USER_AGENT']))
		{
			$x[count($x) - 1] = strtoupper($extension);
			$filename = implode('.', $x);
		}

		if ($data === NULL && ($fp = @fopen($filepath, 'rb')) === FALSE)
		{
			return;
		}

		// Clean output buffer
		if (ob_get_level() !== 0 && @ob_end_clean() === FALSE)
		{
			@ob_clean();
		}

		// Generate the server headers
		header('Content-Type: '.$mime);
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		header('Expires: 0');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: '.$filesize);
		header('Cache-Control: private, no-transform, no-store, must-revalidate');

		// If we have raw data - just dump it
		if ($data !== NULL)
		{
			exit($data);
		}

		// Flush 1MB chunks of data
		while ( ! feof($fp) && ($data = fread($fp, 1048576)) !== FALSE)
		{
			echo $data;
		}

		fclose($fp);
		exit;
	}
}

function getAllCountry() {
    $country = array(
        "AF" => "Afghanistan",
        "AL" => "Albania",
        "DZ" => "Algeria",
        "AS" => "American Samoa",
        "AD" => "Andorra",
        "AO" => "Angola",
        "AI" => "Anguilla",
        "AQ" => "Antarctica",
        "AG" => "Antigua and Barbuda",
        "AR" => "Argentina",
        "AM" => "Armenia",
        "AW" => "Aruba",
        "AU" => "Australia",
        "AT" => "Austria",
        "AZ" => "Azerbaijan",
        "BS" => "Bahamas",
        "BH" => "Bahrain",
        "BD" => "Bangladesh",
        "BB" => "Barbados",
        "BY" => "Belarus",
        "BE" => "Belgium",
        "BZ" => "Belize",
        "BJ" => "Benin",
        "BM" => "Bermuda",
        "BT" => "Bhutan",
        "BO" => "Bolivia",
        "BA" => "Bosnia and Herzegovina",
        "BW" => "Botswana",
        "BV" => "Bouvet Island",
        "BR" => "Brazil",
        "BQ" => "British Antarctic Territory",
        "IO" => "British Indian Ocean Territory",
        "VG" => "British Virgin Islands",
        "BN" => "Brunei",
        "BG" => "Bulgaria",
        "BF" => "Burkina Faso",
        "BI" => "Burundi",
        "KH" => "Cambodia",
        "CM" => "Cameroon",
        "CA" => "Canada",
        "CT" => "Canton and Enderbury Islands",
        "CV" => "Cape Verde",
        "KY" => "Cayman Islands",
        "CF" => "Central African Republic",
        "TD" => "Chad",
        "CL" => "Chile",
        "CN" => "China",
        "CX" => "Christmas Island",
        "CC" => "Cocos [Keeling] Islands",
        "CO" => "Colombia",
        "KM" => "Comoros",
        "CG" => "Congo - Brazzaville",
        "CD" => "Congo - Kinshasa",
        "CK" => "Cook Islands",
        "CR" => "Costa Rica",
        "HR" => "Croatia",
        "CU" => "Cuba",
        "CY" => "Cyprus",
        "CZ" => "Czech Republic",
        "CI" => "Côte d’Ivoire",
        "DK" => "Denmark",
        "DJ" => "Djibouti",
        "DM" => "Dominica",
        "DO" => "Dominican Republic",
        "NQ" => "Dronning Maud Land",
        "DD" => "East Germany",
        "EC" => "Ecuador",
        "EG" => "Egypt",
        "SV" => "El Salvador",
        "GQ" => "Equatorial Guinea",
        "ER" => "Eritrea",
        "EE" => "Estonia",
        "ET" => "Ethiopia",
        "FK" => "Falkland Islands",
        "FO" => "Faroe Islands",
        "FJ" => "Fiji",
        "FI" => "Finland",
        "FR" => "France",
        "GF" => "French Guiana",
        "PF" => "French Polynesia",
        "TF" => "French Southern Territories",
        "FQ" => "French Southern and Antarctic Territories",
        "GA" => "Gabon",
        "GM" => "Gambia",
        "GE" => "Georgia",
        "DE" => "Germany",
        "GH" => "Ghana",
        "GI" => "Gibraltar",
        "GR" => "Greece",
        "GL" => "Greenland",
        "GD" => "Grenada",
        "GP" => "Guadeloupe",
        "GU" => "Guam",
        "GT" => "Guatemala",
        "GG" => "Guernsey",
        "GN" => "Guinea",
        "GW" => "Guinea-Bissau",
        "GY" => "Guyana",
        "HT" => "Haiti",
        "HM" => "Heard Island and McDonald Islands",
        "HN" => "Honduras",
        "HK" => "Hong Kong SAR China",
        "HU" => "Hungary",
        "IS" => "Iceland",
        "IN" => "India",
        "ID" => "Indonesia",
        "IR" => "Iran",
        "IQ" => "Iraq",
        "IE" => "Ireland",
        "IM" => "Isle of Man",
        "IL" => "Israel",
        "IT" => "Italy",
        "JM" => "Jamaica",
        "JP" => "Japan",
        "JE" => "Jersey",
        "JT" => "Johnston Island",
        "JO" => "Jordan",
        "KZ" => "Kazakhstan",
        "KE" => "Kenya",
        "KI" => "Kiribati",
        "KW" => "Kuwait",
        "KG" => "Kyrgyzstan",
        "LA" => "Laos",
        "LV" => "Latvia",
        "LB" => "Lebanon",
        "LS" => "Lesotho",
        "LR" => "Liberia",
        "LY" => "Libya",
        "LI" => "Liechtenstein",
        "LT" => "Lithuania",
        "LU" => "Luxembourg",
        "MO" => "Macau SAR China",
        "MK" => "Macedonia",
        "MG" => "Madagascar",
        "MW" => "Malawi",
        "MY" => "Malaysia",
        "MV" => "Maldives",
        "ML" => "Mali",
        "MT" => "Malta",
        "MH" => "Marshall Islands",
        "MQ" => "Martinique",
        "MR" => "Mauritania",
        "MU" => "Mauritius",
        "YT" => "Mayotte",
        "FX" => "Metropolitan France",
        "MX" => "Mexico",
        "FM" => "Micronesia",
        "MI" => "Midway Islands",
        "MD" => "Moldova",
        "MC" => "Monaco",
        "MN" => "Mongolia",
        "ME" => "Montenegro",
        "MS" => "Montserrat",
        "MA" => "Morocco",
        "MZ" => "Mozambique",
        "MM" => "Myanmar [Burma]",
        "NA" => "Namibia",
        "NR" => "Nauru",
        "NP" => "Nepal",
        "NL" => "Netherlands",
        "AN" => "Netherlands Antilles",
        "NT" => "Neutral Zone",
        "NC" => "New Caledonia",
        "NZ" => "New Zealand",
        "NI" => "Nicaragua",
        "NE" => "Niger",
        "NG" => "Nigeria",
        "NU" => "Niue",
        "NF" => "Norfolk Island",
        "KP" => "North Korea",
        "VD" => "North Vietnam",
        "MP" => "Northern Mariana Islands",
        "NO" => "Norway",
        "OM" => "Oman",
        "PC" => "Pacific Islands Trust Territory",
        "PK" => "Pakistan",
        "PW" => "Palau",
        "PS" => "Palestinian Territories",
        "PA" => "Panama",
        "PZ" => "Panama Canal Zone",
        "PG" => "Papua New Guinea",
        "PY" => "Paraguay",
        "YD" => "People's Democratic Republic of Yemen",
        "PE" => "Peru",
        "PH" => "Philippines",
        "PN" => "Pitcairn Islands",
        "PL" => "Poland",
        "PT" => "Portugal",
        "PR" => "Puerto Rico",
        "QA" => "Qatar",
        "RO" => "Romania",
        "RU" => "Russia",
        "RW" => "Rwanda",
        "RE" => "Réunion",
        "BL" => "Saint Barthélemy",
        "SH" => "Saint Helena",
        "KN" => "Saint Kitts and Nevis",
        "LC" => "Saint Lucia",
        "MF" => "Saint Martin",
        "PM" => "Saint Pierre and Miquelon",
        "VC" => "Saint Vincent and the Grenadines",
        "WS" => "Samoa",
        "SM" => "San Marino",
        "SA" => "Saudi Arabia",
        "SN" => "Senegal",
        "RS" => "Serbia",
        "CS" => "Serbia and Montenegro",
        "SC" => "Seychelles",
        "SL" => "Sierra Leone",
        "SG" => "Singapore",
        "SK" => "Slovakia",
        "SI" => "Slovenia",
        "SB" => "Solomon Islands",
        "SO" => "Somalia",
        "ZA" => "South Africa",
        "GS" => "South Georgia and the South Sandwich Islands",
        "KR" => "South Korea",
        "ES" => "Spain",
        "LK" => "Sri Lanka",
        "SD" => "Sudan",
        "SR" => "Suriname",
        "SJ" => "Svalbard and Jan Mayen",
        "SZ" => "Swaziland",
        "SE" => "Sweden",
        "CH" => "Switzerland",
        "SY" => "Syria",
        "ST" => "São Tomé and Príncipe",
        "TW" => "Taiwan",
        "TJ" => "Tajikistan",
        "TZ" => "Tanzania",
        "TH" => "Thailand",
        "TL" => "Timor-Leste",
        "TG" => "Togo",
        "TK" => "Tokelau",
        "TO" => "Tonga",
        "TT" => "Trinidad and Tobago",
        "TN" => "Tunisia",
        "TR" => "Turkey",
        "TM" => "Turkmenistan",
        "TC" => "Turks and Caicos Islands",
        "TV" => "Tuvalu",
        "UM" => "U.S. Minor Outlying Islands",
        "PU" => "U.S. Miscellaneous Pacific Islands",
        "VI" => "U.S. Virgin Islands",
        "UG" => "Uganda",
        "UA" => "Ukraine",
        "SU" => "Union of Soviet Socialist Republics",
        "AE" => "United Arab Emirates",
        "GB" => "United Kingdom",
        "US" => "United States",
        "ZZ" => "Unknown or Invalid Region",
        "UY" => "Uruguay",
        "UZ" => "Uzbekistan",
        "VU" => "Vanuatu",
        "VA" => "Vatican City",
        "VE" => "Venezuela",
        "VN" => "Vietnam",
        "WK" => "Wake Island",
        "WF" => "Wallis and Futuna",
        "EH" => "Western Sahara",
        "YE" => "Yemen",
        "ZM" => "Zambia",
        "ZW" => "Zimbabwe",
        "AX" => "Åland Islands",
    );
    return $country;
}