<?php

require_once __DIR__ . '/helpers/SmsUtils.php';
require_once __DIR__ . '/interfaces/SmsGatewayInterface.php';
require_once __DIR__ . '/Skooly.php';
require_once __DIR__ . '/channels/HostpinacleGateway.php';
require_once __DIR__ . '/channels/SkoolyGateway.php';
require_once __DIR__ . '/SmsService.php';

class Skooly_init
{
    protected $ci;
    protected $configs;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('smssettings_m');

        $celcom_bind = [];
        $get_celcoms = $this->ci->smssettings_m->get_order_by_celcom();
        foreach ($get_celcoms as $get_celcom) {
            $celcom_bind[$get_celcom->field_names] = $get_celcom->field_values;
        }

        $this->configs = [
            'apiKey'   => $celcom_bind['celcom_authKey'],
            'senderID' => $celcom_bind['celcom_senderID'],
            'username' => $celcom_bind['celcom_partnerID'],
            'password' => $celcom_bind['celcom_password'],
            'endpoint' => "https://sms.biznr.co.ke/SMSApi/",
        ];

        SmsUtils::init($this->configs);
        
        Skooly::init($this->configs, $celcom_bind['celcom_gateway']);
    }
}
