<?php

class Sms_panel
{
    protected $ci;
    protected $configs;
    private $endpoint;
    private $username;
    private $password;
    private $apiKey;
    private $data;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('smssettings_m');
        $this->ci->load->model("setting_m");
        $this->ci->load->model('systemadmin_m');
        $this->ci->load->library('sms/skooly_init');
        $smsSettings = $this->ci->smssettings_m->get_order_by_celcom();
        foreach ($smsSettings as $setting) {
            $this->data[$setting->field_names] = $setting->field_values;
        }

        $this->endpoint = "https://sms.biznr.co.ke/SMSApi/";
        $this->username = $this->data['celcom_partnerID'];
        $this->password = $this->data['celcom_password'];
        $this->apiKey = $this->data['celcom_authKey'];
    }

    public function updateCredits($clientId, $credits, $action, $comment)
    {
        $url = $this->endpoint . 'reseller/' . ($action === 'add' ? 'addcredit' : 'removecredit');
        $data = [
            'userid' => $this->username,
            'password' => $this->password,
            'userloginname' => $clientId,
            'credits' => $credits,
            'transactiontype' => 'ADJUSTMENT',
            'product' => 'SMS',
            'comment' => $comment,
            'output' => 'json'
        ];

        $response = $this->makeApiRequest($url, $data);

        $actionText = ($action === 'add') ? 'credited' : 'debited';
        $superAdmin         = $this->ci->systemadmin_m->get_systemadmin(1);
        if (get_setting('notify_admin') == 1) {
            $adminNumber = get_setting('sms_bal_number');
            if ($adminNumber) {
                SmsService::adminAutomaticRecharge($superAdmin, 1, [], $adminNumber, $actionText, $credits, $clientId);
            }
        }

        if (get_setting('notify_client') == 1) {
            $userUrl = $this->endpoint . 'reseller/readuser';
            $userData = [
                'userid' => $this->username,
                'password' => $this->password,
                'userloginname' => $clientId,
                'output' => 'json'
            ];

            $userResponse = $this->makeApiRequest($userUrl, $userData);
            if (isset($userResponse['response']['userList'][0]['user']['mobileNo'])) {
                $clientMobile = $userResponse['response']['userList'][0]['user']['mobileNo'];

                SmsService::automaticRecharge($superAdmin, 1, [], $clientMobile, $actionText, $credits);
            }
        }

        return json_encode($response);
    }

    public function makeApiRequest($url, $data)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'apikey: ' . $this->apiKey
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    public function makeConcurrentApiRequests()
    {
        $multiHandle = curl_multi_init();
        $curlHandles = [];
        $responses = [];

        foreach ($this->getRequests() as $key => $request) {
            $ch = curl_init();
            $postData = http_build_query($request['data']);
            curl_setopt($ch, CURLOPT_URL, $request['url']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['apikey: ' . $this->apiKey]);

            curl_multi_add_handle($multiHandle, $ch);
            $curlHandles[$key] = $ch;
        }

        do {
            $status = curl_multi_exec($multiHandle, $active);
            if ($active) {
                curl_multi_select($multiHandle);
            }
        } while ($active && $status == CURLM_OK);

        foreach ($curlHandles as $key => $ch) {
            $response = curl_multi_getcontent($ch);
            $responses[$key] = json_decode($response, true);

            if (curl_errno($ch)) {
                error_log("cURL Error ({$key}): " . curl_error($ch));
            }

            curl_multi_remove_handle($multiHandle, $ch);
            curl_close($ch);
        }

        curl_multi_close($multiHandle);

        return $responses;
    }

    public function getRequests(){
        $requests = [
            [
                'url' => $this->endpoint . 'account/readstatus',
                'data' => [
                    'userid' => $this->username,
                    'password' => $this->password,
                    'output' => 'json',
                ],
            ],
            [
                'url' => $this->endpoint . 'reseller/readuser',
                'data' => [
                    'userid' => $this->username,
                    'password' => $this->password,
                    'output' => 'json',
                ],
            ],
            [
                'url' => $this->endpoint . 'account/readcredithistory',
                'data' => [
                    'userid' => $this->username,
                    'password' => $this->password,
                    'fromdate' => date('Y-m-d', strtotime('-30 days')),
                    'todate' => date('Y-m-d'),
                    'output' => 'json',
                ],
            ],
            [
                'url' => $this->endpoint . 'group/read',
                'data' => [
                    'userid' => $this->username,
                    'password' => $this->password,
                    'output' => 'json',
                ],
            ],
        ];

        return $requests;
    }
}
