<?php

class SkoolyGateway implements SmsGatewayInterface
{
    private $apiKey;
    private $senderID;
    private $username;
    private $password;
    private $api_endpoint = "https://isms.celcomafrica.com/api/services/sendsms/";
    private $account_balance_endpoint = "https://isms.celcomafrica.com/api/services/getbalance/";
    private $delivery_report_endpoint = 'https://isms.celcomafrica.com/api/services/getdlr/';

    public function init(array $config): void
    {   
        $this->apiKey = $config['apiKey'];
        $this->senderID = $config['senderID'];
        $this->username = $config['username'];      
    }

    public function send(string $recipient, string $message, string $name='', bool $group=false): bool
    {
        $request = "?apikey=" . urlencode($this->apiKey) .
            "&partnerID=" . urlencode($this->username) .
            "&message=" . urlencode($message) .
            "&senderID=" . $this->senderID .
            "&mobile=" . SmsUtils::formatPhone($recipient);
    
        while (!$success && $retry_count < $max_retries) {
                $response = $this->send_get_request($request);
    
            if ($response && isset($response['responses'][0]['response-description']) &&
                $response['responses'][0]['response-description'] == 'Success') {
                $success = true;
            } else {
                $retry_count++;
                sleep(1); 
            }
        }

        if ($response) {
            if (isset($response['responses'][0]['response-code']) && $response['responses'][0]['response-code'] === 200) {
                $stdat = array(
                    'usertypeID'        => '0',
                    'users'             => $name,
                    'type'              => ucfirst('automated'),
                    'message'           => $message,
                    'year'              => date('Y'),
                    'senderusertypeID'  => 1,
                    'senderID'          => $this->senderID
                );
    
                $ci = &get_instance();
                $ci->load->model("mailandsms_m");
                $ci->mailandsms_m->insert_mailandsms($stdat);
    
                $this->getBalance();
            }
        }
    
        return true;
    }

    public function sendBulk(array $recipients): bool
    {
        return true;
    }

    public function getBalance(): float
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->account_balance_endpoint);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        $request = array(
            'partnerID' => $this->username,
            'apikey' => $this->apiKey,
        );

        $data_string = json_encode($request);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

        $response = curl_exec($curl);
        $result = json_decode($response,true);

        if($result['response-code'] === 200){
            $ci     = &get_instance();
            $ci->load->model("smssettings_m");

            $array = array(            
                array(
                    'field_names' => 'celcom_balance',
                    'field_values' => $result['credit']
                )
            );

            $ci->smssettings_m->update_celcom($array);
        }        

       return $result ;
    }

    public function send_get_request($request){
        $url = $this->api_endpoint.$request;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER, false,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 600,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: PHPSESSID=6us2eiq36hb133dfju55kfbill'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
        return $result;
           
    }
}
