<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cron_m extends MY_Model {

    protected $_table_name = 'crons';
    protected $_primary_key = 'id';
    protected $_primary_filter = 'intval';
    protected $_order_by = "created_at desc";

    // --- Existing methods ---

    function get_crons($array=NULL, $signal=FALSE) {
        $query = parent::get($array, $signal);
        return $query;
    }

    public function getData($array = null){
        $this->db->select('*');
        $this->db->from('crons');

        if ( customCompute($array) ) {
            $this->db->where($array);
        }

        $this->db->order_by('created_at desc');
        $query = $this->db->get();

        return $query->result();
    }

    function insert_data($array) {
        $id = parent::insert($array);
        return $id;
    }

    public function getScheduledCrons($now, $dayOfWeek) {
        $this->db->where("next_run <=", $now);
        $this->db->where("ideal_time !=", "WEEKLY");
        if ($dayOfWeek >= 6) {
            $this->db->where("ideal_time !=", "DAILY");
        }
        return $this->db->get("crons")->result();
    }

    public function updateCron($id, $data) {
        $this->db->where("id", $id);
        $this->db->update("crons", $data);
    }

    function get_single_cron($array) {
        $query = parent::get_single($array);
        return $query;
    }

    // --- Notification Contacts Management ---

    // Get all contacts for a given cron
    public function get_cron_contacts($cron_id) {
        $query = $this->db->where('cron_id', $cron_id)->get('cron_notifications');
        return $query->result();
    }

    // Add a contact to a cron
    public function add_cron_contact($cron_id, $contact_type, $contact_value) {
        $data = [
            'cron_id' => $cron_id,
            'contact_type' => $contact_type,
            'contact_value' => $contact_value
        ];
        $this->db->insert('cron_notifications', $data);
        return $this->db->insert_id();
    }

    // Remove a contact from a cron
    public function remove_cron_contact($id) {
        $this->db->where('id', $id)->delete('cron_notifications');
    }
}