<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment_m extends MY_Model {

    protected $_table_name = 'payment';
    protected $_primary_key = 'paymentID';
    protected $_primary_filter = 'intval';
    protected $_order_by = "paymentID desc";

    public function __construct() {
        parent::__construct();
    }
    
    public function get_sum_of_payments($where)
    {
        $this->db->select_sum('paymentamount', 'total_payment');
        $this->db->where($where);
        $query = $this->db->get('payment');
        return $query->row();
    }
    
    private function studentPayment($studentID) {
        try {

            $this->db->select_sum('paymentamount');
            $this->db->from('payment');
            $this->db->where("studentID", $studentID);
            $query1 = $this->db->get();
            $sum1 = $query1->result();

            $response = $sum1[0]->paymentamount;
            
        } catch (PDOException $ex) {
            $response = "Error :" . $ex->getMessage();
        }
        return $response;
    }

    private function studentWaiver($studentID) {
        try {
            $this->db->select_sum('weaver');
            $this->db->from('weaverandfine');
            $this->db->join('invoice', 'invoice.invoiceID = weaverandfine.invoiceID');
            $this->db->where('weaverandfine.studentID', $studentID);
            $this->db->where('invoice.invoiceID !=', 0);
            $query1 = $this->db->get();
            $sum1 = $query1->result();
            $response = $sum1[0]->weaver;
        } catch (PDOException $ex) {
            $response = "Error: " . $ex->getMessage();
        }
        return $response;
    }

    private function studentFine($studentID) {
        try {
            $this->db->select_sum('fine');
            $this->db->from('weaverandfine');
            $this->db->join('invoice', 'invoice.invoiceID = weaverandfine.invoiceID');
            $this->db->where('weaverandfine.studentID', $studentID);
            $this->db->where('invoice.invoiceID !=', 0);
            $query1 = $this->db->get();
            $sum1 = $query1->result();
            $response = $sum1[0]->fine;
        } catch (PDOException $ex) {
            $response = "Error: " . $ex->getMessage();
        }
        return $response;
    }
    

    private function studentInvoice($studentID) {
        try {

            $this->db->select_sum('amount');
            $this->db->from('invoice');
            $this->db->where('deleted_at', 1);
            $this->db->where("studentID", $studentID);
            $query2 = $this->db->get();
            $sum2 = $query2->result();

            $response = $sum2[0]->amount;
        } catch (PDOException $ex) {
            $response = "Error :" . $ex->getMessage();
        }
        return $response;
    }

    public function balancee($studentID) {
        $invoiceTotal = $this->studentInvoice($studentID);
        $paymentTotal = $this->studentPayment($studentID);
        $waiverTotal = $this->studentWaiver($studentID);
        $fineTotal = $this->studentFine($studentID);
        
        $balance = $invoiceTotal - ($paymentTotal + $waiverTotal);
        return $balance;
    }
    private function getStudentFinancialData($studentID) {
        try {
            // Query for all financial data in one go
            $this->db->select(
                '(SELECT SUM(amount) FROM invoice WHERE studentID = ' . $this->db->escape($studentID) . ' AND deleted_at = 1) AS invoiceTotal, ' .
                '(SELECT SUM(paymentamount) FROM payment WHERE studentID = ' . $this->db->escape($studentID) . ') AS paymentTotal, ' .
                '(SELECT SUM(weaver) FROM weaverandfine wf JOIN invoice i ON i.invoiceID = wf.invoiceID WHERE wf.studentID = ' . $this->db->escape($studentID) . ' AND i.invoiceID != 0) AS waiverTotal, ' .
                '(SELECT SUM(fine) FROM weaverandfine wf JOIN invoice i ON i.invoiceID = wf.invoiceID WHERE wf.studentID = ' . $this->db->escape($studentID) . ' AND i.invoiceID != 0) AS fineTotal'
            );
            
            // Run the query
            $query = $this->db->get();
            $result = $query->row();
    
            // Handle NULL cases to avoid errors
            $invoiceTotal = isset($result->invoiceTotal) ? $result->invoiceTotal : 0;
            $paymentTotal = isset($result->paymentTotal) ? $result->paymentTotal : 0;
            $waiverTotal = isset($result->waiverTotal) ? $result->waiverTotal : 0;
            $fineTotal = isset($result->fineTotal) ? $result->fineTotal : 0;
    
            return [
                'invoiceTotal' => $invoiceTotal,
                'paymentTotal' => $paymentTotal,
                'waiverTotal' => $waiverTotal,
                'fineTotal' => $fineTotal,
            ];
    
        } catch (PDOException $ex) {
            return "Error: " . $ex->getMessage();
        }
    }
    
    public function balance($studentID) {
        // Get all financial data for the student
        $financialData = $this->getStudentFinancialData($studentID);
        
        
        // Calculate balance: invoiceTotal - (paymentTotal + waiverTotal) + fineTotal
        $balance = $financialData['invoiceTotal'] - ($financialData['paymentTotal'] + $financialData['waiverTotal']);
        // - $financialData['fineTotal']
    
        return $balance;
    }

    public function order_payment($order) {
        parent::order($order);
    }

    public function get_payment_with_studentrelation_by_studentID($studentID, $schoolyearID) {
        $this->db->select('payment.*, invoice.invoiceID, invoice.feetype, invoice.amount, studentrelation.*');
        $this->db->from('payment');
        $this->db->join('studentrelation', 'studentrelation.srstudentID = payment.studentID AND studentrelation.srschoolyearID = payment.schoolyearID', 'LEFT');
        $this->db->join('invoice', 'invoice.invoiceID = payment.invoiceID', 'LEFT');

        if (is_array($studentID)) {
            $this->db->where_in('payment.studentID', $studentID);
        } else {
            $this->db->where(array('payment.studentID' => $studentID));
        }

        $this->db->where(array('payment.schoolyearID' => $schoolyearID));
        $this->db->order_by($this->_order_by);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_payment_with_studentrelation($schoolyearID) {
        $this->db->select('payment.*, invoice.invoiceID, invoice.feetype, invoice.amount, studentrelation.*');
        $this->db->from('payment');
        $this->db->join('studentrelation', 'studentrelation.srstudentID = payment.studentID AND studentrelation.srschoolyearID = payment.schoolyearID', 'LEFT');
        $this->db->join('invoice', 'invoice.invoiceID = payment.invoiceID', 'LEFT');
        $this->db->where(array('payment.schoolyearID' => $schoolyearID));
        $this->db->order_by($this->_order_by);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_payment_with_studentrelation_by_studentID_and_schoolyearID($studentID, $schoolyearID) {
        $this->db->select('payment.*, invoice.invoiceID, invoice.feetype, invoice.feetypeID, invoice.amount, weaverandfine.weaver, weaverandfine.fine');
        $this->db->from('payment');
        $this->db->join('invoice', 'invoice.invoiceID = payment.invoiceID', 'LEFT');
        $this->db->join('weaverandfine', 'payment.paymentID = weaverandfine.paymentID', 'LEFT');
        $this->db->where(array('payment.studentID' => $studentID));
        $this->db->where(array('payment.schoolyearID' => $schoolyearID));
        $this->db->where(array('payment.paymentamount !=' => ''));
        $this->db->limit(10);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_payment_by_sum($invoiceID) {
        $this->db->select_sum('paymentamount');
        $this->db->where(array('invoiceID' => $invoiceID));
        $query = $this->db->get($this->_table_name);
        return $query->row();
    }

    public function get_payment_by_sum_for_edit($invoiceID, $paymentID) {
        $this->db->select_sum('paymentamount');
        $this->db->where(array('invoiceID' => $invoiceID, 'paymentID !=' => $paymentID));
        $query = $this->db->get($this->_table_name);
        return $query->row();
    }

    public function get_payment($array = NULL, $signal = FALSE) {
        $query = parent::get($array, $signal);
        return $query;
    }

    public function get_order_by_payment($array = NULL) {
        $query = parent::get_order_by($array);
        return $query;
    }

    public function get_single_payment($array = NULL) {
        $query = parent::get_single($array);
        return $query;
    }

    public function get_where_in_payment($array, $key = NULL) {
        $query = parent::get_where_in($array, $key);
        return $query;
    }

    public function insert_payment($array) {
        $error = parent::insert($array);
        return TRUE;
    }

    public function insert_batch_payment($array) {
        $id = parent::insert_batch($array);
        return $id;
    }

    public function update_payment($data, $id = NULL) {
        parent::update($data, $id);
        return $id;
    }

    public function delete_payment($id) {
        parent::delete($id);
    }

    public function delete_batch_payment($array) {
        parent::delete_batch($array);
    }

    public function get_all_payment_for_report($queryArray) {
        $this->db->select('*');
        $this->db->from('payment');
        $this->db->where('payment.schoolyearID', $queryArray['schoolyearID']);

        if ((isset($queryArray['classesID']) && $queryArray['classesID'] != 0) || (isset($queryArray['sectionID']) && $queryArray['sectionID'] != 0) || (isset($queryArray['studentID']) && $queryArray['studentID'] != 0)) {

            $this->db->join('globalpayment', 'payment.globalpaymentID = globalpayment.globalpaymentID', 'LEFT');

            if (isset($queryArray['classesID']) && $queryArray['classesID'] != 0) {
                $this->db->where('globalpayment.classesID', $queryArray['classesID']);
            }

            if (isset($queryArray['sectionID']) && $queryArray['sectionID'] != 0) {
                $this->db->where('globalpayment.sectionID', $queryArray['sectionID']);
            }

            if (isset($queryArray['studentID']) && $queryArray['studentID'] != 0) {
                $this->db->where('globalpayment.studentID', $queryArray['studentID']);
            }
        }

        if (isset($queryArray['feetypeID']) && $queryArray['feetypeID'] != 0) {
            $this->db->join('invoice', 'payment.invoiceID = invoice.invoiceID', 'LEFT');
            $this->db->where('invoice.feetypeID', $queryArray['feetypeID']);
        }

       if (!empty($queryArray['fromdate']) && !empty($queryArray['todate'])) {
            $fromdate = date('Y-m-d', strtotime($queryArray['fromdate']));
            $todate = date('Y-m-d', strtotime($queryArray['todate']));
        
            if ($fromdate && $todate) {
                $this->db->where('paymentdate >=', $fromdate);
                $this->db->where('paymentdate <=', $todate);
            }
        }

        $query = $this->db->get();
        return $query->result();
    }

    public function get_payments($array) {
        $this->db->select('*');
        $this->db->from($this->_table_name);
        $this->db->join('invoice', 'payment.invoiceID = invoice.invoiceID');
        $this->db->where('payment.paymentdate >=', $array['fromdate']);
        $this->db->where('payment.paymentdate <=', $array['todate']);
        $this->db->where('payment.schoolyearID', $array['schoolyearID']);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_fee_types($array) {
        $this->db->select('payment.*,invoice.feetypeID,invoice.feetype,invoice.classesID');
        $this->db->from('payment');
        $this->db->join('invoice', 'invoice.invoiceID = payment.invoiceID', 'LEFT');
        $this->db->where('payment.schoolyearID', $array['schoolyearID']);
        $this->db->where('invoice.classesID', $array['classesID']);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_globalpayments($id) {
        $this->db->select('*');
        $this->db->from($this->_table_name);
        $this->db->join('invoice', 'payment.invoiceID = invoice.invoiceID');
        $this->db->join('globalpayment', 'payment.globalpaymentID = globalpayment.globalpaymentID');
        $this->db->where('payment.globalpaymentID', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_singlepayments($id) {
        $schoolyearID = $this->session->userdata('defaultschoolyearID');
        $this->db->select('*');
        $this->db->from($this->_table_name);
        $this->db->where('invoiceID', $id);
        $this->db->where('schoolyearID', $schoolyearID);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_payment_sum($clmn, $array) {
        $query = parent::get_sum($clmn, $array);
        return $query;
    }

    public function get_where_payment_sum($clmn, $wherein, $arrays, $groupID = NULL) {
        $query = parent::get_where_sum($clmn, $wherein, $arrays, $groupID);
        return $query;
    }

    public function get_single_payment_by_globalpaymentID($globalpaymentID) {
        $this->db->select('payment.*,weaverandfine.weaver,weaverandfine.fine,invoice.feetypeID,invoice.paidstatus');
        $this->db->from('globalpayment');
        $this->db->join('payment', 'globalpayment.globalpaymentID=payment.globalpaymentID');
        $this->db->join('invoice', 'invoice.invoiceID=payment.invoiceID');
        $this->db->join('weaverandfine', 'payment.paymentID=weaverandfine.paymentID', 'LEFT');
        $this->db->where('globalpayment.globalpaymentID', $globalpaymentID);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_payment_with_fine_schoolyear($array) {
        $this->db->select('payment.*,weaverandfine.fine');
        $this->db->from($this->_table_name);
        $this->db->join('weaverandfine', 'payment.paymentID = weaverandfine.paymentID', 'LEFT');
        if (isset($array['fromdate']) && isset($array['todate'])) {
            $this->db->where('payment.paymentdate >=', $array['fromdate']);
            $this->db->where('payment.paymentdate <=', $array['todate']);
        }
        if (isset($array['schoolyearID'])) {
            $this->db->where('payment.schoolyearID', $array['schoolyearID']);
        }
        $query = $this->db->get();
        return $query->result();
    }

}
