<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports_m extends CI_Model {

    function __construct() {
		parent::__construct();
		$this->load->helper('url');
        $this->load->model('payment_m');
		$this->load->database();
	}
	
	public function getSalesData($schoolyearID) {    
        
    // Build the SQL query to retrieve the total sales for each month
    $query = $this->db->query("SELECT LEFT(calendar.month_name, 3) AS month, COALESCE(SUM(psp.productsalepaidamount), 0) AS total_sales
    FROM (
        SELECT 'January' AS month_name, 1 AS month_number
        UNION SELECT 'February', 2
        UNION SELECT 'March', 3
        UNION SELECT 'April', 4
        UNION SELECT 'May', 5
        UNION SELECT 'June', 6
        UNION SELECT 'July', 7
        UNION SELECT 'August', 8
        UNION SELECT 'September', 9
        UNION SELECT 'October', 10
        UNION SELECT 'November', 11
        UNION SELECT 'December', 12
    ) calendar
    LEFT JOIN productsalepaid psp ON calendar.month_number = MONTH(psp.productsalepaiddate) AND psp.schoolyearID = $schoolyearID
    GROUP BY calendar.month_name
    ORDER BY calendar.month_number
    ");

    
    $months = [];
    $total_sales = [];


    if ($query) {
       
        foreach ($query->result() as $row) {
            array_push($months, $row->month);
            array_push($total_sales, (int) $row->total_sales);
        }
    }
    
    return [
        'months' => $months,
        'total_sales' => $total_sales
    ];

}


    // public function getSalesData($schoolyearID) {     
      
    //     // Build the SQL query to retrieve the total sales for each month
    //     $query = $this->db->query("SELECT LEFT(calendar.month_name, 3) AS month, COALESCE(SUM(pi.productsaleunitprice * pi.productsalequantity), 0) AS total_sales
    //     FROM (
    //         SELECT 'January' AS month_name, 1 AS month_number
    //         UNION SELECT 'February', 2
    //         UNION SELECT 'March', 3
    //         UNION SELECT 'April', 4
    //         UNION SELECT 'May', 5
    //         UNION SELECT 'June', 6
    //         UNION SELECT 'July', 7
    //         UNION SELECT 'August', 8
    //         UNION SELECT 'September', 9
    //         UNION SELECT 'October', 10
    //         UNION SELECT 'November', 11
    //         UNION SELECT 'December', 12
    //     ) calendar
    //     LEFT JOIN productsale p ON calendar.month_number = MONTH(p.create_date) AND p.schoolyearID = $schoolyearID AND p.productsalestatus = 3
    //     LEFT JOIN productsaleitem pi ON pi.productsaleID = p.productsaleID
    //     GROUP BY calendar.month_name
    //     ORDER BY calendar.month_number
    //     ");

    //     // Create empty arrays for the months and total sales
    //     $months = [];
    //     $total_sales = [];

    //     // Loop through the response and push the data to the arrays
    //     foreach ($query->result() as $row) {
    //     array_push($months, $row->month);
    //     array_push($total_sales, (int) $row->total_sales);
    //     }

    //     // Return the result array
    //     return array([
    //     'months' => $months,
    //     'total_sales' => $total_sales
    //     ]);

    // }

    public function getFinesData($schoolyearID) {
    
       // Build the SQL query to retrieve the total fines for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(wf.fine), 0) AS total_fines
        FROM (
            SELECT 'January' AS month_name, 1 AS month_number
            UNION SELECT 'February', 2
            UNION SELECT 'March', 3
            UNION SELECT 'April', 4
            UNION SELECT 'May', 5
            UNION SELECT 'June', 6
            UNION SELECT 'July', 7
            UNION SELECT 'August', 8
            UNION SELECT 'September', 9
            UNION SELECT 'October', 10
            UNION SELECT 'November', 11
            UNION SELECT 'December', 12
        ) calendar
        LEFT JOIN (
            SELECT wf.weaverandfineID, wf.fine, i.create_date
            FROM weaverandfine wf
            INNER JOIN invoice i ON wf.invoiceID = i.invoiceID
            WHERE i.schoolyearID = $schoolyearID
        ) wf ON calendar.month_number = MONTH(wf.create_date)
        GROUP BY calendar.month_name
        ORDER BY calendar.month_number
        ");
        $total_fines = [];

        

        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                array_push($total_fines, (int) $row->total_fines);
            }
        }
        
        return $total_fines;

    }
    
    public function getTotalFeesAndFinesData($schoolyearID) {
        // Build the SQL query to retrieve the total fees collected and fines for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(p.paymentamount), 0) AS total_fees, COALESCE(SUM(wf.fine), 0) AS total_fines
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            LEFT JOIN payment p ON calendar.month_number = MONTH(p.paymentdate) AND p.schoolyearID = $schoolyearID
            LEFT JOIN (
                SELECT wf.weaverandfineID, wf.fine, wf.paymentID
                FROM weaverandfine wf
                WHERE EXISTS (SELECT 1 FROM payment WHERE payment.paymentID = wf.paymentID AND payment.schoolyearID = $schoolyearID)
            ) wf ON p.paymentID = wf.paymentID AND calendar.month_number = MONTH(p.paymentdate)
            GROUP BY calendar.month_name
            ORDER BY calendar.month_number");
    
        // Create empty arrays for the months and total fees collected
        $months = [];
        $totals = [];

        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                $month = $row->month;
                $total = (int) $row->total_fees + (int) $row->total_fines;
                array_push($months, $month);
                array_push($totals, $total);
            }
        }
        
        return $totals;
    }


    
//     public function getTotalFeesAndFinesData($schoolyearID) {
//     // Build the SQL query to retrieve the total fees collected and fines for each month
//     $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(p.paymentamount), 0) AS total_fees, COALESCE(SUM(wf.fine), 0) AS total_fines
//         FROM (
//             SELECT 'January' AS month_name, 1 AS month_number
//             UNION SELECT 'February', 2
//             UNION SELECT 'March', 3
//             UNION SELECT 'April', 4
//             UNION SELECT 'May', 5
//             UNION SELECT 'June', 6
//             UNION SELECT 'July', 7
//             UNION SELECT 'August', 8
//             UNION SELECT 'September', 9
//             UNION SELECT 'October', 10
//             UNION SELECT 'November', 11
//             UNION SELECT 'December', 12
//         ) calendar
//         LEFT JOIN payment p ON calendar.month_number = MONTH(p.paymentdate) AND p.schoolyearID = $schoolyearID
//         LEFT JOIN (
//             SELECT wf.weaverandfineID, wf.fine, p.paymentdate
//             FROM weaverandfine wf
//             INNER JOIN invoice i ON wf.invoiceID = i.invoiceID
//             INNER JOIN payment p ON i.invoiceID = p.invoiceID
//             WHERE i.schoolyearID = $schoolyearID
//         ) wf ON calendar.month_number = MONTH(wf.paymentdate) AND p.schoolyearID = $schoolyearID
//         GROUP BY calendar.month_name
//         ORDER BY calendar.month_number");

//     // Create empty arrays for the months and total fees collected
//     $months = [];
//     $totals = [];

//     // Loop through the response and push the data to the arrays
//     foreach ($query->result() as $row) {
//         $month = $row->month;
//         $total = (int) $row->total_fees + (int) $row->total_fines;
//         array_push($months, $month);
//         array_push($totals, $total);
//     }

//     // Return the result array
//     return $totals;
// }


//     public function getTotalFeesAndFinesData($schoolyearID) {
//         // Build the SQL query to retrieve the total fees collected and fines for each month
//         $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(p.paymentamount), 0) AS total_fees, COALESCE(SUM(wf.fine), 0) AS total_fines
//             FROM (
//                 SELECT 'January' AS month_name, 1 AS month_number
//                 UNION SELECT 'February', 2
//                 UNION SELECT 'March', 3
//                 UNION SELECT 'April', 4
//                 UNION SELECT 'May', 5
//                 UNION SELECT 'June', 6
//                 UNION SELECT 'July', 7
//                 UNION SELECT 'August', 8
//                 UNION SELECT 'September', 9
//                 UNION SELECT 'October', 10
//                 UNION SELECT 'November', 11
//                 UNION SELECT 'December', 12
//             ) calendar
//             LEFT JOIN payment p ON calendar.month_number = MONTH(p.paymentdate) AND p.schoolyearID = $schoolyearID
//             LEFT JOIN (
//                 SELECT wf.weaverandfineID, wf.fine
//                 FROM weaverandfine wf
//                 INNER JOIN invoice i ON wf.invoiceID = i.invoiceID
//                 WHERE i.schoolyearID = $schoolyearID
//             ) wf ON calendar.month_number = MONTH(wf.create_date)
//             WHERE calendar.month_number = MONTH(NOW())
//             GROUP BY calendar.month_name
//             ORDER BY calendar.month_number");
    
//         // Create empty arrays for the months and total fees collected
//         $months = [];
//         $totals = [];
    
//         // Loop through the response and push the data to the arrays
//         foreach ($query->result() as $row) {
//             $month = $row->month;
//             $total = (int) $row->total_fees + (int) $row->total_fines;
//             array_push($months, $month);
//             array_push($totals, $total);
//         }
    
//         // Create the result array
//         // $data = [
//         //     'months' => $months,
//         //     'totals' => $totals
//         // ];
    
//         // Return the result array
//         return $totals;
//     }
    public function getFeesData($schoolyearID) {
    // Build the SQL query to retrieve the total purchases for each month
    $query = $this->db->query("
        SELECT calendar.month_name AS month, COALESCE(SUM(pp.paymentamount), 0) AS total_fees
        FROM (
            SELECT 'January' AS month_name, 1 AS month_number
            UNION SELECT 'February', 2
            UNION SELECT 'March', 3
            UNION SELECT 'April', 4
            UNION SELECT 'May', 5
            UNION SELECT 'June', 6
            UNION SELECT 'July', 7
            UNION SELECT 'August', 8
            UNION SELECT 'September', 9
            UNION SELECT 'October', 10
            UNION SELECT 'November', 11
            UNION SELECT 'December', 12
        ) calendar
        LEFT JOIN payment pp ON MONTH(pp.paymentdate) = calendar.month_number AND YEAR(pp.paymentdate) = YEAR(NOW()) AND pp.schoolyearID = $schoolyearID 
        GROUP BY calendar.month_name
        ORDER BY calendar.month_number
    ");

    $total_fees = [];

    // Loop through the response and push the data to the arrays
    foreach ($query->result() as $row) {
        array_push($total_fees, (int) $row->total_fees);
    }

    return $total_fees;
}
    
    
    public function getFeesDataa($schoolyearID) {
    
        // Build the SQL query to retrieve the total fees collected for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(p.paymentamount), 0) AS total_fees
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            LEFT JOIN payment p ON calendar.month_number = MONTH(p.paymentdate) AND p.schoolyearID = $schoolyearID
            GROUP BY calendar.month_name
            ORDER BY calendar.month_number");
    
        // Create empty arrays for the months and total fees collected
        $total_fees = [];
    
        // Loop through the response and push the data to the arrays
        foreach ($query->result() as $row) {
            array_push($total_fees, (int) $row->total_fees);
        }
        
        // Return the result array
        return $total_fees;
    }
    
    // public function getTotalIncomeDatas($schoolyearID) {
    //     // Build the SQL query to retrieve the total income and lunch sold for each month
    //     $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(COALESCE(i.amount, 0) + COALESCE(l.amount, 0)), 0) AS total_income
    //             FROM (
    //                 SELECT 'January' AS month_name, 1 AS month_number
    //                 UNION SELECT 'February', 2
    //                 UNION SELECT 'March', 3
    //                 UNION SELECT 'April', 4
    //                 UNION SELECT 'May', 5
    //                 UNION SELECT 'June', 6
    //                 UNION SELECT 'July', 7
    //                 UNION SELECT 'August', 8
    //                 UNION SELECT 'September', 9
    //                 UNION SELECT 'October', 10
    //                 UNION SELECT 'November', 11
    //                 UNION SELECT 'December', 12
    //             ) calendar
    //             LEFT JOIN income i ON calendar.month_number = MONTH(i.create_date) AND i.schoolyearID = $schoolyearID
    //             LEFT JOIN (
    //                 SELECT DATE_FORMAT(date, '%M') AS month_name, SUM(amount) AS amount
    //                 FROM lunchlogs
    //                 WHERE schoolyearID = $schoolyearID
    //                 GROUP BY month_name
    //             ) l ON calendar.month_name = l.month_name
    //             GROUP BY calendar.month_name
    //             ORDER BY calendar.month_number");
    
    //     // Create empty array for the total income
    //     $total_income = [];
    
    //     // Loop through the response and push the total income for each month to the array
    //     foreach ($query->result() as $row) {
    //         array_push($total_income, (int) $row->total_income);
    //     }
    
    //     // Return the result array
    //     return $total_income;
    // }

    public function getTotalIncomeDatas($schoolyearID) {
        // Build the SQL query to retrieve the total income for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(COALESCE(i.amount, 0)), 0) AS total_income
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            LEFT JOIN income i ON calendar.month_number = MONTH(i.create_date) AND i.schoolyearID = $schoolyearID
            GROUP BY calendar.month_name
            ORDER BY calendar.month_number");
    
        // Create an empty array for the total income
        $total_income = [];
    

        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                array_push($total_income, (int) $row->total_income);
            }
        }
        
        // Return the result array
        return $total_income;
    }
    
    
    // public function getTotalIncomeDatas($schoolyearID) {
    //     // Build the SQL query to retrieve the total income and lunch sold for each month
    //     $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(i.amount + IFNULL(l.amount, 0)), 0) AS total_income
    //             FROM (
    //                 SELECT 'January' AS month_name, 1 AS month_number
    //                 UNION SELECT 'February', 2
    //                 UNION SELECT 'March', 3
    //                 UNION SELECT 'April', 4
    //                 UNION SELECT 'May', 5
    //                 UNION SELECT 'June', 6
    //                 UNION SELECT 'July', 7
    //                 UNION SELECT 'August', 8
    //                 UNION SELECT 'September', 9
    //                 UNION SELECT 'October', 10
    //                 UNION SELECT 'November', 11
    //                 UNION SELECT 'December', 12
    //             ) calendar
    //             LEFT JOIN income i ON calendar.month_number = MONTH(i.create_date) AND i.schoolyearID = $schoolyearID
    //             LEFT JOIN (
    //                 SELECT DATE_FORMAT(date, '%M') AS month_name, SUM(amount) AS amount
    //                 FROM lunchlogs
    //                 GROUP BY month_name
    //             ) l ON calendar.month_name = l.month_name
    //             GROUP BY calendar.month_name
    //             ORDER BY calendar.month_number");
    
    //     // Create empty array for the total income
    //     $total_income = [];
    
    //     // Loop through the response and push the total income for each month to the array
    //     foreach ($query->result() as $row) {
    //         array_push($total_income, (int) $row->total_income);
    //     }
    
    //     // Return the result array
    //     return $total_income;
    // }
    
    
    public function getTotalIncomeData($schoolyearID) {
        
        // Build the SQL query to retrieve the total income for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(i.amount), 0) AS total_income
                FROM (
                    SELECT 'January' AS month_name, 1 AS month_number
                    UNION SELECT 'February', 2
                    UNION SELECT 'March', 3
                    UNION SELECT 'April', 4
                    UNION SELECT 'May', 5
                    UNION SELECT 'June', 6
                    UNION SELECT 'July', 7
                    UNION SELECT 'August', 8
                    UNION SELECT 'September', 9
                    UNION SELECT 'October', 10
                    UNION SELECT 'November', 11
                    UNION SELECT 'December', 12
                ) calendar
                LEFT JOIN income i ON calendar.month_number = MONTH(i.create_date) AND i.schoolyearID = $schoolyearID
                GROUP BY calendar.month_name
                ORDER BY calendar.month_number
                ");
                
        // Create empty arrays for the months and total income
        $total_income = [];
    
        // Loop through the response and push the data to the arrays
        foreach ($query->result() as $row) {
            array_push($total_income, (int) $row->total_income);
        }
        // Return the result array
        return $total_income;
    }

    // public function getPurchasesData($schoolyearID) {  
      
        
    //     // Build the SQL query to retrieve the total sales for each month
    //     $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(pi.productpurchaseunitprice * pi.productpurchasequantity), 0) AS total_purchases
    //     FROM (
    //         SELECT 'January' AS month_name, 1 AS month_number
    //         UNION SELECT 'February', 2
    //         UNION SELECT 'March', 3
    //         UNION SELECT 'April', 4
    //         UNION SELECT 'May', 5
    //         UNION SELECT 'June', 6
    //         UNION SELECT 'July', 7
    //         UNION SELECT 'August', 8
    //         UNION SELECT 'September', 9
    //         UNION SELECT 'October', 10
    //         UNION SELECT 'November', 11
    //         UNION SELECT 'December', 12
    //     ) calendar
    //     LEFT JOIN productpurchase p ON calendar.month_number = MONTH(p.create_date) AND p.schoolyearID = $schoolyearID 
    //     -- AND p.productpurchasestatus = 3
    //     LEFT JOIN productpurchaseitem pi ON pi.productpurchaseID = p.productpurchaseID
    //     GROUP BY calendar.month_name
    //     ORDER BY calendar.month_number
    //     ");

    //     $total_purchases = [];

    //     // Loop through the response and push the data to the arrays
    //     foreach ($query->result() as $row) {
    //         array_push($total_purchases, (int) $row->total_purchases);
    //     }
        
    //     return $total_purchases;
    // }
    
    public function getPurchasesData($schoolyearID) {
        // Build the SQL query to retrieve the total purchases for each month
        $query = $this->db->query("
            SELECT calendar.month_name AS month, COALESCE(SUM(pp.productpurchasepaidamount), 0) AS total_purchases
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            LEFT JOIN productpurchasepaid pp ON MONTH(pp.productpurchasepaiddate) = calendar.month_number AND YEAR(pp.productpurchasepaiddate) = YEAR(NOW()) AND pp.schoolyearID = $schoolyearID 
            GROUP BY calendar.month_name
            ORDER BY calendar.month_number
        ");
    
        $total_purchases = [];
    
        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                array_push($total_purchases, (int) $row->total_purchases);
            }
        }
        
        return $total_purchases;
    }


    public function getSalaryData($schoolyearID) {
        
        // Build the SQL query to retrieve the total salary for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(mp.payment_amount), 0) AS total_salary
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            LEFT JOIN make_payment mp ON calendar.month_number = MONTH(mp.create_date) AND mp.schoolyearID = $schoolyearID
            GROUP BY calendar.month_name
            ORDER BY calendar.month_number
        ");

        $total_salary = [];
    

        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                array_push($total_salary, (int) $row->total_salary);
            }
        }
        
        // Return the result array
        return $total_salary;
    }

    public function getTotalExpenseData($schoolyearID) {
        
        // Build the SQL query to retrieve the total income for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, COALESCE(SUM(i.amount), 0) AS total_income
                FROM (
                    SELECT 'January' AS month_name, 1 AS month_number
                    UNION SELECT 'February', 2
                    UNION SELECT 'March', 3
                    UNION SELECT 'April', 4
                    UNION SELECT 'May', 5
                    UNION SELECT 'June', 6
                    UNION SELECT 'July', 7
                    UNION SELECT 'August', 8
                    UNION SELECT 'September', 9
                    UNION SELECT 'October', 10
                    UNION SELECT 'November', 11
                    UNION SELECT 'December', 12
                ) calendar
                LEFT JOIN expense i ON calendar.month_number = MONTH(i.date) AND i.schoolyearID = $schoolyearID
                GROUP BY calendar.month_name
                ORDER BY calendar.month_number
                ");
                
        // Create empty arrays for the months and total income
        $total_income = [];
    
        if ($query) {
            // Loop through the response and push the data to the arrays
            foreach ($query->result() as $row) {
                array_push($total_income, (int) $row->total_income);
            }
        }
        
        // Return the result array
        return $total_income;
    }
    // public function get_total_fees_by_class($schoolyearID) {

    //     // get all classes
    //     $classes = $this->db->get('classes')->result_array();        
    //     $class_names = [];
    //     $total_fees = [];
    
    //     foreach ($classes as $class) {
    //         $class_id = $class['classesID'];
    //         $this->db->select('SUM(p.paymentamount) AS total_fees');
    //         $this->db->from('invoice AS i');
    //         $this->db->join('payment AS p', 'p.invoiceID = i.invoiceID', 'left');
    //         $this->db->where('i.classesID', $class_id);
    //         $this->db->where('i.schoolyearID', $schoolyearID);
    //         $this->db->where('i.deleted_at', 1); // Assuming 0 indicates the record is not deleted
    //         $result = $this->db->get()->row_array();
        
    //         // add class data to result arrays
    //         $class_names[] = $class['classes'];
    //         $total_fees[] = isset($result['total_fees']) ? (float) $result['total_fees'] : 0.0;
    //     }

    //     $data['class_names'] = $class_names;
    //     $data['total_fees'] = $total_fees;
    
    //     return $data;
    // } 
    
    public function get_total_fees_by_class($schoolyearID) {

        // get all classes
        $classes = $this->db->get('classes')->result_array();        
        $class_names = [];
        $total_fees = [];
    
        foreach ($classes as $class) {
            $class_id = $class['classesID'];
            $this->db->select('SUM(IFNULL(p.paymentamount, 0) + IFNULL(w.fine, 0)) AS total_fees');
            $this->db->from('invoice AS i');
            $this->db->join('payment AS p', 'p.invoiceID = i.invoiceID', 'left');
            $this->db->join('weaverandfine AS w', 'w.paymentID = p.paymentID', 'left');
            $this->db->where('i.classesID', $class_id);
            $this->db->where('i.schoolyearID', $schoolyearID);
            $this->db->where('i.deleted_at', 1); // Assuming 0 indicates the record is not deleted
            $result = $this->db->get()->row_array();
        
            // add class data to result arrays
            $class_names[] = $class['classes'];
            $total_fees[] = isset($result['total_fees']) ? (float) $result['total_fees'] : 0.0;
        }        
        
    
        $data['class_names'] = $class_names;
        $data['total_fees'] = $total_fees;
    
        return $data;
    } 
    
    public function get_total_fees_by_class_due($schoolyearID) {
        $classes = $this->db->get('classes')->result_array();
        $class_names = [];
        $total_fees = [];
        
        foreach ($classes as $class) {
            $class_id = $class['classesID'];
        
            $this->db->select('(i.amount - COALESCE((SELECT SUM(paymentamount) FROM payment WHERE invoiceID = i.invoiceID), 0)) AS total_fees');
            $this->db->from('invoice AS i');
            $this->db->where('i.classesID', $class_id);
            $this->db->where('i.schoolyearID', $schoolyearID);
            $this->db->where('i.paidstatus !=', 2); 
            $query = $this->db->get();
            $results = $query->result_array();
            $total_fees_due = 0;
        
            foreach ($results as $result) {
                $total_fees_due += (int)$result['total_fees'];
            }
        
            $class_names[] = $class['classes'];
            $total_fees[] = $total_fees_due;
        }
        $data['class_names'] = $class_names;
        $data['total_fees_due'] = $total_fees;
        
        return $data;
    }


    // public function get_total_fees_by_class_due($schoolyearID) {

    //     // get all classes
    //     $classes = $this->db->get('classes')->result_array();        
    //     $class_names = [];
    //     $total_fees = [];
    
    //     foreach ($classes as $class) {
    //         $class_id = $class['classesID'];
    //         $this->db->select('SUM(amount) AS total_fees');
    //         $this->db->from('invoice');
    //         $this->db->where_in('paidstatus', [0,1]);
    //         // $this->db->where('paidstatus >=', 1);
    //         $this->db->where('classesID', $class_id);
    //         $this->db->where('schoolyearID', $schoolyearID);
    //         $result = $this->db->get()->row_array();

    
    //         // add class data to result arrays
    //         $class_names[] = $class['classes'];
    //         $total_fees[] = isset($result['total_fees']) ? (int) $result['total_fees'] : 0;           
    //     }
    
    //     // $data['class_names'] = $class_names;
    //     $data['total_fees_due'] = $total_fees;
    
    //     return $data;
    // } 
    
    
    public function feesByClass($schoolyearID) {
        
        // Build the SQL query to retrieve the total fees collected by class for each month
        $query = $this->db->query("SELECT calendar.month_name AS month, classes.classes AS class, COALESCE(SUM(p.paymentamount), 0) AS total_fees
            FROM (
                SELECT 'January' AS month_name, 1 AS month_number
                UNION SELECT 'February', 2
                UNION SELECT 'March', 3
                UNION SELECT 'April', 4
                UNION SELECT 'May', 5
                UNION SELECT 'June', 6
                UNION SELECT 'July', 7
                UNION SELECT 'August', 8
                UNION SELECT 'September', 9
                UNION SELECT 'October', 10
                UNION SELECT 'November', 11
                UNION SELECT 'December', 12
            ) calendar
            CROSS JOIN classes
            LEFT JOIN studentrelation sr ON classes.classesID = sr.srclassesID
            LEFT JOIN payment p ON sr.srstudentID = p.studentID AND calendar.month_number = MONTH(p.paymentdate) AND p.schoolyearID = $schoolyearID
            GROUP BY classes.classes, calendar.month_name
            ORDER BY classes.classes, calendar.month_number
        ");
        
        // Create an empty array to hold the results
        $fees_by_class = [];
        
        // Loop through the response and push the data to the array
        foreach ($query->result() as $row) {
            $fees_by_class[$row->class][] = [            'month' => $row->month,            'total_fees' => (int) $row->total_fees,        ];
        }
        
        // Return the result array
        return $fees_by_class;
    }

    public function fess_donut_student($schoolyearID, $studentID){

        // Retrieve the total paid fees from the payment table
        $this->db->select_sum('paymentamount');
        $this->db->where('schoolyearID', $schoolyearID);
        $this->db->where('studentID', $studentID);
        $query = $this->db->get('payment');
        $result = $query->row_array();
        $paidFees = (int) $result['paymentamount'];
       

        // Retrieve the total unpaid fees from the invoice table
        $this->db->select_sum('amount');
        $this->db->where('schoolyearID', $schoolyearID);
        $this->db->where('studentID', $studentID);
        $query = $this->db->get('invoice');
        $result = $query->row_array(); 
        $unpaidFees = (int) $result['amount'] - $paidFees;

        // Retrieve the total waived fees from the waiverandfine table
        $this->db->select_sum('weaver');
        $this->db->where('schoolyearID', $schoolyearID);
        $this->db->where('studentID', $studentID);
        $query = $this->db->get('weaverandfine');
        $result = $query->row_array();
        $waivedFees = (int) $result['weaver'];

        // Create an array of data for the donut chart
        $data = array(
        array(
            "name" => "Paid",
            "y" => $paidFees,
            "color" => '#1996bf'
        ),
        array(
            "name" => "Due",
            "y" => $unpaidFees,
            "color" => '#5C5C61'
        ),
        array(
            "name" => "Waived Fees",
            "y" => $waivedFees,
            "color" => '#FF8A65'
        )
        );
        // // Convert the data array to JSON format for use in Highcharts
        // $dataJSON = json_encode($data);

        return $data;

    }
    public function fess_donut($schoolyearID){
        
        // Retrieve the total waived fees from the waiverandfine table
        $this->db->select_sum('weaver');
        $this->db->where('schoolyearID', $schoolyearID);
        $query = $this->db->get('weaverandfine');
        $result = $query->row_array();
        $waivedFees = (int) $result['weaver'];
        
        // Retrieve the total waived fees from the waiverandfine table
        $this->db->select_sum('fine');
        $this->db->where('schoolyearID', $schoolyearID);
        $query = $this->db->get('weaverandfine');
        $result = $query->row_array();
        $finedFees = (int) $result['fine'];
        
        // Retrieve the total paid fees from the payment table
        $this->db->select_sum('paymentamount');
        $this->db->where('schoolyearID', $schoolyearID);
        $query = $this->db->get('payment');
        $result = $query->row_array();
        $paidFees = (int) $result['paymentamount'];
       

        // Retrieve the total unpaid fees from the invoice table
        $this->db->select_sum('amount');
        $this->db->where('schoolyearID', $schoolyearID);
        $this->db->where('deleted_at', 1);
        $query = $this->db->get('invoice');
        $result = $query->row_array(); 
        $unpaidFees = (int) $result['amount'] - $paidFees;
        
        if($waivedFees>0){
            $unpaidFees -= $waivedFees;
        }

        if($finedFees>0){
            $paidFees += $finedFees;
        }        

        // Create an array of data for the donut chart
        $data = array(
        array(
            "name" => "Paid",
            "y" => $paidFees,
            "color" => '#1996bf'
        ),
        array(
            "name" => "Due",
            "y" => $unpaidFees,
            "color" => '#5C5C61'
        ),
        array(
            "name" => "Waived Fees",
            "y" => $waivedFees,
            "color" => '#FF8A65'
        )
        );
        // // Convert the data array to JSON format for use in Highcharts
        // $dataJSON = json_encode($data);

        return $data;

    }

    public function getSMSData($studentName){
        $this->db->select('*');
        $this->db->from('mailandsms');
        $this->db->where('users', $studentName);
        $this->db->order_by('create_date', 'DESC');
        $this->db->limit(5);
        $query = $this->db->get();
        $sms = $query->result();

        return $sms;
    }

    public function cards(){
        // Get today's date in Y-m-d format
        $today_date = date('Y-m-d');

        // Build the SQL query
        // $this->db->select('SUM(productpurchaseitem.productpurchaseunitprice * productpurchaseitem.productpurchasequantity) AS total_purchases');
        // $this->db->from('productpurchaseitem');
        // $this->db->join('productpurchase', 'productpurchase.productpurchaseID = productpurchaseitem.productpurchaseID');
        $this->db->select('SUM(productpurchasepaid.productpurchasepaidamount) AS total_purchases');
        $this->db->from('productpurchasepaid');
        $this->db->where('DATE(productpurchasepaid.productpurchasepaiddate)', $today_date);
        $query = $this->db->get();

        // Get the result
        $result = $query->row_array();
        $total_purchases = (int) $result['total_purchases'];

        $this->db->select('SUM(wallet_transactions.amount) AS wallet_credit');
        $this->db->from('wallet_transactions');
        $this->db->where('wallet_transactions.trx_type', 'credit');
        $this->db->where('DATE(wallet_transactions.create_date)', $today_date);

        $query =  $this->db->get();
        $result = $query->row_array();
        $wallet_credit = (int) $result['wallet_credit'];

        $this->db->select('SUM(mpesa_logs.TransAmount) AS mpesa_amount');
        $this->db->from('mpesa_logs');
        $this->db->where('DATE(mpesa_logs.TransTime)', $today_date);

        $query =  $this->db->get();
        $result = $query->row_array();
        $mpesa_amount = (int) $result['mpesa_amount'];
        
        $this->db->select('SUM(wallet_transactions.amount) AS todays_cash');
        $this->db->from('wallet_transactions');
        $this->db->where('wallet_transactions.trx_type', 'credit');
        $this->db->where('wallet_transactions.payment_type', 'CASH');
        $this->db->where('DATE(wallet_transactions.create_date)', $today_date);

        $query =  $this->db->get();
        $result = $query->row_array();
        $todays_cash = (int) $result['todays_cash'];

        // Build the SQL query sales
        // $this->db->select('SUM(productsaleitem.productsaleunitprice * productsaleitem.productsalequantity) AS total_sales');
        // $this->db->from('productsaleitem');
        // $this->db->join('productsale', 'productsale.productsaleID = productsaleitem.productsaleID');
        // $this->db->where('productsale.productsaledate', $today_date);
        
        $this->db->select('SUM(productsalepaid.productsalepaidamount) AS total_sales');
        $this->db->from('productsalepaid');
        $this->db->where('DATE(productsalepaid.productsalepaiddate)', $today_date);
        $query = $this->db->get();

        // Get the result
        $result = $query->row_array();
        $total_sales = (int) $result['total_sales'];

        $start_date = date('Y-m-d 00:00:00');
        $end_date = date('Y-m-d 23:59:59');

        // Build the SQL query for lunch sales
        $this->db->select('SUM(lunchlogs.amount) AS lunch');
        $this->db->from('lunchlogs');
        $this->db->where('date >=', $start_date);
        $this->db->where('date <=', $end_date);
        $query = $this->db->get();

        // Get the result
        $result = $query->row_array();
        $lunch = (int) $result['lunch'];

        // Build the SQL query Fees
        // $this->db->select('SUM(payment.paymentamount) AS total_fees');
        // $this->db->from('payment');
        // $this->db->where('paymentdate', $today_date);
        // $query = $this->db->get();

        // // Get the result
        // $result = $query->row_array();
        // $total_fees = (int) $result['total_fees'];
        
        $this->db->select('SUM(IFNULL(p.paymentamount, 0) + IFNULL(w.fine, 0)) AS total_fees');
        $this->db->from('payment AS p');
        $this->db->join('weaverandfine AS w', 'w.paymentID = p.paymentID', 'left');
        $this->db->where('DATE(p.paymentdate)', $today_date);
        $query = $this->db->get();

        
        if ($query === false) {
            // Handle the database query error
            $error_message = $this->db->error()['message'];
            // ... Display or log the error message as needed ...
            $total_fees = 0; // Set a default value for total fees
        } else {
            // Get the result
            $result = $query->row_array();
            $total_fees = isset($result['total_fees']) ? (float) $result['total_fees'] : 0.0;
        }

        

        // Build the SQL query Salaries
        $current_month = date('Y-m');
        $this->db->select('SUM(make_payment.payment_amount) AS salary');
        $this->db->from('make_payment');
        $this->db->where('DATE_FORMAT(make_payment.create_date, "%Y-%m") =', $current_month);
        $query = $this->db->get();

        // Get the result
        $result = $query->row_array();
        $salary = (int) $result['salary'];

        return [
            'total_purchases' => $total_purchases,
            'total_sales' => $total_sales,
            'lunch' => $lunch,
            'total_fees' => $total_fees,
            'salary' => $salary,
            'wallet_credit' => $wallet_credit,
            'mpesa_amount' => $mpesa_amount,
            'todays_cash' => $todays_cash,
        ];
    }
    
    public function get_latest_admissions($schoolyearID) {
        $this->db->select('*');
        $this->db->from('student');
        $this->db->join('studentrelation', 'student.studentID = studentrelation.srstudentID');
        $this->db->where('student.schoolyearID', $schoolyearID);
        $this->db->order_by('student.create_date', 'desc');
        $this->db->limit(10);
        $query = $this->db->get();
        return $query->result();
    }  

    public function get_highest_balance($schoolyearID) {
        
        $this->db->select('*');
        $this->db->from('student');
        $this->db->join('studentrelation', 'student.studentID = studentrelation.srstudentID');
        $this->db->where('studentrelation.srschoolyearID', $schoolyearID);
        // $this->db->limit(20);
        $query = $this->db->get();
        $students = $query->result();

        foreach($students as $student){
            $student->balance = $this->payment_m->balance($student->studentID);
        }
        
        $studentsWithHighBalance = array();

        foreach ($students as $student) {
            $student->balance = $this->payment_m->balance($student->studentID);
            if ($student->balance > 0) {
                $studentsWithHighBalance[] = $student;
            }
        }

        // Sort students by balance
        usort($studentsWithHighBalance, function ($a, $b) {
            return $b->balance - $a->balance;
        });
    
        // Return students with high balance
        return $studentsWithHighBalance;
        
    }  
    
    public function getSalariesData($schoolyearID){
        $this->db->select('make_payment.*, teacher.*');
        $this->db->from('make_payment');
        $this->db->join('teacher', 'teacher.teacherID = make_payment.userID');
        $this->db->order_by('make_payment.create_date desc');
        $this->db->where('schoolyearID', $schoolyearID);
        $query = $this->db->get();
        $result = $query->result();
        return $result;
    }

    public function getMpesaData(){
        $this->db->select('*');
        $this->db->from('mpesa_logs');
        $this->db->order_by('mpesa_logs.TransTime desc');
        $query = $this->db->get();
        $result = $query->result();
        return $result;
    }    
    
}