<style>
/* --- Existing and Consolidated Styles --- */
[data-theme="dark"] .btn-icon,
[data-theme="dark"] .bell-icon {
    color: #ffffff;
    background-color: transparent;
}
[data-theme="dark"] .btn-topbar > svg * {
    transition: .5s;
    fill: #fff;
}
[data-theme="dark"] .btn-calendar {
    background-color: #292B30 !important;
}
[data-theme="dark"] .btn-icon:hover {
    color: #ffffff !important;
    background-color: #292B30 !important;
}

.btn-icon:hover {
    color: #000;
    background-color: #E8EFF5 !important;
}

.btn-icon {
    transition: color 0.3s ease, background-color 0.3s ease;
}

.dropdown-menu a:hover {
    background-color: transparent !important;
    font-size: 14px;
}

[data-theme="dark"].dropdown-menu a:hover {
    background-color: #292B30 !important;
    color: #333 !important;
    font-size: 14px;
}

[data-theme="dark"] .dropdown-menu {
    background-color: #292B30;
    border: 1px solid #3a3d45;
    border-radius: 8px;
    padding: 10px;
    box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.5);
}

[data-theme="dark"] .dropdown-menu ul li {
    background-color: #292B30 !important;
    color: #fff !important;
    padding: 8px 12px !important;
    border-radius: 6px !important;
    transition: all 0.3s ease;
}

[data-theme="dark"] .dropdown-menu ul li:hover {
    background-color: #292B30 !important;
    color: #fff !important;
    cursor: pointer;
}

[data-theme="dark"] .dropdown-menu ul li span {
    color: #28a745 !important;
    font-weight: 500 !important;
}

[data-theme="dark"] .dropdown-menu ul li i {
    color: #28a745 !important;
    margin-left: 8px !important;
}

/* --- Responsive Adjustments --- */
.site-logo {
    width: 30px; /* Default desktop size */
    height: 30px;
    margin-right: 10px;
}

.site-name {
    font-size: 20px; /* Default desktop size */
}

/* Ensure all icons within btn-topbar and bell-icon are consistently sized by default */
.btn-topbar svg,
.btn-topbar i,
.bell-icon i {
    font-size: 1.5rem; /* For Bootstrap icons */
    width: 1.5rem;   /* For SVG icons */
    height: 1.5rem;  /* For SVG icons */
    display: flex; /* Ensures proper centering/alignment if needed */
    align-items: center;
    justify-content: center;
}

/* Media Query for typical mobile devices (<= 768px wide) */
@media (max-width: 768px) {
    .aiz-topbar {
        padding-left: 10px !important; /* Slightly reduce overall topbar padding */
        padding-right: 10px !important;
    }

    .aiz-topbar-nav-toggler {
        margin-left: 0 !important; /* Ensure no extra left margin */
        margin-right: 10px !important; /* Adjust right margin for hamburger */
    }

    .site-logo {
        width: 25px; /* Smaller logo on mobile */
        height: 25px;
        margin-right: 5px; /* Reduced space between logo and name */
    }

    .site-name {
        font-size: 0.9rem; /* Smaller font size for name on mobile */
    }

    /* Reduce spacing between topbar items on mobile */
    .aiz-topbar-item {
        margin-right: 0.5rem !important; /* Compacting items */
    }

    /* Make icons slightly smaller on mobile for better fit */
    .btn-topbar svg,
    .btn-topbar i,
    .bell-icon i {
        font-size: 1.2rem !important; /* Adjust font-size for font icons */
        width: 1.2rem;   /* Adjust width for SVG icons */
        height: 1.2rem;  /* Adjust height for SVG icons */
    }

    /* Adjust the 'Add New' button on mobile */
    .aiz-topbar-item:has(.btn-soft-blue) .btn-soft-blue {
        padding: 0.3rem 0.5rem; /* Smaller padding for the button */
        font-size: 0.8rem; /* Smaller font for any visible text */
    }

    /* Hide the 'Add New' text completely on smaller screens (already handled by d-md-block, but ensuring) */
    .aiz-topbar-item:has(.btn-soft-blue) .btn-soft-blue .fw-500 {
        display: none !important;
    }

    /* Hide the language selector completely on mobile if desired */
    /* Add this class to the language div: <div class="aiz-topbar-item mr-3 d-none d-md-block"> */
    /* This makes it disappear below 'md' breakpoint, you can change 'md' to 'sm' if you want it gone earlier */
    .aiz-topbar-item.hide-on-mobile {
        display: none !important;
    }
}

/* Media Query for very small mobile devices (<= 480px wide) */
@media (max-width: 480px) {
    .aiz-topbar {
        padding-left: 5px !important;
        padding-right: 5px !important;
    }

    .aiz-topbar-item {
        margin-right: 0.3rem !important; /* Further reduce margin */
    }

    /* Make icons even smaller if needed */
    .btn-topbar svg,
    .btn-topbar i,
    .bell-icon i {
        font-size: 1rem !important;
        width: 1rem;
        height: 1rem;
    }
    /* Potentially hide more elements if space is extremely limited */
}

/*USER PROFILE MENU */

.modern-user-dropdown {
    border: 1px solid #e0e0e0;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    padding: 10px;
    margin-bottom: 15px; /* Added padding to the bottom */
    width: 250px; /* Adjust as needed */
    background-color: #fff;
    color: #333;
    }

/* Dark mode styles */
@media (prefers-color-scheme: dark) {
    .modern-user-dropdown {
        background-color: #1e1e1e;
        color: #eee;
        border-color: #333;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.4);
    }

    .user-info {
        border-bottom-color: #333;
    }

    .user-details h4 {
        color: #333;
    }

    .user-details .user-type {
        color: #bbb;
    }

    .user-actions.simple-links li a {
        color: #eee;
    }

    .user-actions.simple-links li a:hover {
    color: #000; /* Highlight text on hover in light mode */
    background-color: transparent; /* Ensure transparent background on hover */
    }

    .logout-button {
        color: #f44336;
        border-color: #f44336;
    }

    .logout-button:hover {
        background-color: rgba(244, 67, 54, 0.1);
    }
}

.user-info.centered {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
    margin-bottom: 15px;
    text-align: center;
}

.user-avatar {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    overflow: hidden;
    margin-top: 10px;
    margin-bottom: 10px;
}

.user-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}


.user-avatar-top {
    width: 35px; /* Adjust size as needed */
    height: 35px; /* Must be the same as width for a perfect circle */
    border-radius: 50%;
    overflow: hidden; /* Clips the image to the circle */
}

.user-avatar-top img {
     width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image covers the entire circle without distortion */

}

.user-details.centered-text {
    text-align: center;
}

.user-details h4 {
    margin: 5px 0;
    font-size: 18px;
    font-weight: 600;
    color: #333;
}

.user-details .user-type {
    margin: 0;
    font-size: 13px;
    color: #777;
}

.user-actions.simple-links {
    list-style: none;
    padding: 0;
    margin: 0 0 15px;
}

.user-actions.simple-links li a {
    display: block;
    padding: 10px 15px;
    text-decoration: none;
    color: #333;
    font-size: 20px;
    transition: color 0.2s ease; /* Transition only color */
}

.user-actions.simple-links li a:hover {
    color: #000; /* Highlight text on hover */
    background-color: transparent; /* Remove background color on hover */
}

/* Logout Button */
.logout-container.centered {
    text-align: center;
    
}

.user-actions.simple-links li a:hover {
        color: #aaa; /* Highlight text on hover in dark mode */
        background-color: transparent; /* Remove background color on hover */
    }

    .logout-link {
        color: #f44336; /* Style the logout link text in dark mode */
    }
</style>

<div class="aiz-topbar px-15px px-lg-25px d-flex align-items-stretch justify-content-between">
    <div class="d-flex">
        <div class="aiz-topbar-nav-toggler d-flex align-items-center justify-content-start ml-0 mr-2" data-toggle="aiz-mobile-nav">
            <a class="btn btn-topbar has-transition btn-icon p-0 d-flex align-items-center" href="javascript:void(0)">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                    <g id="Group_28009" data-name="Group 28009" transform="translate(0 16) rotate(-90)">
                        <rect id="Rectangle_18283" data-name="Rectangle 18283" width="2" height="7" rx="1" fill="#9da3ae"/>
                        <rect id="Rectangle_16236" data-name="Rectangle 16236" width="2" height="11" rx="1" transform="translate(14)" fill="#9da3ae"/>
                        <rect id="Rectangle_18284" data-name="Rectangle 18284" width="2" height="16" rx="1" transform="translate(7)" fill="#9da3ae"/>
                    </g>
                </svg>
            </a>
        </div>
    </div>

    <div class="d-flex justify-content-between align-items-stretch flex-grow-1">
        <div class="d-flex justify-content-around align-items-center align-items-stretch">
            <div class="aiz-topbar-item mr-3">
                <div class="d-flex align-items-center">
                    <?php
                        if(customCompute($siteinfos->photo)) {
                            echo "<img class='site-logo' src=".base_url('uploads/images/'.$siteinfos->photo)." />";
                        }
                    ?>
                    <h2 class="site-name"><?php echo get_setting('sname');?></h2>
                </div>
            </div>
            <div class="d-flex justify-content-around align-items-center align-items-stretch">
                <div class="aiz-topbar-item d-none d-sm-block"> <div class="d-flex align-items-center h-100">
                        <a class="btn btn-soft-blue btn-sm d-flex align-items-center rounded-2 hov-svg-white"
                            href="products.create">
                            <span class="fw-500 mx-2 mr-0 d-none d-md-block">Add New</span> <i class="fa fa-plus fs-18"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-around align-items-center align-items-stretch">
            <div class="aiz-topbar-item mr-3">
                <div class="d-flex align-items-center">
                    <a onclick="openFullscreen();" class="btn btn-topbar has-transition btn-icon btn-circle p-0 hov-bg-primary hov-svg-white d-flex align-items-center justify-content-center" href="javascript:void(0);">
                        <i id="fullscreenIcon" class="bi" style="font-size: 1.5rem;"></i>
                    </a>
                </div>
            </div>

            <div class="aiz-topbar-item mr-3">
                <div class="d-flex align-items-center">
                    <a data-theme-toggle id="darkModeToggle" class="btn btn-topbar has-transition btn-icon btn-circle p-0 hov-bg-primary hov-svg-white d-flex align-items-center justify-content-center" href="javascript:void(0);">
                        <i id="darkModeIcon" class="bi" style="font-size: 1.5rem;"></i>
                    </a>
                </div>
            </div>

            <?php if(permissionChecker('schoolyear')) { funtopbarschoolyear($siteinfos, $topbarschoolyears); } ?>

            <div class="aiz-topbar-item mr-3">
                <div class="align-items-stretch d-flex dropdown">
                    <a class="dropdown-toggle no-arrow bell-icon" data-toggle="dropdown" href="javascript:void(0);" role="button"
                        aria-haspopup="false" aria-expanded="false">
                        <i class="bi bi-bell" style="font-size: 1.5rem;"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-animated dropdown-menu-xl py-0">
                        <div class="notifications">
                            <ul class="dropdown-menu my-push-message-ul" style="display:none">
                                <li class='header my-push-message-number'></li>
                                <li>
                                    <ul class="menu my-push-message-list"></ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(isset($siteinfos->language_status) && $siteinfos->language_status == 0) { ?>
            <div class="aiz-topbar-item mr-3 d-none d-md-block"> <div class="align-items-stretch d-flex dropdown" id="lang-change">
                    <a class="dropdown-toggle no-arrow" data-toggle="dropdown" href="javascript:void(0);"
                        role="button" aria-haspopup="false" aria-expanded="false">
                        <span class="btn btn-topbar btn-circle p-0 d-flex justify-content-center align-items-center">
                            <img src="<?php
                                    $image = $this->session->userdata('lang');
                                    echo base_url('uploads/language_image/'.$image.'.png'); ?>" height="11">
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-animated dropdown-menu-xs">
                        <li>
                            <a href="javascript:void(0)" data-flag="" class="dropdown-item active">
                                <img src="<?php echo base_url('uploads/language_image/arabic.png'); ?>" class="mr-2">
                                <span class="language">Arabic</span>
                            </a>
                        </li>
                        <li id="bengali">
                            <a href="<?php echo base_url('language/index/bengali')?>">
                                <img src="<?php echo base_url('uploads/language_image/bengali.png'); ?>" class="mr-2">
                                <span class="language">Bengali</span>
                            </a>
                        </li>
                        <li id="chinese">
                            <a href="<?php echo base_url('language/index/chinese')?>">
                                <img src="<?php echo base_url('uploads/language_image/chinese.png'); ?>" class="mr-2">
                                <span class="language">Chinese</span>
                            </a>
                        </li>
                        <li id="english">
                            <a href="<?php echo base_url('language/index/english')?>">
                                <img src="<?php echo base_url('uploads/language_image/english.png'); ?>" class="mr-2">
                                <span class="language">English</span>
                            </a>
                        </li>
                        <li id="french">
                            <a href="<?php echo base_url('language/index/french')?>">
                                <img src="<?php echo base_url('uploads/language_image/french.png'); ?>" class="mr-2">
                                <span class="language">French</span>
                            </a>
                        </li>
                        <li id="german">
                            <a href="<?php echo base_url('language/index/german')?>">
                                <img src="<?php echo base_url('uploads/language_image/german.png'); ?>" class="mr-2">
                                <span class="language">German</span>
                            </a>
                        </li>
                        <li id="hindi">
                            <a href="<?php echo base_url('language/index/hindi')?>">
                                <img src="<?php echo base_url('uploads/language_image/hindi.png'); ?>" class="mr-2">
                                <span class="language">Hindi</span>
                            </a>
                        </li>
                        <li id="indonesian">
                            <a href="<?php echo base_url('language/index/indonesian')?>">
                                <img src="<?php echo base_url('uploads/language_image/indonesian.png'); ?>" class="mr-2">
                                <span class="language">Indonesian</span>
                            </a>
                        </li>
                        <li id="italian">
                            <a href="<?php echo base_url('language/index/italian')?>">
                                <img src="<?php echo base_url('uploads/language_image/italian.png'); ?>" class="mr-2">
                                <span class="language">Italian</span>
                            </a>
                        </li>
                        <li id="portuguese">
                            <a href="<?php echo base_url('language/index/portuguese')?>">
                                <img src="<?php echo base_url('uploads/language_image/portuguese.png'); ?>" class="mr-2">
                                <span class="language">Portuguese</span>
                            </a>
                        </li>
                        <li id="romanian">
                            <a href="<?php echo base_url('language/index/romanian')?>">
                                <img src="<?php echo base_url('uploads/language_image/romanian.png'); ?>" class="mr-2">
                                <span class="language">Romanian</span>
                            </a>
                        </li>
                        <li id="russian">
                            <a href="<?php echo base_url('language/index/russian')?>">
                                <img src="<?php echo base_url('uploads/language_image/russian.png'); ?>" class="mr-2">
                                <span class="language">Russian</span>
                            </a>
                        </li>
                        <li id="spanish">
                            <a href="<?php echo base_url('language/index/spanish')?>">
                                <img src="<?php echo base_url('uploads/language_image/spanish.png'); ?>" class="mr-2">
                                <span class="language">Spanish</span>
                            </a>
                        </li>
                        <li id="thai">
                            <a href="<?php echo base_url('language/index/thai')?>">
                                <img src="<?php echo base_url('uploads/language_image/thai.png'); ?>" class="mr-2">
                                <span class="language">Thai</span>
                            </a>
                        </li>
                        <li id="turkish">
                            <a href="<?php echo base_url('language/index/turkish')?>">
                                <img src="<?php echo base_url('uploads/language_image/turkish.png'); ?>" class="mr-2">
                                <span class="language">Turkish</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <?php } ?>

            <div class="aiz-topbar-item">
                <div class="align-items-stretch d-flex dropdown userbox">
                    <a href="#" data-toggle="dropdown" class="user-top">
                       <div class="user-avatar-top">
                         <img src="<?=imagelink($this->session->userdata('photo'))?>" alt="user-image">
                    </div>
                    </a>
                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
            <div class="dropdown-menu modern-user-dropdown">
                <div class="user-info centered">
                    <div class="user-avatar">
                        <img src="<?=imagelink($this->session->userdata('photo'))?>" alt="User Avatar">
                    </div>
                    <div class="user-details centered-text">
                        <h4><?php echo $this->session->userdata('name');?></h4>
                        <p class="user-type"><?php echo $this->session->userdata('usertype');?></p>
                    </div>
                </div>
                <ul class="user-actions simple-links">
                    <li>
                    <a href="<?php echo base_url('profile');?>">
                        <i class="fas fa-user"></i> <?=$this->lang->line("profile")?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo base_url('signin/cpassword');?>">
                        <i class="fas fa-lock"></i> <?=$this->lang->line("change_password")?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo base_url('signin/signout'); ?>" class="logout-link">
                        <i class="fas fa-sign-out"></i> <?=$this->lang->line("logout")?>
                    </a>
                </li>
            </ul>
        </div>

                </div>
            </div></div>
    </div>
</div>