<style>
    /* Switch Styles */
.switch {
    position: relative;
    display: inline-block;
    width: 40px;
    height: 20px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 20px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 14px;
    width: 14px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #007bff;
}

input:checked + .slider:before {
    transform: translateX(20px);
}

</style>
<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-cogs"></i> Cron Job Setting</h3>
    </div>
    <div class="box-body">
        <fieldset class="setting-fieldset">
                <legend class="setting-legend">Cron Details</legend>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="col-sm-12">
                                <div class='form-group form-group'>
                                    <div class="col-sm-10">
                                        <label for="guargianID" class="control-label">
                                                Queue Work
                                        </label>
                                        <input type="text" class="form-control" value="wget -q -O - <?= base_url('cron/run') ?> >/dev/null 2>&1" readonly>
                                    </div>
                                    <div class="col-sm-2 col-md-2">
                                        <button class="btn btn-success btn-append" style="margin-top:25px;" onclick="copyToClipboard(this)">Copy</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class='form-group form-group'>
                                <div class="col-sm-10">
                                    <label for="guargianID" class="control-label"  style="margin-top:30px;">
                                            Enable Cron Service
                                    </label>
                                    <label class="switch" style="margin-left:30px;">
                                        <input type="checkbox" id="cron_service" name="cron_service" 
                                            <?= get_setting('cron_service') == 1 ? 'checked' : '' ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                            <!--<div class="p-3 border rounded shadow-sm" style="padding: 30px">-->
                            <!--    <h5><strong>How to Add a Cron Job in cPanel</strong></h5>-->
                            <!--    <ol>-->
                            <!--        <li>Log in to your cPanel account.</li>-->
                            <!--        <li>Navigate to the <strong>"Cron Jobs"</strong> section under the <strong>Advanced</strong> category.</li>-->
                            <!--        <li>In the <strong>"Add New Cron Job"</strong> section, configure the schedule:</li>-->
                            <!--        <ul>-->
                            <!--            <li><strong>Minute:</strong> Set to <code>0</code> for hourly execution or any specific minute.</li>-->
                            <!--            <li><strong>Hour:</strong> Set to <code>8,17</code> if you want it to run at 8 AM and 5 PM.</li>-->
                            <!--            <li><strong>Day:</strong> Leave as <code>*</code> to run daily.</li>-->
                            <!--            <li><strong>Month:</strong> Leave as <code>*</code> to run every month.</li>-->
                            <!--            <li><strong>Weekday:</strong> Leave as <code>*</code> to run every day of the week.</li>-->
                            <!--        </ul>-->
                            <!--        <li>In the <strong>"Command"</strong> field, enter your cron job command:</li>-->
                            <!--        <pre>wget -q -O - https://skooly.biznr.co.ke/cron/run >/dev/null 2>&1</pre>-->
                            <!--        <li>Click the <strong>"Add New Cron Job"</strong> button.</li>-->
                            <!--        <li>Verify that the new cron job appears under <strong>"Current Cron Jobs."</strong></li>-->
                            <!--    </ol>-->
                            <!--    <p class="text-muted">-->
                            <!--        Your cron job is now scheduled. You can check execution logs or system logs in cPanel for debugging if necessary.-->
                            <!--    </p>-->
                            <!--</div>-->
                        </div>
                    </div>
            </fieldset>
    </div>
</div>

<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-calendar"></i> Automation Setting</h3>
    </div>
    <div class="box-body">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Initiated At</th>
                        <th>Name</th>
                        <th>Ideal Time</th>
                        <th>Specific Time</th>
                        <th>Last Run</th>
                        <th>Next Run</th>
                        <th>Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($crons)) { foreach ($crons as $cron) { ?>
                        <tr>
                            <td><?= date('Y-m-d h:i A', strtotime($cron->created_at)) ?></td>
                            <td><?= $cron->name ?></td>
                            <td><?= ucfirst(strtolower(str_replace('_', ' ', $cron->ideal_time))) ?></td>
                            <td><?= $cron->specific_time ? date('h:i A', strtotime($cron->specific_time)) : '-' ?></td>
                            <td><?= $cron->last_run ? date('Y-m-d h:i A', strtotime($cron->last_run)) : 'Never' ?></td>
                            <td><?= $cron->next_run ? date('Y-m-d h:i A', strtotime($cron->next_run)) : '' ?></td>
                            <td>
                                <button class="btn btn-info btn-sm cron-detail-btn" data-toggle="tooltip" data-placement="top" title="<?= htmlspecialchars($cron->message?? '', ENT_QUOTES) ?>">
                                    <i class="fa fa-info-circle"></i>
                                </button>
                            </td>

                        </tr>
                    <?php } } else { ?>
                        <tr><td colspan="5" class="text-center">No cron jobs available.</td></tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function copyToClipboard(button) {
        let input = button.closest('.form-group').querySelector('input');
        if (input) {
            input.select();
            document.execCommand('copy');
            button.textContent = 'Copied!';
            setTimeout(() => { button.textContent = 'Copy'; }, 2000);
        }
    }

    
    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip();

        $('.cron-detail-btn').click(function () {
            let tooltip = $(this);
            tooltip.tooltip('show');

            setTimeout(() => { tooltip.tooltip('hide'); }, 3000);
        });
        
        $("#cron_service").change(function () {
            let status = this.checked ? 1 : 0;
    
            $.ajax({
                type: 'POST',
                url: "<?= base_url('automation/update_cron_service') ?>",
                data: { cron_service: status },
                dataType: "json",
                success: function (response) {
                    if (response.success) {
                        console.log("Cron Service updated successfully");
                    } else {
                        console.error("Failed to update Cron Service");
                    }
                },
                error: function () {
                    console.error("An error occurred while updating Cron Service");
                }
            });
        });
    });


</script>
