<script type="application/javascript">
$(function() {
    LoadFeeDonutMonthly();
    function LoadFeeDonutMonthly()
    {   
        var data = <?php echo json_encode($fess_donut); ?>;
        Highcharts.chart('donut-fee', {
            chart: {
                type: 'pie',
                options3d: {
                    enabled: true,
                    alpha: 45
                }
            },
            title: {
                text: 'Fee Payment Status <?=getSchoolYear()?>',
                align: 'center'
            },
            subtitle: {
                text: 'Total Fees: <?= number_format($fess_donut[0]["y"]+$fess_donut[1]["y"]); ?>',
                style: {
                    fontWeight: 'bold',
                    fontSize: '16px'
                }
            },
            accessibility: {
                announceNewData: {
                    enabled: true
                },
                point: {
                    valueSuffix: 'KES'
                }
            },
            tooltip: {
                formatter: function() {
                            return this.point.name + ': ' + Highcharts.numberFormat(this.point.y, 0, '.', ',');
                }
            },
            plotOptions: {
                pie: {
                    innerSize: 100,
                    depth: 45,
                    dataLabels: {
                        enabled: false,
                        formatter: function() {
                            return this.point.name + ':' + Highcharts.numberFormat(this.point.y, 0, '.', ',');
                        }
                    },
                    showInLegend: true
                }
            },
            series: [{
                name: 'Fee Status',
                colorByPoint: true,
                data: data
            }]
        });
    }
});
</script>
