<?php
// FILE: application/views/invoice/invoice_payment_form.php

/**
 * Renders the invoice payment and waiver form.
 * This version includes a toggle to switch between payment and waiver modes.
 */
?>
<form role="form" method="post" id="payment-form">
<div class="row">
    <div class="col-sm-3">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title"><i class="fa icon-invoice"></i> <?=$this->lang->line('invoice_payment')?></h3>
            </div>

            <div class="box-body box-profile">
                <center>
                <?=profileviewimage($studentprofile->photo)?>
                </center>

                <h3 class="profile-username text-center"><?=$student->srname?></h3>

                <p class="text-muted text-center"><?=$usertype->usertype?></p>

                <ul class="list-group list-group-unbordered">
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_registerno')?></b> <a class="pull-right"><?=$student->srregisterNO?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_roll')?></b> <a class="pull-right"><?=$student->srroll?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_class')?></b> <a class="pull-right"><?=customCompute($class) ? $class->classes : ''?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_section')?></b> <a class="pull-right"><?=customCompute($section) ? $section->section : ''?></a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="box" style="margin-bottom:40px">
            <div class="box-header">
                <h3 class="box-title"><i class="fa fa-money"></i> <?=$this->lang->line('panel_title')?></h3>
            </div>
            <div class="box-body">
                <div class="form-group <?=form_error('paymentmethodID') ? 'has-error' : '' ?>">
                    <label for="paymentmethodID"><?=$this->lang->line('invoice_paymentmethod')?> <span class="text-red">*</span></label>
                    <?php
                        $paymentmethodArray['0'] = $this->lang->line("invoice_select_paymentmethod");
                        //hide Cash and Bank when Paying
                        if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) {
                            $paymentmethodArray['Wallet'] = $this->lang->line('Wallet');
                        }
                       
                        if ($payment_settings['paypal_status'] == true) {
                            $paymentmethodArray['Paypal'] = $this->lang->line('Paypal');
                        }
                       
                        if ($payment_settings['stripe_status'] == true) {
                            $paymentmethodArray['Stripe'] = $this->lang->line('Stripe');
                        }
                       
                        if ($payment_settings['payumoney_status'] == true) {
                            $paymentmethodArray['Payumoney'] = $this->lang->line('PayUMoney');
                        }
                       
                        if ($payment_settings['voguepay_status'] == true) {
                            $paymentmethodArray['Voguepay'] = $this->lang->line('Voguepay');
                        }
                       
                        // 1. Add a hidden input to ensure the value is submitted
                        echo form_hidden('paymentmethodID', 'Wallet');
                       
                        // 2. Modify form_dropdown to set 'Wallet' as selected and disable the field
                        echo form_dropdown("paymentmethodID", $paymentmethodArray, 'Wallet', "id='paymentmethodID' class='form-control select2' disabled");
                    ?>
                    <span class="text-red">
                        <?=form_error('paymentmethodID')?>
                    </span>
                </div>

                <!-- Card Options fields -->
                <div id="cardOption" style="display: none; margin-bottom:40px">
                    <div id="card-element" style="padding: 8px;border: 1px solid #ddd;"></div>
                    <div id="card-errors" class="text-danger" role="alert"></div>
                </div>
                <!-- Card options end-->
                <!-- PayUOptions Options fields -->
                <div id="payuInputs" style="display: none;">
                    <div class="form-group <?=form_error('first_name') ? 'has-error' : ''; ?>" >
                        <label for="first_name"><?=$this->lang->line("first_name")?></label>
                        <input type="text" class="form-control" id="first_name" name="first_name" value="<?=set_value('first_name', null)?>" >
                        <span class="text-red">
                            <?php echo form_error('first_name'); ?>
                        </span>
                    </div>
                    <div class="form-group <?=form_error('email') ? 'has-error' : ''; ?>" >
                        <label for="email"><?=$this->lang->line("email")?></label>
                        <input type="text" class="form-control" id="email" name="email" value="<?=set_value('email', null)?>" >
                        <span class="text-red"><?php echo form_error('email'); ?></span>
                    </div>
                    <div class="form-group <?=form_error('phone') ? 'has-error' : ''; ?>" >
                        <label for="phone" ><?=$this->lang->line("phone")?></label>
                        <input type="text" class="form-control" id="phone" name="phone" value="<?=set_value('phone', null)?>" >
                        <span class="text-red">
                            <?php echo form_error('phone'); ?>
                        </span>
                    </div>
                </div>
                <!-- PayUOptions options end-->

                <!-- START: New Toggle for Payment/Waiver -->
                <div class="form-group">
                    <label>Transaction Type</label>
                    <div class="input-group">
                        <span class="input-group-addon">
                            <input type="radio" name="transaction_type" value="payment" checked> Payment
                        </span>
                        <span class="input-group-addon">
                            <input type="radio" name="transaction_type" value="waiver"> Waiver
                        </span>
                    </div>
                </div>
                <!-- END: New Toggle for Payment/Waiver -->
                
                <input type="hidden" name="transaction_type" id="transaction_type" value="payment">
                <button id="addPaymentButton" type="submit" class="btn btn-success"><?=$this->lang->line('add_payment')?></button>
            </div>
        </div>
    </div>

    <div class="col-sm-9">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title"><i class="fa icon-feetypes"></i> <?=$this->lang->line('invoice_feetype_list')?></h3>
                <ol class="breadcrumb">
                    <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
                    <li><a href="<?=base_url("invoice/index")?>"><?=$this->lang->line('menu_invoice')?></a></li>
                    <li class="active"><?=$this->lang->line('menu_add')?> <?=$this->lang->line('invoice_payment')?></li>
                </ol>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-bordered feetype-style" style="font-size: 16px;">
                        <thead>
                            <tr>
                                <th class="col-sm-1"><?=$this->lang->line('slno')?></th>
                                <th class="col-sm-3"><?=$this->lang->line('invoice_feetype')?></th>
                                <th class="col-sm-1" ><?=$this->lang->line('invoice_amount')?></th>
                                <th class="col-sm-1" ><?=$this->lang->line('invoice_due')?></th>
                                <th class="col-sm-2 paid-column"><?=$this->lang->line('invoice_paid_amount')?></th>
                                <?php if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) { ?>
                                    <th class="col-sm-2 waiver-column" style="display: none;"><?=$this->lang->line('invoice_weaver')?></th>
                                    <th class="col-sm-2 waiver-column" style="display: none;"><?=$this->lang->line('invoice_fine')?></th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody id="feetypeList">
                            <?php 
                                $totalAmount = 0;
                                $totalDue = 0;
                                if(customCompute($invoices)) {
                                    $i = 1;
                                    foreach ($invoices as $invoice) {
                                        $amount = $invoice->amount;
                                        $due = 0;

                                        if(isset($invoicepaymentandweaver['totalamount'][$invoice->invoiceID])) {
                                            $due =  $invoicepaymentandweaver['totalamount'][$invoice->invoiceID]; 

                                            if(isset($invoicepaymentandweaver['totaldiscount'][$invoice->invoiceID])) {
                                                $due =  ($due -$invoicepaymentandweaver['totaldiscount'][$invoice->invoiceID]);
                                            }

                                            if(isset($invoicepaymentandweaver['totalpayment'][$invoice->invoiceID])) {
                                                $due = ($due - $invoicepaymentandweaver['totalpayment'][$invoice->invoiceID]);
                                            } 

                                            if(isset($invoicepaymentandweaver['totalweaver'][$invoice->invoiceID])) {
                                                $due = ($due - $invoicepaymentandweaver['totalweaver'][$invoice->invoiceID]);
                                            }
                                        }

                                        $totalAmount += $amount; 
                                        $totalDue += $due; 
                                        $rand = rand(1, 9999999999);

                                        echo '<tr id="tr_'.$rand.'">';
                                            echo '<td>';
                                                echo $i; 
                                            echo '</td>';

                                            echo '<td>';
                                                echo isset($feetypes[$invoice->feetypeID]) ? $feetypes[$invoice->feetypeID] : ''; 
                                            echo '</td>';

                                            echo '<td>';
                                                echo $amount; 
                                            echo '</td>';

                                            echo '<td id="due_'.$rand.'">';
                                                echo $due; 
                                            echo '</td>';

                                       //      $disabled = ($this->session->userdata('user')->usertypeID != 1) ? 'disabled' : ''; 
                                        
                // Disable payment button for other users except accounts and admin
                                             $disabled =  ($this->session->userdata('user')->usertypeID != 1 && $this->session->userdata('user')->usertypeID != 5) ? 'disabled' : '';
                                             echo '<td class="paid-column">';
                                             echo '<input id="paidamount_'.$rand.'" class="form-control change-paidamount '.(form_error('paidamount_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="paidamount_'.$invoice->invoiceID.'" value="'.set_value('paidamount_'.$invoice->invoiceID).'" '.$disabled.'>';
                                             echo '</td>';

                                             if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) {
                                                 echo '<td class="waiver-column" style="display: none;">';
                                                     echo '<input id="weaver_'.$rand.'" class="form-control change-weaver '.(form_error('weaver_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="weaver_'.$invoice->invoiceID.'" value="'.set_value('weaver_'.$invoice->invoiceID).'" >';
                                                 echo '</td>';

                                                 echo '<td class="waiver-column" style="display: none;">';
                                                     echo '<input id="fine_'.$rand.'" class="form-control change-fine '.(form_error('fine_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="fine_'.$invoice->invoiceID.'" value="'.set_value('fine_'.$invoice->invoiceID).'" >';
                                                 echo '</td>';
                                             }
                                        echo '</tr>';
                                        $i++;
                                    } 
                                } 
                            ?>
                        </tbody>
                        <tfoot id="feetypeListFooter">
                            <tr>
                                <td colspan="2" style="font-weight: bold"><?=$this->lang->line('invoice_total')?></td>
                                <td id="totalAmount" style="font-weight: bold"><?=number_format($totalAmount, 2);?></td>
                                <td id="totalDue" style="font-weight: bold"><?=number_format($totalDue, 2);?></td>
                                <td id="totalPaidAmount" class="paid-column" style="font-weight: bold">0.00</td>
                                <?php if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) { ?>
                                    <td id="totalWeaver" class="waiver-column" style="font-weight: bold; display: none;">0.00</td>
                                    <td id="totalFine" class="waiver-column" style="font-weight: bold; display: none;">0.00</td>
                                <?php } ?>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
<script>
    var originalDueAmounts = {};
    
    function updateAllTotalsAndDues() {
        var totalPaidAmount = 0;
        var totalWeaver = 0;
        var totalFine = 0;
        var totalDue = 0;

        $('#feetypeList tr').each(function() {
            var rowId = $(this).find('td:eq(4) input').attr('id').split('_')[1];

            var paidAmount = parseFloat($('#paidamount_' + rowId).val()) || 0;
            var weaverAmount = parseFloat($('#weaver_' + rowId).val()) || 0;
            var fineAmount = parseFloat($('#fine_' + rowId).val()) || 0;
            
            // Cap waiver amount to the original due amount
            if (weaverAmount > originalDueAmounts[rowId]) {
                weaverAmount = originalDueAmounts[rowId];
                $('#weaver_' + rowId).val(weaverAmount.toFixed(2));
            }

            var currentDue = originalDueAmounts[rowId] - paidAmount - weaverAmount;
            if (currentDue < 0) {
                currentDue = 0;
            }
            $('#due_' + rowId).text(currentDue.toFixed(2));

            totalPaidAmount += paidAmount;
            totalWeaver += weaverAmount;
            totalFine += fineAmount;
            totalDue += currentDue;
        });

        $('#totalPaidAmount').text(currencyConvert(totalPaidAmount));
        $('#totalWeaver').text(currencyConvert(totalWeaver));
        $('#totalFine').text(currencyConvert(totalFine));
        $('#totalDue').text(currencyConvert(totalDue));
    }

    $(document).ready(function() {
        // Store original due amounts on page load
        $('.change-paidamount').each(function () {
            var rowId = $(this).attr('id').split('_')[1];
            var dueAmount = parseFloat($('#due_' + rowId).text());
            if (!isNaN(dueAmount)) {
                originalDueAmounts[rowId] = dueAmount;
            }
        });

        // Event listeners for input changes
        $(document).on('keyup', '.change-paidamount', function () {
            var rowId = $(this).attr('id').split('_')[1];
            var paidAmount = parseFloat($(this).val()) || 0;
            if (paidAmount > originalDueAmounts[rowId]) {
                $(this).val(originalDueAmounts[rowId].toFixed(2));
            }
            updateAllTotalsAndDues();
        });

        $(document).on('keyup', '.change-weaver', function () {
            updateAllTotalsAndDues();
        });
        
        // Handle transaction type toggle
        $('input[name="transaction_type"]').on('change', function() {
            const selectedType = $(this).val();
            $('#transaction_type').val(selectedType);

            if (selectedType === 'waiver') {
                $('.paid-column').hide();
                $('.waiver-column').show();
                // Clear paid amount fields
                $('.change-paidamount').val('');
            } else { // 'payment'
                $('.waiver-column').hide();
                $('.paid-column').show();
                // Clear weaver/fine fields
                $('.change-weaver').val('');
                $('.change-fine').val('');
            }
            
            // Recalculate all totals after mode switch
            updateAllTotalsAndDues();
        });

        // Initial calculation on page load
        updateAllTotalsAndDues();
    });

</script>

<script type="text/javascript">
    window.onload = function() {
        CheckType();
    };
    function CheckType() {
        var payment_method = $('#paymentmethodID').val();

        $('#cardOption').hide();
        $('#payuInputs').hide();
    }


    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function (event) {
        event.preventDefault();
        var payment_method = $('#paymentmethodID').val();
        if (payment_method=="Stripe") {

        } else {
            form.submit();
        }
    });

    function dd(data) {
        console.log(data);
    }

    $('.select2').select2();

    function getRandomInt() {
      return Math.floor(Math.random() * Math.floor(9999999999999999));
    }

    function toFixedVal(x) {
      if (Math.abs(x) < 1.0) {
        var e = parseFloat(x.toString().split('e-')[1]);
        if (e) {
            x *= Math.pow(10,e-1);
            x = '0.' + (new Array(e)).join('0') + x.toString().substring(2);
        }
      } else {
        var e = parseFloat(x.toString().split('+')[1]);
        if (e > 20) {
            e -= 20;
            x /= Math.pow(10,e);
            x += (new Array(e+1)).join('0');
        }
      }
      return x;
    }

    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }

    function dotAndNumber(data) {
        var retArray = [];
        var fltFlag = true;
        if(data.length > 0) {
            for(var i = 0; i <= (data.length-1); i++) {
                if(i == 0 && data.charAt(i) == '.') {
                    fltFlag = false;
                    retArray.push(true);
                } else {
                    if(data.charAt(i) == '.' && fltFlag == true) {
                        retArray.push(true);
                        fltFlag = false;
                    } else {
                        if(isNumeric(data.charAt(i))) {
                            retArray.push(true);
                        } else {
                            retArray.push(false);
                        }
                    }

                }
            }
        }

        if(jQuery.inArray(false, retArray) ==  -1) {
            return true;
        }
        return false;
    }

    function floatChecker(value) {
        var val = value;
        if(isNumeric(val)) {
            return true;
        } else {
            return false;
        }
    }

    function lenChecker(data, len) {
        var retdata = 0;
        var lencount = 0;
        data = toFixedVal(data);
        if(data.length > len) {
            lencount = (data.length - len);
            data = data.toString();
            data = data.slice(0, -lencount);
            retdata = parseFloat(data);
        } else {
            retdata = parseFloat(data);
        }

        return toFixedVal(retdata);
    }
    
    function parseSentenceForNumber(sentence) {
        var matches = sentence.replace(/,/g, '').match(/(\+|-)?((\d+(\.\d+)?)|(\.\d+))/);
        return matches && matches[0] || null;
    }

    function currencyConvert(data) {
        return data.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
    }

    var globaltotalpaidamount = 0;
    var globaltotalweaver = 0;
    var globaltotalfine = 0;
    function totalInfo() {
        var totalPaidAmount = 0;
        var totalWeaver = 0;
        var totalFine = 0;
        
        $('#feetypeList tr').each(function(index, value) {
            if($(this).children().eq(4).children().val() != '' && $(this).children().eq(4).children().val() != null && $(this).children().eq(4).children().val() != '.') {
                var paidamount = parseFloat($(this).children().eq(4).children().val());
                totalPaidAmount += paidamount;
            }

            if($(this).children().eq(5).children().val() != '' && $(this).children().eq(5).children().val() != null && $(this).children().eq(5).children().val() != '.') {
                var weaver = parseFloat($(this).children().eq(5).children().val());
                totalWeaver += weaver;
            }

            if($(this).children().eq(6).children().val() != '' && $(this).children().eq(6).children().val() != null && $(this).children().eq(6).children().val() != '.') {
                var fine = parseFloat($(this).children().eq(6).children().val());
                totalFine += fine;
            }
        });

        globaltotalpaidamount = totalPaidAmount;
        $('#totalPaidAmount').text(currencyConvert(totalPaidAmount)); 

        globaltotalweaver = totalWeaver;
        $('#totalWeaver').text(currencyConvert(totalWeaver));

        globaltotalfine = totalFine;
        $('#totalFine').text(currencyConvert(totalFine));
    }
    $(document).on('keyup', '.change-fine', function() {
        var fine = $(this).val();

        var dotandnumberstatus = false;
        var finestatus = false;

        if(dotAndNumber(fine)) {
            dotandnumberstatus = true;
        } else {
            dotandnumberstatus = false;
            $(this).val(parseSentenceForNumber(toFixedVal(fine)));
        }

        if(dotandnumberstatus) {
            if(fine.length > 15) {
                fine = lenChecker(fine, 15);
                $(this).val(fine);
                finestatus = true;
            } else {
                finestatus = true;
            }

            totalInfo();
        }
    });

    totalInfo();
</script>
