<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa iniicon-productpurchase"></i> <?=$this->lang->line('admin_panel_title')?></h3>


        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('admin_panel_title')?></li>
        </ol>
    </div><!-- /.box-header -->
    
    <div class="box-body">
        <div class="row">
            <div class="col-sm-3 col-xs-12">
                <div class="small-box bg-pink-light">
                    <div class="inner">
                        <h3 class="text-white"><?= $stats['available_credits'] ?? 0 ?></h3>
                        <p class="text-white">Available Credits</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-credit-card"></i>
                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="small-box bg-purple-light">
                    <div class="inner">
                        <h3 class="text-white"><?= $stats['total_clients'] ?? 0 ?></h3>
                        <p class="text-white">Total Clients</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="small-box bg-teal-light">
                    <div class="inner ">
                        <h3 class="text-white"><?= $stats['last_transaction'] ?? 'N/A' ?></h3>
                        <p class="text-white">Last Transaction</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-history"></i>
                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xs-12">
                <div class="small-box bg-blue-light">
                    <div class="inner">
                        <h3 class="text-white"><?= $stats['total_groups'] ?? 0 ?></h3>
                        <p class="text-white">Groups</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-object-group"></i>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-users"></i> Clients</h3>
    </div>
    <div class="box-body">
        <div id="hide-table">
            <table id="example1" class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Account ID</th>
                        <th>Username</th>
                        <th>User Type</th>
                        <th>Mobile</th>
                        <th>SMPP Active</th>
                        <th>Email</th>
                        <th>Balance</th>
                        <th>Update Credit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; foreach ($stats['clients'] as $client) : ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= $client['id'] ?></td>
                            <td><?= $client['username'] ?></td>
                            <td><?= $client['usertype'] ?></td>
                            <td><?= $client['mobile'] ?></td>
                            <td>
                                <?= $client['is_smpp_active'] ? '<span class="badge bg-success">Yes</span>' : '<span class="badge bg-danger">No</span>' ?>
                            </td>
                            <td><?= $client['email'] ?></td>
                            <td><?= $client['balance'] ?></td>
                            <td>
                                <button class="btn btn-success btn-smaller mrg" 
                                        onclick="openCreditsModal(<?= $client['id'] ?>, 'add', '<?= addslashes($client['username']) ?>')">
                                    <i class="fa fa-plus"></i>
                                </button>
                                <button class="btn btn-danger btn-smaller mrg" 
                                        onclick="openCreditsModal(<?= $client['id'] ?>, 'subtract', '<?= addslashes($client['username']) ?>')">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-exchange"></i> Transactions</h3>
    </div>
    <div class="box-body">
        <div id="hide-table">
            <table id="example1" class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Transaction ID</th>
                        <th>Credits</th>
                        <th>Credits Before</th>
                        <th>Credits After</th>
                        <th>Type</th>
                        <th>Product</th>
                        <th>Comments</th>
                        <th>Transaction Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; foreach ($stats['transactions'] as $transaction) : 
                        $history = $transaction['history'];
                    ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= $history['id'] ?></td>
                            <td><?= number_format($history['credits'], 2) ?></td>
                            <td><?= number_format($history['creditsBefore'], 2) ?></td>
                            <td><?= number_format($history['creditsAfter'], 2) ?></td>
                            <td>
                                <span class="badge <?= $history['type'] === 'CREDIT' ? 'bg-success' : 'bg-danger' ?>">
                                    <?= ucfirst(strtolower($history['type'])) ?>
                                </span>
                            </td>
                            <td><?= $history['product'] ?: 'N/A' ?></td>

                            <td>
                                <span 
                                    data-toggle="tooltip" 
                                    title="<?= htmlspecialchars($history['creditComments'], ENT_QUOTES) ?>"
                                    style="cursor: pointer;"
                                >
                                    <?= strlen($history['creditComments']) > 30 ? substr($history['creditComments'], 0, 30) . '...' : $history['creditComments'] ?>
                                </span>
                            </td>
                            <td><?= date('Y-m-d H:i:s', (int) ($history['addedTime'] / 1000)) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="modal fade" id="updateCreditsModal" tabindex="-1" aria-labelledby="updateCreditsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="updateCreditsModalLabel">Update Credits</h5>
            </div>
            <div class="modal-body">
                <form id="creditsForm">
                    <input type="hidden" id="clientUsername" name="client_username" readonly>
                    <input type="hidden" id="actionType" name="action">
                    <div class="mb-3">
                        <label for="clientId" class="form-label">Client ID</label>
                        <input type="text" class="form-control" id="clientId" name="client_id" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label for="amount" class="form-label">Number of Credits</label>
                        <input type="number" class="form-control" id="amount" name="amount" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="submitCreditsForm()">Submit</button>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view("mailandsms/settings"); ?>
<script>
    function openCreditsModal(clientId, action, clientUsername) {
      
        $('#clientId').val(clientId);
        $('#clientUsername').val(clientUsername);
        $('#actionType').val(action);

        const title = action === 'add' ? 'Add Credits' : 'Subtract Credits';
        $('#updateCreditsModalLabel').text(title);

        $('#updateCreditsModal').modal('show');
    }

    function submitCreditsForm() {
        const form = $('#creditsForm');
        const formData = form.serialize();

        $.ajax({
            url: "<?=base_url('smspanel/updateCredits')?>",
            type: 'POST',
            data: formData,
            success: function(response) {
                showToastr(response.message || 'Credits updated successfully!', 'success');
                location.reload();
            },
            error: function() {
                showToastr('Failed to update credits.', 'error');
            }
        });
    }

    $(document).ready(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

</script>