<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-camera"></i> <?=$this->lang->line('panel_title')?></h3>

        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('menu_student')?></li>
        </ol>
    </div>
    <style>
        video  {
        width: 200px;
        height: 200px;
        background: rgba(0,0,0,0.2);
        -webkit-transform: none; 
        transform: none;  
        }

        #canvas  {
        width: 200px;
        height: 200px;
        -webkit-transform: none; 
        transform: none;         
        }
        .flipped {
            transform: scaleX(-1);
            -webkit-transform: scaleX(-1);
        }
        .d-flex-custom {
        display: flex;
    }

    .flex-row-custom {
        flex-direction: row;
    }
        .col-8-custom {
        flex: 0 0 66.66667%;
        max-width: 66.66667%;
        }

        .col-4-custom {
            flex: 0 0 33.33333%;
            max-width: 33.33333%;
        }

        .col-2-custom {
            flex: 0 0 20%;
            max-width: 20%;
        }

        @media (min-width: 768px) {
            
        }

        @media (max-width: 767px) {
            .mob-class {
                padding-top:10px;
            }
        }

        #camera-stream {
            width: 200px;
            height: 200px;
            object-fit: cover; /* This ensures the video fills the container */
        }

    </style>

<div class="box-body">
    <div class="row">
        <div class="col-sm-5">
            <div class="box-body" style="border: 2px solid #F1F2F7">
                <div class="row text-center">
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="">
                            <b>Camera:</b><br>
                            <video id="camera-stream" class="border border-5 border-danger" playsinline autoplay></video>
                        </div>
                        <div class="">
                            <button disabled id="flip-btn" class="btn btn-sm btn-warning">
                                <i class="fa fa-rotate"> Flip</i>
                            </button>
                            <button id="capture-camera" class="btn btn-sm btn-primary">
                                <i class="fa fa-camera"> Capture</i>
                            </button>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12 mt-3">
                        <b>Output:</b>
                        <br>
                        <canvas id="canvas" class="bg-light shadow border border-5 border-success"></canvas>
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-6">
                        <label for="userType">User Type:</label>
                        <select id="userType" class="form-control" name="userType">
                            <option value="">Select User Type</option>
                            <option value="Student">Student</option>
                            <option value="Teacher">Teacher</option>
                            <option value="User">User</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <div id="registerNOField" style="display: none;">
                            <label for="registerNO">Register No:</label>
                            <input type="text" id="registerNO" class="form-control" placeholder="Register No">
                        </div>
                        <div id="staffNumberField" style="display: none;">
                            <label for="staffNumber">Teacher ID/User ID:</label>
                            <input type="text" id="staffNumber" class="form-control" placeholder="Staff Number">
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-6">
                        <button id="savePhoto" class="btn btn-sm btn-warning" disabled>Save Photo</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-7">
            <div class="nav-tabs-custom">
                <div class="tab-content">
                    <div id="all" class="tab-pane active">
                        <div id="hide-table">
                            <table id="example1" class="table table-striped table-bordered table-hover dataTable no-footer">
                                <thead>
                                    <tr>
                                        <th class="col-sm-1"><?=$this->lang->line('slno')?></th>
                                        <th class="col-sm-3"><?=$this->lang->line('student_name')?></th>
                                        <th class="col-sm-2"><?=$this->lang->line('user_type')?></th>
                                        <th class="col-sm-2"><?=$this->lang->line('student_adm')?></th>
                                        <?php if(permissionChecker('student_edit') || permissionChecker('student_delete') || permissionChecker('student_view')) { ?>
                                        <th class="col-sm-2"><?=$this->lang->line('action')?></th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($photos as $key => $student) { ?>
                                    <tr>
                                        <td data-title="<?=$this->lang->line('slno')?>"><?php echo $key+1; ?></td>
                                        <td data-title="<?=$this->lang->line('student_name')?>"><?php echo $student->name; ?></td>
                                        <td data-title="<?=$this->lang->line('user_type')?>"><?php echo $student->userType; ?></td>
                                        <td data-title="<?=$this->lang->line('student_studentID')?>"><?php echo $student->registerNO; ?></td>
                                        <?php if(permissionChecker('student_edit') || permissionChecker('student_delete') || permissionChecker('student_view')) { ?>
                                        <td data-title="<?=$this->lang->line('action')?>">
                                            <?php
                                                if(($siteinfos->school_year == $this->session->userdata('defaultschoolyearID')) || ($this->session->userdata('usertypeID') == 1)) {
                                                    echo btn_delete('studentids/delete/'.$student->registerNO, $this->lang->line('delete'));
                                                }
                                            ?>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('userType').addEventListener('change', function() {
        const userType = this.value;
        const registerNOField = document.getElementById('registerNOField');
        const staffNumberField = document.getElementById('staffNumberField');

        // Show/Hide fields based on user type
        registerNOField.style.display = userType === 'Student' ? 'block' : 'none';
        staffNumberField.style.display = (userType === 'Teacher' || userType === 'User') ? 'block' : 'none';
    });

</script>

</div>

<script type="module">
    const videoElement = document.getElementById('camera-stream');
    const flipButton = document.getElementById('flip-btn');
    const captureButton = document.getElementById('capture-camera');
    const saveButton = document.getElementById('savePhoto');
    const canvasElement = document.getElementById('canvas');
    const userTypeSelect = document.getElementById('userType');
    const registerNOInput = document.getElementById('registerNO');
    const staffNumberInput = document.getElementById('staffNumber');

    let stream = null;
    let shouldFaceUser = true;
    let imageData = null;

    async function initCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
        }
        const constraints = {
            audio: false,
            video: {
                width: { ideal: 200 },
                height: { ideal: 200 },
                aspectRatio: 1,
                facingMode: shouldFaceUser ? 'user' : 'environment'
            }
        };

        try {
            stream = await navigator.mediaDevices.getUserMedia(constraints);
            videoElement.srcObject = stream;
            videoElement.play();
            videoElement.style.objectFit = 'cover';
            flipButton.disabled = false;
        } catch (err) {
            console.error('Could not access the camera.', err);
        }
    }

    function flipCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            shouldFaceUser = !shouldFaceUser;
            initCamera();
        }
    }

    function captureImage() {
        const context = canvasElement.getContext('2d');
        const size = Math.min(videoElement.videoWidth, videoElement.videoHeight);
        canvasElement.width = canvasElement.height = size;
        
        const offsetX = (videoElement.videoWidth - size) / 2;
        const offsetY = (videoElement.videoHeight - size) / 2;
        context.drawImage(videoElement, offsetX, offsetY, size, size, 0, 0, size, size);
        
        imageData = canvasElement.toDataURL('image/png').split(',')[1];
        saveButton.removeAttribute('disabled');
    }

    flipButton.addEventListener('click', flipCamera);
    captureButton.addEventListener('click', captureImage);
    saveButton.addEventListener('click', () => {
        const userType = userTypeSelect.value;
        const identifier = userType === 'Student' ? registerNOInput.value : staffNumberInput.value;

        console.log('Sending image data:', { userType, identifier, imageData });

        $.ajax({
            type: 'POST',
            url: "<?=base_url('studentids/savephoto')?>",
            data: { userType: userType, identifier: identifier, imageData: imageData },
            dataType: 'json',
            success: function(data) {
                if(data.success == true) {
                        toastr["success"](data.message)
                        toastr.options = {
                            "closeButton": true,
                            "debug": false,
                            "newestOnTop": false,
                            "progressBar": false,
                            "positionClass": "toast-top-right",
                            "preventDuplicates": false,
                            "onclick": null,
                            "showDuration": "500",
                            "hideDuration": "500",
                            "timeOut": "5000",
                            "extendedTimeOut": "1000",
                            "showEasing": "swing",
                            "hideEasing": "linear",
                            "showMethod": "fadeIn",
                            "hideMethod": "fadeOut"
                        }
                        var table = $('#example1').DataTable();
                        table.clear().rows.add(data.photos.map(function(student) {
                        return [
                            student.studentidsID,
                            student.name,
                            student.userType,
                            student.registerNO,
                            '',
                        ];
                    })).draw();
                    canvas.getContext('2d').clearRect(0, 0, canvas.width, canvas.height);
                    document.getElementById('registerNO').value = '';
                        // table.clear().rows.add(data.photos).draw();

                        
                    } else {
                        toastr["error"](data.message)
                        toastr.options = {
                            "closeButton": true,
                            "debug": false,
                            "newestOnTop": false,
                            "progressBar": false,
                            "positionClass": "toast-top-right",
                            "preventDuplicates": false,
                            "onclick": null,
                            "showDuration": "500",
                            "hideDuration": "500",
                            "timeOut": "5000",
                            "extendedTimeOut": "1000",
                            "showEasing": "swing",
                            "hideEasing": "linear",
                            "showMethod": "fadeIn",
                            "hideMethod": "fadeOut"
                        }
                        canvas.getContext('2d').clearRect(0, 0, canvas.width, canvas.height);
                        document.getElementById('registerNO').value = '';
                    }
            }
        });
        
    });

    userTypeSelect.addEventListener('change', function() {
        registerNOInput.parentElement.style.display = this.value === 'Student' ? 'block' : 'none';
        staffNumberInput.parentElement.style.display = (this.value === 'Teacher' || this.value === 'User') ? 'block' : 'none';
    });

    initCamera();
</script>


