<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Automation extends Admin_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model("cron_m");
    }
    
    public function index() {
        $this->data['crons'] = $this->cron_m->getData();
        foreach($this->data['crons'] as &$cron) {
            $cron->notifications = $this->cron_m->get_cron_contacts($cron->id);
        }
        $this->data["subview"] = "crons/index";
        $this->load->view('_layout_main', $this->data);
    }

    public function update_cron_enabled() {
        $id = $this->input->post('id');
        $enabled = $this->input->post('enabled');
        if ($id !== null && $enabled !== null) {
            $this->cron_m->updateCron($id, ['enabled' => $enabled]);
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid request']);
        }
    }

    public function add_cron_contact() {
        $cron_id = $this->input->post('cron_id');
        $type = $this->input->post('contact_type');
        $value = $this->input->post('contact_value');
        if($cron_id && $type == 'usertype' && $value) {
            // Prevent duplicates
            $existing = $this->cron_m->get_cron_contacts($cron_id);
            foreach ($existing as $e) {
                if ($e->contact_type == 'usertype' && $e->contact_value == $value) {
                    echo json_encode(['success'=>false, 'message'=>'Already added.']); return;
                }
            }
            $this->cron_m->add_cron_contact($cron_id, $type, $value);
            echo json_encode(['success'=>true]);
        } else {
            echo json_encode(['success'=>false]);
        }
    }

    public function remove_cron_contact() {
        $id = $this->input->post('id');
        if($id) {
            $this->cron_m->remove_cron_contact($id);
            echo json_encode(['success'=>true]);
        } else {
            echo json_encode(['success'=>false]);
        }
    }
}