<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Backup extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	protected $_memoryLimit = '1024M';

	function __construct() {
		parent::__construct();
		$language = $this->session->userdata('lang');
        $this->load->model("teacher_m");
        $this->load->model("parents_m");
        $this->load->model("student_m");
        $this->load->model("user_m");
        $this->load->model("book_m");
		$this->lang->load('backup', $language);
	}

	public function index() {
		$this->data['headerassets'] = array(
            'css' => array(
                'assets/inilabs/themes/skooly/vendor/dropify/css/dropify.min.css',
            ),
            'js' => array(
                'assets/inilabs/themes/skooly/vendor/dropify/js/dropify.min.js',
            ),
        );
		ini_set('memory_limit', $this->_memoryLimit);
		if ($_POST) {
			if(config_item('demo') == FALSE) {
				$this->load->dbutil();
				$prefs = array(
					'format'    => 'zip',
	            	'filename'  => 'mybackup.sql'
	          	);
				$backup  = $this->dbutil->backup($prefs);
				$this->load->helper('download');
				force_download('mybackup.zip', $backup);
				redirect(base_url('backup/index'));
			} else {
				$this->session->set_flashdata('error', 'In demo backup module is disable!');
				redirect(base_url('backup/index'));
			}
		} else {
		    $this->data["subview"] = "backup/index";
		    $this->load->view('_layout_main', $this->data);
		}
	}

	public function create()
    {
        if (!permissionChecker('backup_add')) {
            $this->session->set_flashdata('error', 'You are not authorized!');
			redirect(base_url('backup/index'));
        }
		ini_set('memory_limit', $this->_memoryLimit);
        $this->load->dbutil();
        $options = array(
            'format' => 'zip',
            'add_drop' => true,
            'add_insert' => true,
            'filename' => 'DB-backup_' . date('Y-m-d_H-i'),
        );
		
		$backupFolder = FCPATH . 'uploads/db_backup';
		if (!is_dir($backupFolder)) {
			if (!mkdir($backupFolder, 0777, true)) {
				$this->session->set_flashdata('error', 'Failed to create backup folder');
				redirect(base_url('backup'));
				return;
			}
		}
        $backup = $this->dbutil->backup($options);
        if (!write_file($backupFolder.'/DB-backup_' . date('Y-m-d_H-i') . '.zip', $backup)) {
            $this->session->set_flashdata('error', 'Database Backup Failed');
        } else {
			$this->session->set_flashdata('success', 'Database Backup completed');
        }
        redirect(base_url('backup'));
    }

	public function download()
    {
        $file = urldecode($this->input->get('file'));
        if(preg_match('/^[^.][-a-z0-9_.]+[a-z]$/i', $file)) {
            $this->data = file_get_contents('./uploads/db_backup/' . $file);
            force_download($file, $this->data);
        }
        redirect(base_url('backup'));
    }

    public function delete($file)
    {
        if (!permissionChecker('backup_delete')) {
            $this->session->set_flashdata('error', 'You are not authorized!');
			redirect(base_url('backup/index'));
        }
        unlink('./uploads/db_backup/' . $file);
		$this->session->set_flashdata('success', 'Database Backup deleted successfully');
		redirect(base_url('backup'));
    }

    public function restore_file()
    {
        if (permissionChecker('backup_restore')) {
            $this->session->set_flashdata('error', 'You are not authorized!');
			redirect(base_url('backup/index'));
        }
		
		if (isset($_FILES["uploaded_file"]) && !empty($_FILES['uploaded_file']['name'])) {
			if (!is_dir('./uploads/db_temp/')) {
				if (!mkdir('./uploads/db_temp/', 0777, true)) {
					$this->session->set_flashdata('error', 'Failed to create DB temp folder');
					redirect(base_url('backup'));
					return;
				}
			}
            $this->load->helper('unzip');
            $config['upload_path'] = './uploads/db_temp/';
            $config['allowed_types'] = 'zip';
            $config['overwrite'] = true;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('uploaded_file')) {
                $error = $this->upload->display_errors('', ' ');
				$this->session->set_flashdata('error', $error);
                redirect(base_url('backup'));
            } else {
                $data = array('upload_data' => $this->upload->data());
                $backup = "uploads/db_temp/" . $data['upload_data']['file_name'];

            }
            if (!unzip($backup, "uploads/db_temp/", true, true)) {
				$this->session->set_flashdata('error', 'Backup Restore Error');
                redirect(base_url('backup'));
            } else {
                $this->load->dbforge();
                $backup = str_replace('.zip', '', $backup);
                $file_content = file_get_contents($backup . ".sql");
                $this->db->query('USE ' . $this->db->database . ';');
                foreach (explode(";\n", $file_content) as $sql) {
                    $sql = trim($sql);
                    if ($sql) {
                        $this->db->query($sql);
                    }
                }
				$this->session->set_flashdata('success', "Backup Restore Successfully");
            }
            unlink($backup . '.sql');
            unlink($backup . '.zip');
        } else {
			$this->session->set_flashdata('error', 'An error occurred!');
            
        }
		redirect(base_url('backup'));
    }
}