<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

// Use Composer's mPDF
use Mpdf\Mpdf;

class idcardreport extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('usertype_m');
        $this->load->model('classes_m');
        $this->load->model('section_m');
        $this->load->model('user_m');
        $this->load->model('systemadmin_m');
        $this->load->model('studentrelation_m');
        $this->load->model('teacher_m');
        $this->load->model('schoolyear_m');
        $language = $this->session->userdata('lang');
        $this->lang->load('idcardreport', $language);
    }

    public function pdf() {
        if(permissionChecker('idcardreport')) {
            // Get parameters from URI or POST as needed
            $usertypeID   = htmlentities(escapeString($this->uri->segment(3)));
            $classesID    = htmlentities(escapeString($this->uri->segment(4)));
            $sectionID    = htmlentities(escapeString($this->uri->segment(5)));
            $userID       = htmlentities(escapeString($this->uri->segment(6)));
            $type         = htmlentities(escapeString($this->uri->segment(7)));
            $background   = htmlentities(escapeString($this->uri->segment(8)));
            $exclude      = htmlentities(escapeString($this->uri->segment(9)));
            $schoolyearID = $this->session->userdata('defaultschoolyearID');

            // Build data array
            $this->data['usertypeID']  = $usertypeID;
            $this->data['classesID']   = $classesID;
            $this->data['sectionID']   = $sectionID;
            $this->data['userID']      = $userID;
            $this->data['type']        = $type;
            $this->data['background']  = $background;
            $this->data['schoolyear']  = $this->schoolyear_m->get_single_schoolyear(array('schoolyearID'=>$schoolyearID));
            $this->data['classes']     = pluck($this->classes_m->general_get_classes(),'classes','classesID');
            $this->data['sections']    = pluck($this->section_m->general_get_section(),'section','sectionID');
            $array['usertypeID'] = $usertypeID;
            $array['classesID'] = $classesID;
            $array['sectionID'] = $sectionID;
            $array['userID'] = $userID;
            $array['exclude'] = $exclude;
            $this->data['idcards']     = $this->queryArray($array);

            // Render HTML from view
            $html = $this->load->view('report/idcard/IdcardReportPDF', $this->data, TRUE);

            // Load Composer autoloader and create mPDF instance
            require_once FCPATH . 'vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['format' => 'A4']);

            // Load and apply CSS
            $stylesheet = file_get_contents(FCPATH . 'assets/pdf/LTR/IdcardReportPDF.css');
            $mpdf->WriteHTML($stylesheet, \Mpdf\HTMLParserMode::HEADER_CSS);

            // Write HTML
            $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);

            // Output to browser
            $mpdf->Output('ID_Cards.pdf', 'I');
        } else {
            $this->data["subview"] = "error";
            $this->load->view('_layout_main', $this->data);
        }
    }

    // Utility function to build user query arrays as in your original code
    private function queryArray($posts) {
        $usertypeID = $posts['usertypeID'];
        $classesID  = $posts['classesID'];
        $sectionID  = $posts['sectionID'];
        $userID     = $posts['userID'];
        $exclude    = $posts['exclude'];

        $queryArray = [];
        if($usertypeID == 1) {
            if($userID > 0) {
                $queryArray['systemadminID'] = $userID;
            }
            $users = $this->systemadmin_m->get_order_by_systemadmin($queryArray);
        } elseif($usertypeID == 2) {
            if($userID > 0) {
                $queryArray['teacherID'] = $userID;
            }
            $users = $this->teacher_m->general_get_order_by_teacher($queryArray);
        } elseif($usertypeID == 3) {
            $queryArray['srschoolyearID'] = $this->session->userdata('defaultschoolyearID');
            if($classesID != 0){
                $queryArray['srclassesID'] = $classesID;
            }
            if($sectionID > 0) {
                $queryArray['srsectionID'] = $sectionID;
            }
            if($userID > 0) {
                $queryArray['srstudentID'] = $userID;
            }
            if($exclude > 1) {
                $queryArray['id_issued'] = $exclude ==2? 1 : 0;
            }
            $users = $this->studentrelation_m->general_get_order_by_student($queryArray);
        } elseif($usertypeID == 4) {
            $users = [];
        } else {
            $queryArray['usertypeID'] = $usertypeID;
            if($userID > 0) {
                $queryArray['userID'] = $userID;
            }
            $users = $this->user_m->get_order_by_user($queryArray);
        }
        return $users;
    }
}