<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Studentleaveout extends Admin_Controller
{
    /*
    | -----------------------------------------------------
    | PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
    | -----------------------------------------------------
    | AUTHOR:			INILABS TEAM
    | -----------------------------------------------------
    | EMAIL:			info@inilabs.net
    | -----------------------------------------------------
    | COPYRIGHT:		RESERVED BY INILABS IT
    | -----------------------------------------------------
    | WEBSITE:			http://inilabs.net
    | -----------------------------------------------------
    */
    function __construct() {
        parent::__construct();
        $this->load->model("studentleaveout_m");
        $this->load->model("classes_m");
        $this->load->model("systemadmin_m");
        $this->load->model("teacher_m");
        $this->load->model("student_m");
        $this->load->model("parents_m");
        $this->load->model("studentrelation_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('leaveapply', $language);
    }

    protected function rules() {
        $rules = array(
            array(
                'field' => 'classesID',
                'label' => $this->lang->line("leaveapply_class"),
                'rules' => 'trim|required|xss_clean|numeric|max_length[11]',
            ),
            array(
                'field' => 'studentID',
                'label' => $this->lang->line("leaveapply_student"),
                'rules' => 'trim|required|xss_clean|numeric|max_length[11]',
            ),
            array(
                'field' => 'reason',
                'label' => $this->lang->line("leaveapply_reason"),
                'rules' => 'trim|required|xss_clean|max_length[10000]',
            )
        );
        return $rules;
    }

    public function index() {
        if(($this->data['siteinfos']->school_year == $this->session->userdata('defaultschoolyearID')) || ($this->session->userdata('usertypeID') == 1)) {
            $this->data['headerassets'] = array(
                'css' => array(
                    'assets/datepicker/datepicker.css',
                    'assets/daterangepicker/daterangepicker.css',
                    'assets/editor/jquery-te-1.4.0.css',
                    'assets/select2/css/select2.css',
                    'assets/select2/css/select2-bootstrap.css',
                ),
                'js'  => array(
                    'assets/datepicker/datepicker.js',
                    'assets/editor/jquery-te-1.4.0.min.js',
                    'assets/daterangepicker/moment.min.js',
                    'assets/daterangepicker/daterangepicker.js',
                    'assets/select2/select2.js'
                ),
            );

            $schoolyearID = $this->session->userdata("defaultschoolyearID");
            $usertypeID = $this->session->userdata("usertypeID");
            $this->data['myleaveapplications'] = $this->studentleaveout_m->get_order_by_leaveapplication(array('schoolyearID' => $schoolyearID, 'create_usertypeID' => $this->session->userdata('usertypeID'), 'create_userID' => $this->session->userdata('loginuserID')));
            $this->data['classes'] = $this->classes_m->general_get_classes();
            $this->data['userName'] = getStudentObjectWithStudentRelation($schoolyearID);
            $this->data['students'] = [];

            if ($_POST) {
                $rules = $this->rules();
                $this->form_validation->set_rules($rules);
                if ($this->form_validation->run() == FALSE) {
                    $this->data["subview"]         = "studentleaveout/index";
                    $this->load->view('_layout_main', $this->data);
                } else {
                    $explode            = explode('-', $this->input->post("leave_schedule"));

                    $array["from_date"] = date("Y-m-d", strtotime(trim($explode[0])));
                    $array["to_date"] = date("Y-m-d", strtotime(trim($explode[1])));
                    $array["studentID"]                 = $this->input->post("studentID");
                    $array["classID"]                   = $this->input->post("classesID");
                    $array["reason"]                    = $this->input->post("reason");
                    $array["from_time"]                 = date('H:i:s');
                    $array["to_time"]                   = date('H:i:s');
                    $array["create_date"]               = date("Y-m-d H:i:s");
                    $array["modify_date"]               = date("Y-m-d H:i:s");
                    $array["create_userID"]             = $this->session->userdata('loginuserID');
                    $array["create_usertypeID"]         = $this->session->userdata('usertypeID');
                    $array['schoolyearID']              = $schoolyearID;

                    $this->studentleaveout_m->insert_leaveapplication($array);
                    $this->session->set_flashdata('success', $this->lang->line('menu_success'));
                    redirect(base_url("studentleaveout/index"));
                }
            } else {
                $this->data["subview"] = "studentleaveout/index";
                $this->load->view('_layout_main', $this->data);
            }
        } else {
            $this->data["subview"] = "error";
            $this->load->view('_layout_main', $this->data);
        }
    }

    public function view() {
        $id = htmlentities(escapeString($this->uri->segment(3)));
        if ((int)$id) {
            $schoolyearID  = $this->session->userdata("defaultschoolyearID");
            $this->data['usertypes'] = pluck($this->usertype_m->get_usertype(),'usertype','usertypeID');
            $this->data['leaveapply'] = $this->studentleaveout_m->get_single_leaveapplication(array('studentleaveoutID' => $id, 'schoolyearID' => $schoolyearID));

            if(customCompute($this->data['leaveapply'])) {
                if(($this->data['leaveapply']->create_userID == $this->session->userdata('loginuserID'))) {
                    $this->data['applicant']= getObjectByUserTypeIDAndUserID(3, $this->data['leaveapply']->create_userID, $schoolyearID);

                    $this->data["subview"] = "studentleaveout/view";
                    $this->load->view('_layout_main', $this->data);
                } else {
                    $this->data["subview"] = "error";
                    $this->load->view('_layout_main', $this->data);
                }
            } else {
                $this->data["subview"] = "error";
                $this->load->view('_layout_main', $this->data);
            }
        } else {
            $this->data["subview"] = "error";
            $this->load->view('_layout_main', $this->data);
        }
    }

    public function delete() {
        if(($this->data['siteinfos']->school_year == $this->session->userdata('defaultschoolyearID')) || ($this->session->userdata('usertypeID') == 1)) {
            $id = htmlentities(escapeString($this->uri->segment(3)));
            if((int)$id) {
                $schoolyearID      = $this->session->userdata("defaultschoolyearID");
                $leaveapplication = $this->studentleaveout_m->get_single_leaveapplication(array('studentleaveoutID' => $id, 'schoolyearID' => $schoolyearID, 'create_usertypeID' => $this->session->userdata('usertypeID'), 'create_userID' => $this->session->userdata('loginuserID')));
                if (customCompute($leaveapplication)) {
                    if($leaveapplication->status == NULL) {
                        if($leaveapplication->create_userID == $this->session->userdata('loginuserID') && $leaveapplication->create_usertypeID == $this->session->userdata('usertypeID')) {
                           
                            $this->studentleaveout_m->delete_leaveapplication($id);
                            $this->session->set_flashdata('success', $this->lang->line('menu_success'));
                            redirect(base_url("studentleaveout/index"));
                        } else {
                            redirect(base_url("studentleaveout/index"));
                        }
                    } else {
                        redirect(base_url("studentleaveout/index"));
                    }
                } else {
                    redirect(base_url("studentleaveout/index"));
                }
            } else {
                redirect(base_url("studentleaveout/index"));
            }
        } else {
            $this->data["subview"] = "error";
            $this->load->view('_layout_main', $this->data);
        }
    }



}