<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CelCom {

    protected $authKey;
    protected $senderID;
    protected $partnerID;

    public function __construct() {
        $this->ci = &get_instance();
        $this->ci->load->model('smssettings_m');

        $celcom_bind = [];
        $get_celcoms = $this->ci->smssettings_m->get_order_by_celcom();
        foreach ($get_celcoms as $key => $get_celcom) {
            $celcom_bind[$get_celcom->field_names] = $get_celcom->field_values;
        }
        $this->authKey = $celcom_bind['celcom_authKey'];
        $this->senderID = $celcom_bind['celcom_senderID'];
        $this->partnerID = $celcom_bind['celcom_partnerID'];

        //  exit("" . $this->partnerID . ",   " . $this->authKey . ",  " . $this->senderID);
    }
    public function send($phone, $sms) {


        //$this->logThis('INFO', "About to send sms to $phone and message $sms ");
        $curl = curl_init();

        $url = 'https://isms.celcomafrica.com/api/services/sendsms/?apikey=' . $this->authKey . '&partnerID=' . $this->partnerID . '&message=' . urlencode($sms) . '&shortcode=' . $this->senderID . '&mobile=' . $phone . '&timeToSend=' . urlencode(date('Y-m-d H:i:s'));

        // $this->logThis('INFO', "Url to invoke $url");

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: PHPSESSID=6us2eiq36hb133dfju55kfbill'
            ),
        ));

        $response = curl_exec($curl);
        // $this->logThis('INFO', "Response from Gateway" . $response);
        //Print error if any
        if (curl_errno($curl)) {
            echo 'error:' . curl_error($curl);
            // $this->logThis('ERROR', "error sending sms " . curl_error($curl));
        }

        curl_close($curl);

        if ($response) {
            // $this->logThis('INFO', "SMS successfully sent to $phone");
            return true;
        }
        return false;
    }
    public function sendd($phone, $sms) {      

        $finalURL = "https://isms.celcomafrica.com/api/services/sendsms/?apikey=" .
            urlencode($this->authKey) . "&partnerID=" . urlencode($this->partnerID) . "&message=" .
            urlencode($sms) . "&shortcode=$this->senderID&mobile=$phone";

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $finalURL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        // //$this->logThis('INFO', "About to send sms to $phone and message $sms ");
        // $url = "https://isms.celcomafrica.com/api/services/sendsms/?apikey=" .
        // urlencode($this->authKey) . "&partnerID=" . urlencode($this->partnerID) . "&message=" .
        // urlencode($sms) . "&shortcode=$this->senderID&mobile=$phone";
        
        // // $url = 'https://isms.celcomafrica.com/api/services/sendsms/?apikey=' . $this->authKey . '&partnerID=' . $this->partnerID . '&message=' . urlencode($sms) . '&shortcode=' . $this->senderID . '&mobile=' . $phone . '&timeToSend=' . urlencode(date('Y-m-d H:i:s'));
        
        // // $this->logThis('INFO', "Url to invoke $url");
        // $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // $response = curl_exec($ch);

        // $curl = curl_init();
        

        // // curl_setopt_array($curl, array(
        // //     CURLOPT_URL => $url,
        // //     CURLOPT_RETURNTRANSFER => true,
        // //     CURLOPT_ENCODING => '',
        // //     CURLOPT_MAXREDIRS => 10,
        // //     CURLOPT_TIMEOUT => 0,
        // //     CURLOPT_FOLLOWLOCATION => true,
        // //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        // //     CURLOPT_CUSTOMREQUEST => 'GET',
        // //     CURLOPT_HTTPHEADER => array(
        // //         'Content-Type: application/json',
        // //         'Cookie: PHPSESSID=6us2eiq36hb133dfju55kfbill'
        // //     ),
        // // ));

        // // $response = curl_exec($curl);
        // // $this->logThis('INFO', "Response from Gateway" . $response);
        // //Print error if any
        if (curl_errno($ch)) {
            echo 'error:' . curl_error($ch);
            // $this->logThis('ERROR', "error sending sms " . curl_error($curl));
        }

        // // curl_close($ch);

        if ($response) {
            // $this->logThis('INFO', "SMS successfully sent to $phone");
            return true;
        }
        return false;
    }

    public function logThis($LEVEL, $logThis) {

        $logFile = "";
        $logLevel = "";
        switch ($LEVEL) {
            case "INFO":
                $logFile = "logs/kuc/info.log";
                $logLevel = "INFO";
                break;
            case "ERROR":
                $logFile = "/var/www/logs/kuc/error.log";
                $logLevel = "ERROR";
                break;

            default:
                $logFile = "/var/www/logs/kuc/info.log";
                $logLevel = "DEFAULT";
        }

        $e = new \Exception();
        $trace = $e->getTrace();
//position 0 would be the line that called this function so we ignore it
        $last_call = isset($trace[1]) ? $trace[1] : array();
        $lineArr = $trace[0];

        $function = isset($last_call['function']) ? $last_call['function'] . "()|" : "";
        $line = isset($lineArr['line']) ? $lineArr['line'] . "|" : "";
        $file = isset($lineArr['file']) ? $lineArr['file'] . "|" : "";

        $remote_ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] . "|" : "";
        $date = date("Y-m-d H:i:s");
        $string = $date . "|$logLevel|$file$function$remote_ip$line" . $logThis . "\n";
        file_put_contents($logFile, $string, FILE_APPEND);
    }

}
