<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Updatechecker
{
    /**
     * CUSTOM IMPLEMENTATION: Replaces the original network-based license check 
     * with a local database validation using the setting_m model.
     * It mimics the setup of the original _dataMaker method for compatibility.
     *
     * @param array $array Optional array (ignored in this custom implementation)
     * @param bool $arrayMerge Optional merge flag. MUST be true for local check to run.
     * @return object Returns a status object (true for valid, false for invalid).
     */
    public function verifyValidUser( $array = [], $arrayMerge = true )
    {
        // 1. Define your SECRET, static license code here.
        $SECRET_MASTER_CODE = '0721368123'; 

        $CI =& get_instance();
        $user_purchase_code = '';

        // 2. Replicate the original logic to fetch the purchase code
        if ( $arrayMerge ) {
            $CI->load->model('setting_m');
            $setting = $CI->setting_m->get_setting();
            
            if ( customCompute($setting) ) {
                // Ensure field exists and is trimmed
                $user_purchase_code = isset($setting->purchase_code) ? trim($setting->purchase_code) : '';
            }
        }
        
        // 3. Perform the Local Validation
        // Cast both to string to guarantee a clean type match for the strict comparison (===)
        if ( !empty($user_purchase_code) && (string)$user_purchase_code === (string)$SECRET_MASTER_CODE ) {
            $status  = true;
            $message = 'Local License Check: VALID.';
        } else {
            $status  = false;
            $message = 'Local License Check: INVALID. Please enter the correct purchase code.';
        }

        // 4. Return the result object
        return (object) [
            'status'  => $status,
            'message' => $message,
            'for'     => 'internal_license',
        ];
    }

    /**
     * Retained public method for IP detection.
     */
    public function getUserIP()
    {
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if ( filter_var($client, FILTER_VALIDATE_IP) ) {
            $ip = $client;
        } elseif ( filter_var($forward, FILTER_VALIDATE_IP) ) {
            $ip = $forward;
        } else {
            $ip = ( $remote == "::1" ? "127.0.0.1" : $remote );
        }
        return $ip;
    }

    /**
     * RESTORED METHOD: Used by Login.php (and possibly others) for logging user agent details.
     * The remaining private methods (_dataMaker, _apiCurl, etc.) which were used for 
     * network communication are safely REMOVED.
     */
    public function getBrowser()
    {
        // ... (The full getBrowser logic, as restored previously) ...
        // Since you did not include the full logic for getBrowser in your last snippet, 
        // ensure you keep the full working getBrowser() function from the previous step here.
        
        $u_agent  = $_SERVER['HTTP_USER_AGENT'];
        $bname    = 'Unknown';
        $platform = 'Unknown';
        // ... (rest of the logic including customCompute) ...
        
        if ( !function_exists('customCompute') ) {
            function customCompute($array) {
                return (is_array($array) || is_object($array)) ? count($array) : 0;
            }
        }

        // NOTE: If you are encountering an error with customCompute, 
        // you should replace all instances of customCompute() inside this method with count().

        // ... (Full browser detection logic here) ...
        return (object) [
            // ... (Browser object properties) ...
        ];
    }
    
    // NOTE: All private methods (_dataMaker, _apiCurl, _activeServer, _checkInternetConnection)
    // must be deleted from the file now.
}