<?php

class Skooly
{
    private static ?SmsGatewayInterface $gateway = null;

    public static function init(array $config, string $gatewayName = 'skooly'): void
    {
        switch ($gatewayName) {
            case 'hostpinacle':
                self::$gateway = new HostpinacleGateway();
                break;

            case 'skooly':
                self::$gateway = new SkoolyGateway();
                break;

            default:
                throw new Exception("Unsupported gateway: {$gatewayName}");
        }

        self::$gateway->init($config);
    }

    public static function send(string $recipient, string $message, string $name='', bool $group = false)
    {
        if (self::$gateway === null) {
            throw new Exception("SMS Gateway not initialized. Call Skooly::init first.");
        }

        return self::$gateway->send($recipient, $message, $name, $group);
    }

    public static function sendBulk(array $recipients): bool
    {
        if (self::$gateway === null) {
            throw new Exception("SMS Gateway not initialized. Call Skooly::init first.");
        }

        return self::$gateway->sendBulk($recipients);
    }

    public static function getBalance(): float
    {
        if (self::$gateway === null) {
            throw new Exception("SMS Gateway not initialized. Call Skooly::init first.");
        }

        return self::$gateway->getBalance();
    }
}
