<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Studentids_m extends MY_Model {

    protected $_table_name = 'studentids';
    protected $_primary_key = 'studentids.studentidsID';
    protected $_primary_filter = 'intval';
    protected $_order_by = "create_date asc";

    function __construct() {
        parent::__construct();
    }
    public function get_last_admission_number() {
        $this->db->select('registerNO');
        $this->db->from('student');
        $this->db->order_by('studentID', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $result = $query->row();
            return $result->registerNO;
        } else {
            return false;
        }
    }

    public function getData() {
        $this->db->select('*');
        $this->db->from('studentids');
        // $this->db->join('student', 'studentids.registerNO = student.registerNO', 'left');
        // $this->db->order_by('studentids.studentidsID', 'desc');
        $this->db->limit(10);
        $query = $this->db->get();
        return $query->result();
    }

    public function getStudent($id) {
        try {

            $this->db->select('*');
            $this->db->from("studentids");
            $this->db->where('registerNO', $id);
            $query = $this->db->get();

            $response = $query->result();

            return $response;
        } catch (PDOException $ex) {
            $response = "Error :" . $ex->getMessage();
        }

        return $response;
    }
    

    public function insert_photo($array)
    {
        return parent::insert($array);
    }

    public function delete_student($id) {
        $this->db->delete('studentids', array('registerNO' => $id));
    }

    public function update_data($data, $id = NULL) {
		parent::update($data, $id);
		return $id;
	}
}