<?php if ( !defined('BASEPATH') ) {
    exit('No direct script access allowed');
}

    class Wallettransactions_m extends MY_Model
    {

        protected $_table_name = 'wallet_transactions';
        protected $_primary_key = 'id';
        protected $_primary_filter = 'intval';
        protected $_order_by = "id";

        public function __construct()
        {
            parent::__construct();
        }

        public function getTrx($id){
            $this->db->select('*');
            $this->db->from('wallet_transactions');
            $this->db->where('studentID', $id);
            
            $this->db->order_by('id desc');
            $query = $this->db->get();

            return $query->result();
        }

        public function getLastTrx($id){
            $this->db->select('*');
            $this->db->from('wallet_transactions');
            $this->db->where('studentID', $id);
            $this->db->order_by('id', 'DESC');
            $this->db->limit(1);
            $query = $this->db->get();
            $last_transaction = $query->row();

            return $last_transaction;

        }

        public function totalInvoices($id){
            $this->db->select('COUNT(*) as total_invoices');
            $this->db->from('maininvoice');
            $this->db->where('maininvoicestudentID', $id);
            $this->db->where('maininvoicedeleted_at', 1);
            $this->db->where('maininvoicestatus !=', 2);
            $query = $this->db->get();
            $result = $query->row_array();

            $total_invoices = $result['total_invoices'];

            return $total_invoices;

        }

        public function getData($array = null){
        $this->db->select('wallet_transactions.*, student.name');
        $this->db->from('wallet_transactions');
        $this->db->join('student', 'student.studentID = wallet_transactions.studentID', 'left');
        
        if ( customCompute($array) ) {
            // Handle schoolyearID specifically to avoid ambiguity
            if (isset($array['schoolyearID'])) {
                $this->db->where('wallet_transactions.schoolyearID', $array['schoolyearID']);
                unset($array['schoolyearID']); // Remove it from the array to avoid duplicate where
            }
            
            // Apply remaining where conditions
            if (customCompute($array)) {
                $this->db->where($array);
            }
        }
        
        $this->db->order_by('id desc');
        $query = $this->db->get();
        $wallets = $query->result();
    
        return $wallets;
    }

        public function getDatas($array = null){
        $this->db->select('wallet_transactions.*, student.name, student.registerNO');
        $this->db->from('wallet_transactions');
        $this->db->join('student', 'student.studentID = wallet_transactions.studentID', 'left');
        
        if ( customCompute($array) ) {
            // Handle schoolyearID specifically to avoid ambiguity
            if (isset($array['schoolyearID'])) {
                $this->db->where('wallet_transactions.schoolyearID', $array['schoolyearID']);
                unset($array['schoolyearID']); // Remove it from the array to avoid duplicate where
            }
            
            // Apply remaining where conditions
            if (customCompute($array)) {
                $this->db->where($array);
            }
        }
        
        $this->db->where('trx_type', 'credit');
        $this->db->limit(8);
        $this->db->order_by('id desc');
        $query = $this->db->get();
        $wallets = $query->result();
    
        return $wallets;
    }
        public function getMpesaData($studentID){
            $this->db->select('*');
            $this->db->from('mpesa_logs');
            $this->db->where('BillRefNumber', $studentID);
            $query = $this->db->get();
            $wallets = $query->result();

            return $wallets;
        }

        function insert_wallet($array) {
            $id = parent::insert($array);
            return $id;
        }

        public function getDatastudent($array = null, $studentID = null)
    {
        $this->db->select('wallet_transactions.*, student.name, student.registerNO');
        $this->db->from('wallet_transactions');
        $this->db->join('student', 'student.studentID = wallet_transactions.studentID', 'left');
        
        if (customCompute($array)) {
            // Handle schoolyearID specifically to avoid ambiguity
            if (isset($array['schoolyearID'])) {
                $this->db->where('wallet_transactions.schoolyearID', $array['schoolyearID']);
                unset($array['schoolyearID']); // Remove it from the array to avoid duplicate where
            }
            
            // Apply remaining where conditions
            if (customCompute($array)) {
                $this->db->where($array);
            }
        }
        
        $this->db->where('trx_type', 'credit');
        
        if ($studentID !== null) {
            $this->db->where('wallet_transactions.studentID', $studentID);
        }
        
        $this->db->limit(8);
        $this->db->order_by('id desc');
        $query = $this->db->get();
        $wallets = $query->result();
    
        return $wallets;
    }


    }