
<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-download"></i> <?=$this->lang->line('panel_title')?></h3>
       
        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('menu_backup')?></li>
        </ol>
    </div><!-- /.box-header -->
    <!-- form start -->
    <div class="box-body">
    <div class="row">
        <div class="col-sm-12">
        <div class="tabs-custom">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#database_backup" data-toggle="tab">
                        <i class="fa fa-database"></i> <?=$this->lang->line('database_list') ?>
                    </a>
                </li>
                <!-- <?php if(permissionChecker('backup_restore', 'is_add')) {?> 
                        
            <?php } ?>  -->
                <li>
                    <a href="#restore_database" data-toggle="tab">
                        <i class="fa fa-upload"></i> <?=$this->lang->line('restore_database') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane box active" id="database_backup" style="padding:10px";>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="pull-right mb-md">
                                <a href="<?php echo base_url('backup/create'); ?>" class="btn btn-default btn-sm">
                                    <i class="fa fa-paste"></i> <?=$this->lang->line('create_backup') ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    <table id="example1" class="table table-bordered table-hover table-export">
                        <thead>
                            <tr>
                                <th width="60">#</th>
                                <th><?=$this->lang->line('backup')?></th>
                                <th><?=$this->lang->line('backup_size')?></th>
                                <th><?=$this->lang->line('date')?></th>
                                <th><?=$this->lang->line('action')?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
						$count = 1;
						$files = is_dir(FCPATH.'/uploads/db_backup/')? get_filenames(FCPATH.'/uploads/db_backup/') : [];
						sort($files, SORT_NATURAL | SORT_FLAG_CASE);
						if (!empty($files)){
							foreach ($files as $file):
								$ext = pathinfo($file, PATHINFO_EXTENSION);
								if ($ext != "zip") continue;
								$_fullpath = FCPATH.'/uploads/db_backup/'.$file;
						?>
                            <tr>
                                <td><?php echo $count++;?></td>
                                <td><?php echo $file?></td>
                                <td><?php echo bytesToSize($_fullpath);?></td>
                                <td><?php
							    echo  date('d-m-Y', filectime($_fullpath)) . ", " . date('g:i A', filectime($_fullpath));
							?></td>
                                <td>
                                    <!-- download link -->
                                    <a href="<?=base_url('backup/download?file='.$file) ?>"
                                        class="btn btn-primary">
                                        <i class="fa fa-download"></i> <?=$this->lang->line('download')?>
                                    </a>
                                    <?php if(permissionChecker('backup_delete')) { ?>
                                    <!-- deletion link -->
                                    <?php echo btn_delete('backup/delete/' . $file, $this->lang->line('delete'));?>
                                    <?php } ?>
                                </td>
                            </tr>
                            <?php endforeach; }; ?>
                        </tbody>
                    </table>
                </div>
                <!-- <?php if(permissionChecker('backup_restore', 'is_add')) { ?> -->
                    <!-- <?php } ?> -->
                <div class="tab-pane box" id="restore_database">
                    <form action="backup/restore_file" class="form-horizontal" enctype="multipart/form-data" role="form" method="post">
                        <div class="form-group mb-lg" style="padding:10px";>
                            <label class="col-md-3 control-label"><?=$this->lang->line('file_upload')?> <span
                                    class="required" aria-required="true">*</span></label>
                            <div class="col-md-7">
                                <input type="file" name="uploaded_file" class="dropify" data-height="140"
                                    data-allowed-file-extensions="zip" />
                                <span class="error"></span>
                            </div>
                        </div>
                        <footer class="panel-footer">
                            <div class="row">
                                <div class="col-md-2 col-sm-offset-3">
                                    <button type="submit" class="btn btn-default btn-block"
                                        data-loading-text="<i class='fa fa-spinner fa-spin'></i> Processing">
                                        <i class="fa fa-cloud-upload-alt"></i> <?=$this->lang->line('upload')?> SQL
                                    </button>
                                </div>
                            </div>
                        </footer>
                    </form>
                </div>
                
            </div>
        </div>
    </div><!-- Body -->
    </div>
    </div>
</div><!-- /.box -->
<script>
    $(document).ready(function(){
        $('.dropify').dropify();
    });
</script>