<!-- TOPBAR WRAPPER -->
<div class="aiz-topbar px-15px px-lg-25px d-flex align-items-stretch justify-content-between">
  <!-- Left: Nav toggler -->
  <div class="d-flex">
    <div class="aiz-topbar-nav-toggler d-flex align-items-center justify-content-start ml-0 mr-2" data-toggle="aiz-mobile-nav">
      <a class="btn btn-topbar nav-toggler has-transition btn-icon p-0 d-flex align-items-center"
         href="javascript:void(0)"
         data-toggle="tooltip"
         data-placement="bottom"
         title="<?= $this->lang->line('sidebar_toggle') ?>">
        <!-- SVG icon here -->
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
          <g transform="translate(0 16) rotate(-90)">
            <rect width="2" height="7" rx="1" fill="currentColor"/>
            <rect width="2" height="11" rx="1" transform="translate(14)" fill="currentColor"/>
            <rect width="2" height="16" rx="1" transform="translate(7)" fill="currentColor"/>
          </g>
        </svg>
      </a>
    </div>
  </div>

  <!-- Center: Logo, School Name, Add New Button -->
  <div class="d-flex justify-content-between align-items-stretch flex-grow-1">
    <div class="d-flex align-items-center">
      <div class="aiz-topbar-item mr-3 d-flex align-items-center">
        <?php if(customCompute($siteinfos->photo)): ?>
          <span class="site-logo-wrapper">
            <img class="site-logo" src="<?= base_url('uploads/images/'.$siteinfos->photo) ?>" alt="Logo" />
          </span>
        <?php endif; ?>
        <h2 class="site-name mb-0 site-name-full"><?php echo get_setting('sname'); ?></h2>
        <h2 class="site-name mb-0 site-name-abbr"><?php echo get_setting('school_code'); ?></h2>
      </div>
      <div class="aiz-topbar-item d-none d-sm-block ml-2">
        <a class="btn btn-soft-blue btn-sm d-flex align-items-center rounded-2 hov-svg-white"
           href="products.create"
           data-toggle="tooltip"
           data-placement="bottom"
           title="<?= $this->lang->line('add_new') ?>">
          <span class="fw-500 mx-2 mr-0 d-none d-md-block">Add New</span>
          <i class="fa fa-plus fs-18"></i>
        </a>
      </div>
    </div>
  </div>

  <!-- Right: Action Buttons -->
  <div class="d-flex align-items-center">
    <!-- Fullscreen -->
    <div class="aiz-topbar-item mr-3 hide-mobile">
      <a onclick="openFullscreen();"
         class="btn btn-topbar btn-icon p-0 d-flex align-items-center justify-content-center"
         href="javascript:void(0);"
         aria-label="Fullscreen"
         data-toggle="tooltip"
         data-placement="bottom"
         title="<?= $this->lang->line('topbar_fullscreen') ?>">
        <i class="bi bi-arrows-fullscreen"></i>
      </a>
    </div>
    
    <!-- Dark Mode Toggle -->
    <div class="aiz-topbar-item mr-3 hide-mobile">
      <a data-theme-toggle id="darkModeToggle"
         class="btn btn-topbar btn-icon p-0 d-flex align-items-center justify-content-center"
         href="javascript:void(0);"
         aria-label="Toggle dark mode"
         data-toggle="tooltip"
         data-placement="bottom"
         title="<?= $this->lang->line('topbar_darkmode') ?>">
        <i id="darkModeIcon" class="bi bi-moon"></i>
      </a>
    </div>

     <!-- Sms Balance Circle -->
    <div class="aiz-topbar-item mr-3" id="smsBalanceContainer">
        <div id="smsBalanceCircle"
             class="sms-balance-badge"
             data-toggle="tooltip"
             data-placement="bottom">
            ...
        </div>
    </div>
    
    <!-- Academic Year Switcher (no calendar icon, just badge/button) -->
    <?php if(permissionChecker('schoolyear')): ?>
      <div class="aiz-topbar-item mr-3">
        <div data-toggle="tooltip"
             data-placement="bottom"
             title="<?= $this->lang->line('topbar_academic_year') ?>">
          <?php funtopbarschoolyear($siteinfos, $topbarschoolyears); ?>
        </div>
      </div>
    <?php endif; ?>
   

    <!-- Notification Bell (bell icon + notification count badge, own div) 
    <div class="aiz-topbar-item mr-3 position-relative">
      <div class="dropdown align-items-stretch d-flex">
        <a class="dropdown-toggle no-arrow bell-icon btn btn-icon p-0 d-flex align-items-center justify-content-center"
           data-toggle="dropdown"
           href="javascript:void(0);"
           role="button"
           aria-haspopup="false"
           aria-expanded="false"
           data-toggle="tooltip"
           data-placement="bottom"
           title="<?= $this->lang->line('view_more') ?>">
          <i class="bi bi-bell"></i>
          <span class="badge badge-danger topbar-badge"
                style="position: absolute; top: 3px; right: 3px; min-width: 1.1em; height: 1.1em; font-size: 0.74em; padding: 0 4px;">
            <?php echo isset($notificationCount) ? $notificationCount : 3; ?>
          </span>
        </a>
        <div class="dropdown-menu dropdown-menu-right dropdown-menu-animated dropdown-menu-xl py-0">
          <div class="notifications">
            <ul class="dropdown-menu my-push-message-ul" style="display:none">
              <li class='header my-push-message-number'></li>
              <li>
                <ul class="menu my-push-message-list"></ul>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>              -->

    <!-- Language Selector (optional) -->
    <?php if(isset($siteinfos->language_status) && $siteinfos->language_status == 0): ?>
      <div class="aiz-topbar-item mr-3 d-none d-md-block">
        <div class="align-items-stretch d-flex dropdown" id="lang-change">
          <a class="dropdown-toggle no-arrow btn btn-topbar btn-icon p-0 d-flex align-items-center"
             data-toggle="dropdown"
             href="javascript:void(0);"
             role="button"
             aria-haspopup="false"
             aria-expanded="false"
             data-toggle="tooltip"
             data-placement="bottom"
             title="<?= $this->lang->line('language') ?>">
            <img src="<?= base_url('uploads/language_image/'.$this->session->userdata('lang').'.png'); ?>"
                 height="18" alt="Lang">
          </a>
          <ul class="dropdown-menu dropdown-menu-right dropdown-menu-animated dropdown-menu-xs">
            <!-- ...language items here... -->
          </ul>
        </div>
      </div>
    <?php endif; ?>

    <!-- User Dropdown -->
    <div class="aiz-topbar-item">
      <div class="dropdown userbox">
        <a href="#" data-toggle="dropdown" class="user-top d-flex align-items-center" data-toggle="tooltip" data-placement="bottom" title="<?= $this->lang->line('profile') ?>">
          <img src="<?= imagelink($this->session->userdata('photo')) ?>"
               alt="user-image"
               class="user-avatar-top" />
        </a>
        <div class="dropdown-menu modern-user-dropdown py-3 px-2"
             style="min-width:250px; border-radius:12px; box-shadow: var(--box-shadow);">
          <!-- User Info -->
          <div class="user-info text-center mb-3">
            <img src="<?= imagelink($this->session->userdata('photo')) ?>"
                 alt="User Avatar"
                 class="user-avatar-dropdown mb-2" />
            <div class="user-details">
              <div class="font-weight-bold" style="font-size:1.12rem; color:#222;">
                <?= $this->session->userdata('name');?>
              </div>
              <div class="user-type text-muted" style="font-size:0.95rem;">
                <?= $this->session->userdata('usertype');?>
              </div>
            </div>
          </div>
          <!-- Menu Items -->
          <ul class="dropdown-user-menu list-unstyled mb-0">
            <li>
              <a href="<?= base_url('profile'); ?>" class="dropdown-item d-flex align-items-center py-2 px-3">
                <svg class="icon mr-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <circle cx="12" cy="7" r="4" stroke-width="2"/>
                  <path d="M5.5 19a6.5 6.5 0 0 1 13 0" stroke-width="2"/>
                </svg>
                <span><?= $this->lang->line('profile') ?></span>
              </a>
            </li>
            <li>
              <a href="<?= base_url('signin/cpassword'); ?>" class="dropdown-item d-flex align-items-center py-2 px-3">
                <svg class="icon mr-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <rect x="6" y="11" width="12" height="11" rx="2" stroke-width="2"/>
                  <path d="M12 7v4" stroke-width="2"/>
                  <circle cx="12" cy="4" r="2" stroke-width="2"/>
                </svg>
                <span><?= $this->lang->line('change_password') ?></span>
              </a>
            </li>
          </ul>
          <!-- Logout Button (no line above, full button hover, bigger font) -->
          <div class="px-2 mt-3">
            <a href="<?= base_url('signin/signout'); ?>"
               class="btn-logout">
              <?= $this->lang->line('logout') ?>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>