<script type="application/javascript">
$(function() {
    LoadEarningMonthly();
    function LoadEarningMonthly()
    {
        Highcharts.chart('earningGraph', {
            chart: {
                type: 'column',
                events: {
                    load: function() {
                        var chart = this;
                        var totalIncome = chart.series[0].data.reduce(function(total, dataPoint) {
                            return total + dataPoint.y;
                        }, 0);
                        var totalExpenses = chart.series[1].data.reduce(function(total, dataPoint) {
                            return total + dataPoint.y;
                        }, 0);
                        var revenue = totalIncome - totalExpenses;
                        
                        chart.setTitle(null, {
                            text: 'Total Income: ' + totalIncome + ' | Total Expenses: ' + totalExpenses + ' | Revenue: ' + revenue,
                            align: 'center',
                            y: 40,
                            style: {
                              fontWeight: 'bold',
                              fontSize: '16px'
                            }
                        });
                    }
                }
            },
            title: {
                text: '<?=getSchoolYear()?> <?=$this->lang->line("dashboard_earning_summary")?>'
            },
            xAxis: {
                categories: [
                    <?php
                        echo implode(',', pluck_bind($months, NULL, "'", "'"));
                    ?>
                ],
                title: {
                    text: '<?=$this->lang->line("dashboard_month")?>',
                    align: 'low',
                    enabled: false
                },
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: '<?=$this->lang->line("dashboard_amount")?>',
                    align: 'high',
                    enabled: false
                },
                labels: {
                    overflow: 'justify'
                }
            },
            // tooltip: {
            //     headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            //     pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            //     '<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
            //     footerFormat: '</table>',
            //     shared: true,
            //     useHTML: true
            // },
            plotOptions: {
                column: {
                pointPadding: 0.2,
                borderWidth: 0
                }
            },
            series: [{
                name: '<?=$this->lang->line("dashboard_income")?>',
                data: [
                    <?php
                        foreach ($months as $key => $month) {
                            if(isset($incomeMonthTotal[$key])) {
                                echo "{y:".$incomeMonthTotal[$key].", monthID:'".lzero($key)."', monthName:'".$month."', 'dayWiseData': '".json_encode($incomeMonthAndDay[$key])."', 'type': 'income'},";
                            } else {
                                echo "{y:0, monthID:'".lzero($key)."', monthName:'".$month."', 'dayWiseData': '{\"01\":0}', 'type': 'income'},";
                            }
                        }
                    ?>
                ]

            }, {
                name: '<?=$this->lang->line("dashboard_expense")?>',
                data: [
                    <?php
                        foreach ($months as $key => $month) {
                            if(isset($expenseMonthTotal[$key])) {
                                echo "{y:".$expenseMonthTotal[$key].", monthID:'".$key."', monthName:'".$month."', 'dayWiseData': '".json_encode($expenseMonthAndDay[$key])."', 'type': 'expense'},";
                            } else {
                                echo "{y:0, monthID:'".$key."', monthName:'".$month."', 'dayWiseData': '{\"01\":0}', 'type': 'expense'},";
                            }
                        }
                    ?>
                ]
            }]

        });

    }

});
</script>