<form role="form" method="post" id="payment-form">
    <input type="hidden" name="payment_type" id="payment_type_field" value="payment">
<div class="row">
    <div class="col-sm-3">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title"><i class="fa icon-invoice"></i> <?=$this->lang->line('invoice_payment')?></h3>
            </div>

            <div class="box-body box-profile">
                <center>
                <?=profileviewimage($studentprofile->photo)?>
                </center>

                <h3 class="profile-username text-center"><?=$student->srname?></h3>

                <p class="text-muted text-center"><?=$usertype->usertype?></p>

                <ul class="list-group list-group-unbordered">
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_registerno')?></b> <a class="pull-right"><?=$student->srregisterNO?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_roll')?></b> <a class="pull-right"><?=$student->srroll?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_class')?></b> <a class="pull-right"><?=customCompute($class) ? $class->classes : ''?></a>
                    </li>
                    <li class="list-group-item" style="background-color: #FFF">
                        <b><?=$this->lang->line('invoice_section')?></b> <a class="pull-right"><?=customCompute($section) ? $section->section : ''?></a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="box" style="margin-bottom:40px">
            <div class="box-header">
                <h3 class="box-title"><i class="fa fa-money"></i> <?=$this->lang->line('panel_title')?></h3>
            </div>
            <div class="box-body">
                <div class="form-group <?=form_error('paymentmethodID') ? 'has-error' : '' ?>">
                    <label for="paymentmethodID"><?=$this->lang->line('invoice_paymentmethod')?> <span class="text-red">*</span></label>
                    <?php
                        $paymentmethodArray['0'] = $this->lang->line("invoice_select_paymentmethod");
                        if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) {
                            $paymentmethodArray['Wallet'] = $this->lang->line('Wallet');
                        }
                        if ($payment_settings['paypal_status'] == true) {
                            $paymentmethodArray['Paypal'] = $this->lang->line('Paypal');
                        }
                        if ($payment_settings['stripe_status'] == true) {
                            $paymentmethodArray['Stripe'] = $this->lang->line('Stripe');
                        }
                        if ($payment_settings['payumoney_status'] == true) {
                            $paymentmethodArray['Payumoney'] = $this->lang->line('PayUMoney');
                        }
                        if ($payment_settings['voguepay_status'] == true) {
                            $paymentmethodArray['Voguepay'] = $this->lang->line('Voguepay');
                        }
                        echo form_dropdown("paymentmethodID", $paymentmethodArray, set_value("paymentmethodID"), "id='paymentmethodID' class='form-control select2' onchange='CheckType()'");
                    ?>
                    <span class="text-red">
                        <?=form_error('paymentmethodID')?>
                    </span>
                </div>

                <div id="cardOption" style="display: none; margin-bottom:40px">
                    <div id="card-element" style="padding: 8px;border: 1px solid #ddd;"></div>
                    <div id="card-errors" class="text-danger" role="alert"></div>
                </div>

                <div id="payuInputs" style="display: none;">
                    <div class="form-group <?=form_error('first_name') ? 'has-error' : ''; ?>" >
                        <label for="first_name"><?=$this->lang->line("first_name")?></label>
                        <input type="text" class="form-control" id="first_name" name="first_name" value="<?=set_value('first_name', null)?>" >
                        <span class="text-red">
                            <?php echo form_error('first_name'); ?>
                        </span>
                    </div>
                    <div class="form-group <?=form_error('email') ? 'has-error' : ''; ?>" >
                        <label for="email"><?=$this->lang->line("email")?></label>
                        <input type="text" class="form-control" id="email" name="email" value="<?=set_value('email', null)?>" >
                        <span class="text-red"><?php echo form_error('email'); ?></span>
                    </div>
                    <div class="form-group <?=form_error('phone') ? 'has-error' : ''; ?>" >
                        <label for="phone" ><?=$this->lang->line("phone")?></label>
                        <input type="text" class="form-control" id="phone" name="phone" value="<?=set_value('phone', null)?>" >
                        <span class="text-red">
                            <?php echo form_error('phone'); ?>
                        </span>
                    </div>
                </div>

                <div class="btn-group">
                    <button type="button" class="btn btn-success" id="payment-mode-btn">
                        <i class="fa fa-money"></i> <?=$this->lang->line('add_payment')?>
                    </button>
                    <button type="button" class="btn btn-warning" id="waiver-mode-btn">
                        <i class="fa fa-gift"></i> Add Waiver
                    </button>
                    <button type="submit" class="btn btn-primary" id="submit-btn" style="display: none;">
                        <i class="fa fa-save"></i> Submit
                    </button>
                </div>

            </div>
        </div>
    </div>

    <div class="col-sm-9">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title"><i class="fa icon-feetypes"></i> <?=$this->lang->line('invoice_feetype_list')?></h3>
                <ol class="breadcrumb">
                    <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
                    <li><a href="<?=base_url("invoice/index")?>"><?=$this->lang->line('menu_invoice')?></a></li>
                    <li class="active"><?=$this->lang->line('menu_add')?> <?=$this->lang->line('invoice_payment')?></li>
                </ol>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-bordered feetype-style" style="font-size: 16px;">
                        <thead>
                            <tr>
                                <th class="col-sm-1"><?=$this->lang->line('slno')?></th>
                                <th class="col-sm-3"><?=$this->lang->line('invoice_feetype')?></th>
                                <th class="col-sm-1" ><?=$this->lang->line('invoice_amount')?></th>
                                <th class="col-sm-1" ><?=$this->lang->line('invoice_due')?></th>
                                <th class="col-sm-2 payment-field"><?=$this->lang->line('invoice_paid_amount')?></th>
                                <?php if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) { ?>
                                    <th class="col-sm-2 waiver-field" style="display: none;"><?=$this->lang->line('invoice_weaver')?></th>
                                    <th class="col-sm-2 payment-field"><?=$this->lang->line('invoice_fine')?></th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody id="feetypeList">
                            <?php
                                $totalAmount = 0;
                                $totalDue = 0;
                                if(customCompute($invoices)) {
                                    $i = 1;
                                    foreach ($invoices as $invoice) {
                                        $amount = $invoice->amount;
                                        $due = 0;

                                        if(isset($invoicepaymentandweaver['totalamount'][$invoice->invoiceID])) {
                                            $due = $invoicepaymentandweaver['totalamount'][$invoice->invoiceID];

                                            if(isset($invoicepaymentandweaver['totaldiscount'][$invoice->invoiceID])) {
                                                $due =  ($due -$invoicepaymentandweaver['totaldiscount'][$invoice->invoiceID]);
                                            }

                                            if(isset($invoicepaymentandweaver['totalpayment'][$invoice->invoiceID])) {
                                                $due = ($due - $invoicepaymentandweaver['totalpayment'][$invoice->invoiceID]);
                                            }

                                            if(isset($invoicepaymentandweaver['totalweaver'][$invoice->invoiceID])) {
                                                $due = ($due - $invoicepaymentandweaver['totalweaver'][$invoice->invoiceID]);
                                            }
                                        }
                                        $totalAmount += $amount;
                                        $totalDue += $due;
                                        $rand = rand(1, 9999999999);

                                        echo '<tr id="tr_'.$rand.'">';
                                            echo '<td>';
                                                echo $i;
                                            echo '</td>';

                                            echo '<td>';
                                                echo isset($feetypes[$invoice->feetypeID]) ? $feetypes[$invoice->feetypeID] : '';
                                            echo '</td>';

                                            echo '<td>';
                                                echo $amount;
                                            echo '</td>';

                                            echo '<td id="due_'.$rand.'">';
                                                echo $due;
                                            echo '</td>';

                                            $disabled = ($this->session->userdata('user')->usertypeID != 1 && $this->session->userdata('user')->usertypeID != 5) ? 'disabled' : '';
                                            echo '<td class="payment-field">';
                                            echo '<input id="paidamount_'.$rand.'" class="form-control change-paidamount '.(form_error('paidamount_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="paidamount_'.$invoice->invoiceID.'" value="'.set_value('paidamount_'.$invoice->invoiceID).'" '.$disabled.'>';
                                            echo '</td>';

                                            if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) {
                                                echo '<td class="waiver-field" style="display: none;">';
                                                echo '<input id="weaver_'.$rand.'" class="form-control change-weaver '.(form_error('weaver_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="weaver_'.$invoice->invoiceID.'" value="'.set_value('weaver_'.$invoice->invoiceID).'" >';
                                                echo '<textarea class="form-control waiver-reason" name="waiver_reason_'.$invoice->invoiceID.'" placeholder="Waiver reason" style="margin-top: 5px; display: none; font-size: 12px; height: 60px;"></textarea>';
                                                echo '</td>';

                                                echo '<td class="payment-field">';
                                                echo '<input id="fine_'.$rand.'" class="form-control change-fine '.(form_error('fine_'.$invoice->invoiceID) ? 'bordered-red' : '').'" type="text" name="fine_'.$invoice->invoiceID.'" value="'.set_value('fine_'.$invoice->invoiceID).'" >';
                                                echo '</td>';
                                            }
                                        echo '</tr>';
                                        $i++;
                                    }
                                }
                            ?>
                        </tbody>
                        <tfoot id="feetypeListFooter">
                            <tr>
                                <td colspan="2" style="font-weight: bold"><?=$this->lang->line('invoice_total')?></td>
                                <td id="totalAmount" style="font-weight: bold"><?=number_format($totalAmount, 2);?></td>
                                <td id="totalDue" style="font-weight: bold"><?=number_format($totalDue, 2);?></td>
                                <td id="totalPaidAmount" class="payment-field" style="font-weight: bold">0.00</td>
                                <?php if($this->session->userdata('usertypeID') == 1 || $this->session->userdata('usertypeID') == 5) { ?>
                                    <td id="totalWeaver" class="waiver-field" style="font-weight: bold; display: none;">0.00</td>
                                    <td id="totalFine" class="payment-field" style="font-weight: bold">0.00</td>
                                <?php } ?>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</form>

<script>
    var originalDueAmounts = {};
    function updateDueAmount(rowId) {
        var paidAmount = parseFloat($('#paidamount_' + rowId).val()) || 0;
        var weaverAmount = parseFloat($('#weaver_' + rowId).val()) || 0;
        if (!originalDueAmounts[rowId]) return;
        var updatedDueAmount = originalDueAmounts[rowId] - paidAmount - weaverAmount;
        if (updatedDueAmount < 0) updatedDueAmount = 0;
        $('#due_' + rowId).text(updatedDueAmount.toFixed(2));
        updateTotalDue();
    }
    function updateTotalDue() {
        var totalDue = 0;
        $('#feetypeList tr').each(function() {
            var rowId = $(this).attr('id').split('_')[1];
            var paidAmount = parseFloat($('#paidamount_' + rowId).val()) || 0;
            var weaverAmount = parseFloat($('#weaver_' + rowId).val()) || 0;
            var currentDue = originalDueAmounts[rowId] - paidAmount - weaverAmount;
            if(currentDue < 0) currentDue = 0;
            totalDue += currentDue;
        });
        $('#totalDue').text(totalDue.toFixed(2));
    }

    $(document).ready(function() {
        $('#feetypeList tr').each(function () {
            var rowId = $(this).attr('id').split('_')[1];
            var dueAmount = parseFloat($('#due_' + rowId).text());
            if (!isNaN(dueAmount)) {
                originalDueAmounts[rowId] = dueAmount;
            }
        });

        $('#payment-mode-btn').on('click', function() {
            toggleFormMode('payment');
        });

        $('#waiver-mode-btn').on('click', function() {
            toggleFormMode('waiver');
        });
    });

    function toggleFormMode(mode) {
        var form = $('#payment-form');
        var paymentFields = $('.payment-field, .change-paidamount, .change-fine');
        var waiverFields = $('.waiver-field, .change-weaver');
        var submitBtn = $('#submit-btn');
        var paymentMethodDropdown = $('#paymentmethodID');
        var paymentModeBtn = $('#payment-mode-btn');
        var waiverModeBtn = $('#waiver-mode-btn');

        if (mode === 'waiver') {
            paymentFields.hide();
            waiverFields.show();
            paymentMethodDropdown.prop('disabled', true);
            submitBtn.show().text('Submit Waiver');
            $('#payment_type_field').val('waiver');
            paymentModeBtn.removeClass('btn-success').addClass('btn-default');
            waiverModeBtn.removeClass('btn-default').addClass('btn-warning');
        } else {
            paymentFields.show();
            waiverFields.hide();
            paymentMethodDropdown.prop('disabled', false);
            submitBtn.show().text('Submit Payment');
            $('#payment_type_field').val('payment');
            paymentModeBtn.removeClass('btn-default').addClass('btn-success');
            waiverModeBtn.removeClass('btn-warning').addClass('btn-default');
        }

        // Reset inputs and totals
        $('.change-paidamount').val('');
        $('.change-weaver').val('');
        $('.change-fine').val('');
        totalInfo();
        updateTotalDue();
    }
</script>

<script type="text/javascript">
    window.onload = function() {
        CheckType();
        toggleFormMode('payment'); // Initialize form in payment mode
    };
    function CheckType() {
        var payment_method = $('#paymentmethodID').val();

        $('#cardOption').hide();
        $('#payuInputs').hide();
    }


    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function (event) {
        var payment_method = $('#paymentmethodID').val();
        if ($('#payment_type_field').val() === 'payment' && payment_method == "Stripe") {
            // Your existing Stripe logic
        } else {
            form.submit();
        }
    });

    function dd(data) {
        console.log(data);
    }

    $('.select2').select2();

    function getRandomInt() {
      return Math.floor(Math.random() * Math.floor(9999999999999999));
    }

    function toFixedVal(x) {
      if (Math.abs(x) < 1.0) {
        var e = parseFloat(x.toString().split('e-')[1]);
        if (e) {
            x *= Math.pow(10,e-1);
            x = '0.' + (new Array(e)).join('0') + x.toString().substring(2);
        }
      } else {
        var e = parseFloat(x.toString().split('+')[1]);
        if (e > 20) {
            e -= 20;
            x /= Math.pow(10,e);
            x += (new Array(e+1)).join('0');
        }
      }
      return x;
    }

    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }

    function dotAndNumber(data) {
        var retArray = [];
        var fltFlag = true;
        if(data.length > 0) {
            for(var i = 0; i <= (data.length-1); i++) {
                if(i == 0 && data.charAt(i) == '.') {
                    fltFlag = false;
                    retArray.push(true);
                } else {
                    if(data.charAt(i) == '.' && fltFlag == true) {
                        retArray.push(true);
                        fltFlag = false;
                    } else {
                        if(isNumeric(data.charAt(i))) {
                            retArray.push(true);
                        } else {
                            retArray.push(false);
                        }
                    }

                }
            }
        }

        if(jQuery.inArray(false, retArray) ==  -1) {
            return true;
        }
        return false;
    }

    function floatChecker(value) {
        var val = value;
        if(isNumeric(val)) {
            return true;
        } else {
            return false;
        }
    }

    function lenChecker(data, len) {
        var retdata = 0;
        var lencount = 0;
        data = toFixedVal(data);
        if(data.length > len) {
            lencount = (data.length - len);
            data = data.toString();
            data = data.slice(0, -lencount);
            retdata = parseFloat(data);
        } else {
            retdata = parseFloat(data);
        }

        return toFixedVal(retdata);
    }
    
    function parseSentenceForNumber(sentence) {
        var matches = sentence.replace(/,/g, '').match(/(\+|-)?((\d+(\.\d+)?)|(\.\d+))/);
        return matches && matches[0] || null;
    }

    function currencyConvert(data) {
        return data.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
    }

    var globaltotalpaidamount = 0;
    var globaltotalweaver = 0;
    var globaltotalfine = 0;
    function totalInfo() {
        var totalPaidAmount = 0;
        var totalWeaver = 0;
        var totalFine = 0;
        
        $('#feetypeList tr').each(function(index, value) {
            if($(this).children().eq(4).children().val() != '' && $(this).children().eq(4).children().val() != null && $(this).children().eq(4).children().val() != '.') {
                var paidamount = parseFloat($(this).children().eq(4).children().val());
                totalPaidAmount += paidamount;
            }

            if($(this).children().eq(5).children().val() != '' && $(this).children().eq(5).children().val() != null && $(this).children().eq(5).children().val() != '.') {
                var weaver = parseFloat($(this).children().eq(5).children().val());
                totalWeaver += weaver;
            }

            if($(this).children().eq(6).children().val() != '' && $(this).children().eq(6).children().val() != null && $(this).children().eq(6).children().val() != '.') {
                var fine = parseFloat($(this).children().eq(6).children().val());
                totalFine += fine;
            }
        });

        globaltotalpaidamount = totalPaidAmount;
        $('#totalPaidAmount').text(currencyConvert(totalPaidAmount));

        globaltotalweaver = totalWeaver;
        $('#totalWeaver').text(currencyConvert(totalWeaver));

        globaltotalfine = totalFine;
        $('#totalFine').text(currencyConvert(totalFine));
    }
    $(document).on('keyup', '.change-paidamount', function () {
        var rowId = $(this).attr('id').split('_')[1];
        var paidAmount = parseFloat($(this).val()) || 0;

        if (paidAmount > originalDueAmounts[rowId]) {
            $(this).val(originalDueAmounts[rowId].toFixed(2));
            paidAmount = originalDueAmounts[rowId];
        }

        updateDueAmount(rowId);
        totalInfo();
    });

    $(document).on('keyup', '.change-weaver', function() {
        var trID = $(this).parent().parent().attr('id').replace('tr_','');
        var due = originalDueAmounts[trID];
        var paidamount = parseFloat($('#paidamount_'+trID).val()) || 0;
        var weaver = parseFloat($(this).val()) || 0;
        var remainingDue = due - paidamount;

        if (weaver > remainingDue) {
            $(this).val(remainingDue.toFixed(2));
            weaver = remainingDue;
        }

        updateDueAmount(trID);
        totalInfo();
        
        var reasonField = $(this).siblings('.waiver-reason');
        if (weaver > 0) {
            reasonField.show();
        } else {
            reasonField.hide();
        }
    });

    $(document).on('keyup', '.change-fine', function() {
        var fine = $(this).val();

        var dotandnumberstatus = false;
        var finestatus = false;

        if(dotAndNumber(fine)) {
            dotandnumberstatus = true;
        } else {
            dotandnumberstatus = false;
            $(this).val(parseSentenceForNumber(toFixedVal(fine)));
        }

        if(dotandnumberstatus) {
            if(fine.length > 15) {
                fine = lenChecker(fine, 15);
                $(this).val(fine);
                finestatus = true;
            } else {
                finestatus = true;
            }

            totalInfo();
        }
    });

    totalInfo();
</script>