<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa icon-attendance"></i> <?=$this->lang->line('panel_title')?></h3>

        <ol class="breadcrumb">
            <li><a href="<?= base_url("dashboard/index") ?>"><i class="fa fa-laptop"></i> <?= $this->lang->line('menu_dashboard') ?></a></li>
            <li class="active"><?= $this->lang->line('lunch_add') ?> <?= $this->lang->line('lunch_qrattendance') ?></li>
        </ol>
    </div>
    <div class="box-body">
        <div class="row qrcode-scan">
            <div class="col-sm-4">
                <div class="box mt-md">
                    <div class="form-group text-left">
                        <label for="custom_amount">Custom Amount</label>
                        <input type="text" class="form-control" id="custom_amount" name="custom_amount" autocomplete="off">
                    </div> 
                    <hr>
                    <div class="form-group">
                        <span class="title"><?=$this->lang->line('scan_qr_code')?></span>
                        <div class="justify-content-md-center" id="reader" width="300px" height="300px"></div>
                        <span class="text-center" id='qr_status'><?=$this->lang->line('scanning')?></span>
                        <div class="radio-custom radio-success radio-inline mt-md">
                            <input type="radio" value="break" checked name="lunch_break" id="break">
                            <label for="break"><?=$this->lang->line('break')?></label>
                        </div>
                        <div class="radio-custom radio-success radio-inline mt-md">
                            <input type="radio" value="lunch" name="lunch_break" id="lunch">
                            <label for="lunch"><?=$this->lang->line('lunch')?></label>
                        </div>
						<div class="mt-md">
							<button id="flipCameraFront" class="btn btn-primary">Front Cam</button>
							<button id="flipCameraBack" class="btn btn-primary">Back Cam</button>
						</div>
                    </div>                    
                </div>       
            </div>			
            <div class="col-sm-4">
				<div class="box mt-md" style="height:485px; text-align: left;">
				    <span class="title"><?=$this->lang->line('custom_entry')?></span>
					<div class="box-body">
						<form method="post" id="lunchForm">
							<div class="form-group">
								<div class="radio-custom radio-success radio-inline mt-md">
									<input type="radio" value="break" checked name="lunch_break1" id="break1">
									<label for="break1"><?=$this->lang->line('break')?></label>
								</div>
								<div class="radio-custom radio-success radio-inline mt-md">
									<input type="radio" value="lunch" name="lunch_break1" id="lunch1">
									<label for="lunch1"><?=$this->lang->line('lunch')?></label>
								</div>
							</div>
							<!-- <div class="row"> -->
								<div class="form-group">
									<label for="admissionNumber">Admission Number:</label>
									<input type="text" class="form-control" id="admissionNumber" name="admissionNumber" autocomplete="off">
								</div>
								
								<div class="form-group">
									<label for="lunchAmount">Lunch Amount:</label>
									<input type="text" class="form-control" id="lunchAmount" name="custom_amount" autocomplete="off">
								</div>
							<!-- </div> -->
							<div class="form-group">
								<button type="submit" class="btn btn-primary">Submit</button>
							</div>
						</form>
                    </div> 
					<div class="box-body" style="bottom:0;border: 1px solid #4b4b4b;">
						<p> Use this custom entry section if the student doesn't have an ID card.</p>
					</div>
                </div>                
            </div>
			<div class="col-sm-4">
				<div class="box mt-md" style="height:485px; text-align: left;">
				    <span class="title"><?=$this->lang->line('scanned_details')?></span>
					<div class="box-body">
                        <div class="box-layout" id="attendence_res" style="display: none;"></div>
                    </div>                    
                </div>
			</div>
        </div>
    </div>
</div>

<audio id="successAudio">
  <source src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/success.mp3') ?>" type="audio/ogg">
</audio>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/qrcode.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/js/qrcode_attendance.js'); ?>"></script>
<script type="text/javascript">
	var statusMatched = "<?=$this->lang->line('matched')?>";
	var statusScanning = "<?=$this->lang->line('scanning')?>";
	$("#qr_status").css("background", "green");
	// $(document).ready(function() {
	// 	   initDatatable('.table-question', 'qrcode_attendance/getStaffListDT');
	// });

	var x = document.getElementById("successAudio");
	var lastResult, modalOpen = 0;
	const html5QrCode = new Html5Qrcode("reader");
	const qrCodeSuccessCallback = (decodedText, decodedResult) => {
		
		if (decodedText !== lastResult && modalOpen == 0) {
			var inOutTime = $('input[name="lunch_break"]:checked').val();
        	var custom_amount = $('#custom_amount').val();
			x.play();
			lastResult = decodedText;
            // getID(lastResult);
            submitQR(inOutTime, custom_amount);	
	    	html5QrCode.clear();
		}
	};

	const formatsToSupport = [
		Html5QrcodeSupportedFormats.QR_CODE,
	];

	var config = { fps: 50, qrbox: 200};
	if($(window).width()  <= '400'){
		config = { fps: 50, qrbox: 150};
	}
	if($(window).width()  <= '370'){
		config = { fps: 50, qrbox: 120};
	}

	function startCamera(cameraFacingMode) {
        html5QrCode.start({ facingMode: cameraFacingMode }, config, qrCodeSuccessCallback).catch((err) => {
            $("#qr_status").css("background", "red");
            $("#reader").addClass("camera-preview").html(cameraFacingMode + " camera not found.");
            $("#qr_status").html(err);
            alert(cameraFacingMode + ' camera not found.');
            console.log(err);
        });
    }

    // Start with the back camera
    startCamera("environment");

    // Event listeners for the camera flip buttons
    document.getElementById("flipCameraFront").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("user");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

	document.getElementById("flipCameraBack").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("environment");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

	// attendance stored in the database
	function submitQR(inOutTime, custom_amount, qr) {	    
	    $.ajax({
	        type: 'post',
	        url: "<?= base_url('lunch/lunch_break'); ?>",
	        data: {
                'qr_token' : lastResult,
                'lunch_break': inOutTime,
                'custom_amount': custom_amount
            },
	        dataType: 'json',
	        beforeSend: function () {
				if(qr){
					$("#qr_status").css("background", "blue");
					$("#qr_status").html('Processing..');
				}	            
	        },
	        success: function (response) {
				if(qr){
					$("#qr_status").css("background", "green");
				}
	        	if(response.status=='error'){
                           
                    $('#attendence_res').html("<table class='table table-responsive'>"+
                    "<tr><th class='danger text-center' colspan='2'><span><strong>"+response.message+"</strong><span></th></tr>"+
                    "</table>")
                    $('#attendence_res').show();
                } else {
                    console.log(response);
                    $('#attendence_res').html("<table class='table table-responsive'>"+
                    "<tr><td colspan='2'>"+response.photo+"</td></tr>"+
                    "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                    "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                    "<tr><td><strong><h5>ADM No:</h5></strong></td><td><h5>"+ ((response.adm) ? response.adm : '-')+"</h5></td></tr>"+
                    "<tr><td><strong><h5>Meal:</h5></strong></td><td><h5>"+ ((response.lunch_break) ? response.lunch_break : '-')+"</h5></td></tr>"+
                    "<tr><td><strong><h5>Reference No:</h5></strong></td><td><h5>"+ ((response.ref) ? response.ref : '-')+"</h5></td></tr>"+
                    "<tr><td><strong><h5>Time:</h5></strong></td><td><h5>"+ ((response.time) ? response.time : '-')+"</h5></td></tr>"+"</table>");
                            
                    $('#attendence_res').show();
                }
				if(qr){
					$("#qr_status").html(statusScanning);
				}
	        },
	        complete: function (data) {
				if(qr){
					$("#qr_status").css("background", "green");
	    			$("#qr_status").html(statusMatched);
				}
				$('#attendence_res').show();
				$('#admissionNumber').val('');
				$('#lunchAmount').val('');
	        },
	        error: function () {
				$('#attendence_res').show();
				$('#admissionNumber').val('');
				$('#lunchAmount').val('');
				if(qr){
					$("#qr_status").css("background", "red");
					$("#qr_status").html('An error Occurred');
				}
	        }
	    });
	}

	$('.modal-dismiss').on('click', function() {
		end_loader()
	});

	$('input[name="lunch_break"]').on('change', function() {
		end_loader()
	});

	$(document).ready(function() {
          $('#lunchForm').submit(function(event) {
            event.preventDefault();
        
            var inOutTime = $('input[name="lunch_break1"]:checked').val();
			lastResult = 'S-'+$('#admissionNumber').val();
			var custom_amount= $('#lunchAmount').val();
			
			submitQR(inOutTime, custom_amount, false);
          });
    });
</script>


