<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>SKOOLY ID CARD - BACK</title>
    <style>
        body {
            background: #f1f2f7;
            font-family: "Nunito", sans-serif;
            margin: 0;
            padding: 0;
            font-size: 7.5pt;
        }
        .clear { clear: both; }
        .id-card-holder {
            width: 338px;
            height: 214px;
            max-width: 338px;
            max-height: 214px;
            min-width: 338px;
            min-height: 214px;
            margin: 0 auto 15px auto;
            font-family: "Nunito", sans-serif;
            box-sizing: border-box;
        }
        .id-card {
            width: 100%;
            height: 100%;
            background-color: #fff;
            padding: 0px;
            text-align: center;
            box-shadow: 0 7.5px 11px -2.2px rgba(0, 0, 0, 0.1), 0 2.8px 4.2px -1.8px rgba(0, 0, 0, 0.05);
            display: block;
            border-radius: 0.375rem;
            overflow: hidden;
            box-sizing: border-box;
        }
        .header {
            background-color: #fff;
            border-bottom: 3pt solid #202020;
            padding-top: 2.6pt 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .header-spacer { flex-grow: 1; }
        .sc-logo { width: 37.5px; height: 37.5px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; margin-right: 19.6pt; }
        .sc-logo img { max-width: 100%; max-height: 100%; object-fit: contain; }
        .head-info { flex-grow: 1; text-align: center; color: #006341; }
        .head-info h3 { font-size: 10.5pt; margin: 0 0 1.7pt 0; color: #000; text-transform: uppercase; font-weight: 700; }
        .contact-info { display: flex; justify-content: center; align-items: center; flex-wrap: wrap; margin-top: 2.8pt; }
        .contact-info h5 { font-size: 7pt; margin: 0 4.5pt; color: #555; font-weight: normal; display: flex; align-items: center; white-space: nowrap; }
        .contact-info h5 i { margin-right: 2.8pt; color: #333; font-size: 5.8pt; }
        .b-border { width: 100%; height: 1pt; display: block; background-color: #202020; margin-top: 0.5pt; }
        .card-detail {
            width: 100%;
            height: 100%; /* 214 - header - borders - paddings */
            max-height: 100%;
            min-height: 133px;
            display: flex;
            box-sizing: border-box;
            align-items: flex-start;
            padding: 1pt;
            margin-top: -5.6pt;
            margin-bottom: 11.2pt;
            overflow: hidden;
        }
        .card-back-content {
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            overflow: hidden;
        }
        .back-qr {
            margin: 8pt 0 3pt 0;
            flex-shrink: 0;
        }
        .back-qr img {
            width: 80px;
            height: 80px;
            border-radius: 10px;
            border: 1.2pt solid #ddd;
            background: #fff;
            object-fit: contain;
        }
        .back-info {
            font-size: 6pt;
            color: #222;
            text-align: center;
            width: 95%;
            margin: 0 auto 1pt auto;
            line-height: 1.1;
            font-style: italic;
            flex-shrink: 0;
        }
        .software-icon {
            margin: 6pt 0 0 0;
            display: flex;
            justify-content: center;
            flex-shrink: 0;
        }
        .software-icon img {
            max-width: 28px;
            max-height: 28px;
            width: auto;
            height: auto;
            object-fit: contain;
            display: block;
        }
        .no-print { display: block; }
        @media print {
            @page {
                size: 3.375in 2.125in;
                margin: 0;
            }
            .id-card-holder {
                width: 3.375in !important;
                height: 2.125in !important;
                max-width: 3.375in !important;
                max-height: 2.125in !important;
                min-width: 3.375in !important;
                min-height: 2.125in !important;
                margin: 0 !important;
                padding: 0 !important;
                page-break-after: always !important;
                box-sizing: border-box !important;
                border: none !important;
                box-shadow: none !important;
                background-color: #fff !important;
                overflow: hidden !important;
                position: relative;
                float: none !important;
                display: block !important;
            }
            .no-print { display: none !important; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin:15px 0; text-align:center;">
        <button onclick="printDiv('printablediv')" style="padding:7px 15px; font-size:12px;">Print / Save as PDF</button>
        <p style="color: #666; font-size:9px; margin-top:6px;">Tip: In the print dialog, set Paper Size to <b>Custom</b> (3.375in × 2.125in), Margins to <b>None</b>, and "Background graphics" ON for best results.</p>
    </div>
    <div id="printablediv">
        <?php foreach($idcards as $idcard) { ?>
        <div class="id-card-holder">
            <div class="id-card">
                <div class="header">
                    <div class="header-spacer"></div>
                    <div class="sc-logo">
                        <img src="<?=base_url('uploads/images/'.$siteinfos->photo)?>" alt="School Logo">
                    </div>
                    <div class="head-info">
                        <h3><?=htmlspecialchars($siteinfos->sname)?></h3>
                        <div class="contact-info">
                            <h5><i class="fa fa-map-marker"></i> <span><?=htmlspecialchars($siteinfos->address)?></span></h5>
                            <h5><i class="fa fa-phone"></i> <span><?=htmlspecialchars($siteinfos->phone)?></span></h5>
                        </div>
                    </div>
                    <div class="header-spacer"></div>
                </div>
                <span class="b-border"></span>
                <div class="clear"></div>
                <div class="card-detail">
                    <div class="card-back-content">
                        <!-- School QR code (static for all, e.g. demo.skooly.co.ke) -->
                        <div class="back-qr">
                            <img src="<?=base_url('uploads/qr/shorturl.png')?>" alt="School QR">
                        </div>
                        <!-- 'If found' message -->
                        <div class="back-info">
                            <?php if(!empty($siteinfos->iffound)): ?>
                                <?=htmlspecialchars($siteinfos->iffound)?>
                            <?php endif; ?>
                        </div>
                        <!--
                        <div>
                            <h5><?=htmlspecialchars($siteinfos->motto)?></h5>
                        </div>  -->
                        <!-- Software icon (if available) -->
                        <?php if(!empty($siteinfos->softwareicon)): ?>
                        <div class="software-icon">
                            <img src="<?=base_url('uploads/default/'.$siteinfos->softwareicon)?>" alt="Software Icon">
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <script type="text/javascript">
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var printWindow = window.open('', '_blank', 'height=750,width=1000');
        printWindow.document.write('<html><head><title>SKOOLY ID Cards (Back)</title>');
        // Copy all style/link tags from parent
        var stylesheets = document.querySelectorAll('style, link[rel="stylesheet"]');
        stylesheets.forEach(function(sheet) {
            printWindow.document.write(sheet.outerHTML);
        });
        printWindow.document.write('</head><body>');
        printWindow.document.write(printContents);
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        printWindow.onload = function() {
            printWindow.focus();
            printWindow.print();
        };
    }
    </script>
    
</body>
</html>